---
generated_at: 2026-01-30 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Profview.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/profview/index.html` (HTMLソースファイル)
- E-02: `deps/v8/tools/profview/profview.js` (メインJSファイル)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProfviewはV8プロファイリングログをビジュアライズするツールである | E-01 (Line 10: title), E-03 | ○ |
| C-02 | 画面タイトルは"V8 Tick Processor"である | E-01 (Line 10) | ○ |
| C-03 | body.onLoadでmain.onLoad()が呼ばれる | E-01 (Line 20) | ○ |
| C-04 | body.onResizeでmain.onResize()が呼ばれる | E-01 (Line 20) | ○ |
| C-05 | fileinputでファイル選択を行う | E-01 (Line 25) | ○ |
| C-06 | d8 --profでプロファイル記録する説明がある | E-01 (Lines 36-38) | ○ |
| C-07 | linux-tick-processor --preprocessでJSONに変換する説明がある | E-01 (Lines 43-45) | ○ |
| C-08 | Chrome用のフラグ説明（--no-sandbox --js-flags=--prof）がある | E-01 (Lines 53-55) | ○ |
| C-09 | Android用のフラグ説明（--single-process）がある | E-01 (Lines 57-60) | ○ |
| C-10 | timeline-canvas要素が存在する | E-01 (Line 73) | ○ |
| C-11 | timeline-legend要素が存在する | E-01 (Lines 76-77) | ○ |
| C-12 | show-loggingチェックボックスが存在する | E-01 (Line 78) | ○ |
| C-13 | calltree-attribution選択が存在する | E-01 (Lines 96-97) | ○ |
| C-14 | calltree-categories選択が存在する | E-01 (Lines 98-100) | ○ |
| C-15 | calltree-sort選択が存在する | E-01 (Lines 101-103) | ○ |
| C-16 | calltree-tableテーブルが存在する | E-01 (Lines 108-122) | ○ |
| C-17 | createViews()で6つのビューコンポーネントを生成する | E-02 (Lines 18-27) | ○ |
| C-18 | emptyState()で初期状態を定義する | E-02 (Lines 29-49) | ○ |
| C-19 | setMode()でモード変更を行う | E-02 (Lines 61-94) | ○ |
| C-20 | setCallTreeAttribution()で帰属変更を行う | E-02 (Lines 96-103) | ○ |
| C-21 | setViewInterval()で時間範囲変更を行う | E-02 (Lines 123-130) | ○ |
| C-22 | 機能No.36(v8)、29(perf_hooks)、1(fs)が関連する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードまたはドキュメントによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/profview/index.html）の存在確認
- [ ] profview.jsのmainオブジェクト初期化確認
- [ ] ファイル選択によるJSON読み込み動作確認
- [ ] コールツリー表示の動作確認
- [ ] タイムライン描画の動作確認
