---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Turbolizer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/turbolizer/index.html` (HTMLソースファイル)
- E-02: `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` (メインTSファイル)
- E-03: `deps/v8/tools/turbolizer/info-view.html` (キーボードショートカットHTML)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TurbolizerはTurboFanグラフを可視化するツールである | E-01 (Line 11: title), E-04 | ○ |
| C-02 | 画面タイトルは"V8 Turbolizer"である | E-01 (Line 11) | ○ |
| C-03 | build/turbolizer.jsを読み込む | E-01 (Line 55) | ○ |
| C-04 | upload-helperでファイル入力を行う | E-01 (Line 25) | ○ |
| C-05 | uploadボタンでファイル選択をトリガー | E-01 (Line 26) | ○ |
| C-06 | historyペインが存在する | E-01 (Line 20) | ○ |
| C-07 | rangesペインが存在する | E-01 (Line 29) | ○ |
| C-08 | resizer-left/rightが存在する | E-01 (Lines 22, 37) | ○ |
| C-09 | source-expand/shrinkボタンが存在する | E-01 (Lines 40-41) | ○ |
| C-10 | disassembly-expand/shrinkボタンが存在する | E-01 (Lines 44-45) | ○ |
| C-11 | window.onloadで初期化される | E-02 (Line 18) | ○ |
| C-12 | Resizerクラスで動作する | E-02 (Line 27) | ○ |
| C-13 | loadFile関数でJSON読み込みを行う | E-02 (Lines 43-130) | ○ |
| C-14 | SourceResolverでソース情報を解決する | E-02 (Lines 63-74) | ○ |
| C-15 | SelectionBrokerで選択を伝播する | E-02 (Line 64) | ○ |
| C-16 | JSON終端不正時に自動修復を試みる | E-02 (Lines 48-50) | ○ |
| C-17 | CodeViewでソースコードを表示する | E-02 (Lines 80-90) | ○ |
| C-18 | DisassemblyViewで逆アセンブリを表示する | E-02 (Lines 106-115) | ○ |
| C-19 | GraphMultiViewでグラフを表示する | E-02 (Lines 117-118) | ○ |
| C-20 | HistoryViewで履歴を表示する | E-02 (Lines 120-122) | ○ |
| C-21 | エラー時にconfirmダイアログを表示する | E-02 (Lines 123-128) | ○ |
| C-22 | CTRL+Lでファイル選択ダイアログを開く | E-03 (Lines 8-9) | ○ |
| C-23 | rキーでグラフ再レイアウトする | E-03 (Line 23) | ○ |
| C-24 | 機能No.36(v8)、27(inspector)、1(fs)が関連する | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードまたはドキュメントによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TypeScriptソースコードで主要機能は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/turbolizer/index.html）の存在確認
- [ ] ビルド済みJS（build/turbolizer.js）の存在確認
- [ ] ファイルアップロードによるグラフ表示動作確認
- [ ] キーボードショートカットの動作確認
- [ ] ペインリサイズの動作確認
