---
generated_at: 2026-01-30 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-TurbolizerInfoView.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/turbolizer/info-view.html` (HTMLソースファイル)
- E-02: `deps/v8/tools/turbolizer/src/turbo-visualizer.ts` (Turbolizer初期化)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Info ViewはTurbolizerのキーボードショートカットヘルプ画面である | E-01 (Line 1), E-03 | ○ |
| C-02 | info-globalセクションでグローバルショートカットを表示する | E-01 (Lines 2-16) | ○ |
| C-03 | CTRL+Lでファイル選択ダイアログを開く | E-01 (Lines 7-9) | ○ |
| C-04 | CTRL+RでTurbolizerをリロードする | E-01 (Lines 10-13) | ○ |
| C-05 | info-common-graph-viewセクションが存在する | E-01 (Lines 17-47) | ○ |
| C-06 | rキーでグラフ再レイアウトする | E-01 (Lines 22-25) | ○ |
| C-07 | info-graph-viewセクションが存在する | E-01 (Lines 48-70) | ○ |
| C-08 | iキーで入力ノードを表示する（Sea of Nodes） | E-01 (Lines 53-56) | ○ |
| C-09 | info-turboshaft-graph-viewセクションが存在する | E-01 (Lines 71-101) | ○ |
| C-10 | pキーで選択ブロックを折りたたむ（Turboshaft） | E-01 (Lines 79-82) | ○ |
| C-11 | info-common-nodesセクションが存在する | E-01 (Lines 102-119) | ○ |
| C-12 | UPキーで全入力ノードを選択する | E-01 (Lines 109-112) | ○ |
| C-13 | info-graph-nodesセクションが存在する | E-01 (Lines 120-146) | ○ |
| C-14 | 1-9キーで入力ノード1-9を選択する | E-01 (Lines 124-127) | ○ |
| C-15 | info-graph-searchセクションが存在する | E-01 (Lines 147-177) | ○ |
| C-16 | ENTERキーで正規表現検索を実行する | E-01 (Lines 151-155) | ○ |
| C-17 | Turboshaft操作エフェクトの凡例が表示される | E-01 (Lines 178-228) | ○ |
| C-18 | 機能No.36(v8)が補助機能として関連する | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 静的HTMLコンテンツであり、動的処理がない

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/turbolizer/info-view.html）の存在確認
- [ ] 各セクション（info-global等）の構造確認
- [ ] ショートカット説明の正確性確認
- [ ] Turbolizerでの表示確認
