---
generated_at: 2026-01-30 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-HeapStatistics.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/heap-stats/index.html` (HTMLソースファイル)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Heap StatisticsはV8ヒープメモリ使用状況を可視化するツールである | E-01 (Line 10: title), E-02 | ○ |
| C-02 | 画面タイトルは"V8 Heap Statistics"である | E-01 (Line 10) | ○ |
| C-03 | Google Chartsライブラリを使用する | E-01 (Lines 12-13) | ○ |
| C-04 | pako.jsでgzip解凍を行う | E-01 (Lines 14-17) | ○ |
| C-05 | oboe.jsでJSONストリーミング処理を行う | E-01 (Lines 19-20) | ○ |
| C-06 | trace-file-readerカスタム要素が存在する | E-01 (Line 75) | ○ |
| C-07 | details-selectionカスタム要素が存在する | E-01 (Line 77) | ○ |
| C-08 | global-timelineカスタム要素が存在する | E-01 (Line 78) | ○ |
| C-09 | histogram-viewerカスタム要素が存在する | E-01 (Line 79) | ○ |
| C-10 | globalDataChanged関数でデータ変更を処理する | E-01 (Lines 51-61) | ○ |
| C-11 | globalSelectionChangedA関数で選択変更を処理する | E-01 (Lines 63-68) | ○ |
| C-12 | stateオブジェクトでデータと選択を管理する | E-01 (Line 49) | ○ |
| C-13 | --trace-gc-object-statsフラグの説明がある | E-01 (Line 83) | ○ |
| C-14 | Chromeトレーシング方法の説明がある | E-01 (Lines 84-90) | ○ |
| C-15 | --gc-globalフラグの説明がある | E-01 (Lines 96-98) | ○ |
| C-16 | --gc-intervalフラグの説明がある | E-01 (Lines 99-101) | ○ |
| C-17 | CORS制限の注意事項がある | E-01 (Lines 103-106) | ○ |
| C-18 | 機能No.36(v8)、29(perf_hooks)、1(fs)が関連する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/heap-stats/index.html）の存在確認
- [ ] 各カスタム要素（trace-file-reader等）の存在確認
- [ ] Google Chartsによるグラフ表示動作確認
- [ ] ファイルアップロードによるデータ解析動作確認
