---
generated_at: 2026-01-30 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-HeapLayout.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/heap-layout/index.html` (HTMLソースファイル)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Heap LayoutはV8ヒープレイアウトを可視化するツールである | E-01 (Line 10: title), E-02 | ○ |
| C-02 | 画面タイトルは"V8 Heap Layout"である | E-01 (Line 10) | ○ |
| C-03 | EChartsライブラリを使用する | E-01 (Line 12) | ○ |
| C-04 | trace-file-readerカスタム要素が存在する | E-01 (Line 55) | ○ |
| C-05 | heap-size-trend-viewerカスタム要素が存在する | E-01 (Line 56) | ○ |
| C-06 | heap-layout-viewerカスタム要素が存在する | E-01 (Line 57) | ○ |
| C-07 | globalDataChanged関数でデータ変更を処理する | E-01 (Lines 24-28) | ○ |
| C-08 | selectSnapshotAtIndex関数でスナップショット選択を処理する | E-01 (Lines 30-33) | ○ |
| C-09 | OnPrevClick関数で前のスナップショットに移動する | E-01 (Lines 36-41) | ○ |
| C-10 | OnNextClick関数で次のスナップショットに移動する | E-01 (Lines 43-48) | ○ |
| C-11 | button_prevボタンが存在する | E-01 (Line 59) | ○ |
| C-12 | button_nextボタンが存在する | E-01 (Line 60) | ○ |
| C-13 | button-containerはデータ読み込み後に表示される | E-01 (Line 27) | ○ |
| C-14 | --trace-gc-heap-layoutフラグの説明がある | E-01 (Line 66) | ○ |
| C-15 | ES Modulesを使用している | E-01 (Lines 14-16: type="module") | ○ |
| C-16 | 機能No.36(v8)、29(perf_hooks)、1(fs)が関連する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/heap-layout/index.html）の存在確認
- [ ] 各カスタム要素（trace-file-reader等）の存在確認
- [ ] EChartsによるグラフ表示動作確認
- [ ] Prev/Nextボタンによるスナップショット切り替え動作確認
