---
generated_at: 2026-01-30 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-Callstats.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `deps/v8/tools/callstats.html` (HTMLソースファイル、Lines 1-200)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面一覧)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CallstatsはV8ランタイムコール統計のビジュアライズ・比較ツールである | E-01 (Line 11: title), E-02 | ○ |
| C-02 | 画面タイトルは"V8 Runtime Call Stats Komparator"である | E-01 (Line 11) | ○ |
| C-03 | system-analyzer/index.cssを読み込む | E-01 (Line 12) | ○ |
| C-04 | .panelクラスは初期非表示で.loaded時に表示される | E-01 (Lines 18-24) | ○ |
| C-05 | .error時にinputsに赤背景が適用される | E-01 (Lines 30-32) | ○ |
| C-06 | .columnでテーブルカラム表示を行う | E-01 (Lines 72-76) | ○ |
| C-07 | .listでテーブル表示を行う | E-01 (Lines 86-96) | ○ |
| C-08 | .child行は初期非表示で.visible時に表示される | E-01 (Lines 102-108) | ○ |
| C-09 | .parent tdに上部ボーダーがある | E-01 (Lines 114-116) | ○ |
| C-10 | .totalで太字表示される | E-01 (Lines 118-120) | ○ |
| C-11 | .selectedで選択状態が表示される | E-01 (Lines 122-126) | ○ |
| C-12 | .codeSearchでコードサーチリンクが表示される | E-01 (Lines 128-135) | ○ |
| C-13 | .positionは右揃えで初期非表示 | E-01 (Lines 137-140) | ○ |
| C-14 | .valueは右揃え | E-01 (Lines 159-161) | ○ |
| C-15 | .selectedVersionで選択バージョンが太字表示される | E-01 (Lines 163-165) | ○ |
| C-16 | #popoverで詳細ポップオーバーが表示される | E-01 (Lines 179-197) | ○ |
| C-17 | panel-groupでグリッドレイアウトを使用する | E-01 (Lines 63-70) | ○ |
| C-18 | 機能No.36(v8)、29(perf_hooks)が関連する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全ての主張にソースコードによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSSスタイル定義で主要な構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLファイル（deps/v8/tools/callstats.html）の存在確認
- [ ] ファイルアップロードによるデータ表示動作確認
- [ ] 行展開/折りたたみ動作確認
- [ ] ポップオーバー表示動作確認
- [ ] ベースライン比較機能動作確認
