---
generated_at: 2026-01-30 18:35:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **IT-016 SQLite連携**：実験的機能のため動作保証が限定的
  2. **IT-026 WebSocket**：実装詳細がundiciに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/http.js` - HTTPモジュールのエントリーポイント
- E-02: `lib/_http_server.js` - HTTPサーバー実装
- E-03: `lib/_http_client.js` - HTTPクライアント実装
- E-04: `lib/_http_agent.js` - HTTPエージェント実装
- E-05: `lib/https.js` - HTTPSモジュール実装
- E-06: `lib/tls.js` - TLSモジュール実装
- E-07: `lib/http2.js` - HTTP/2モジュール
- E-08: `lib/net.js` - ネットワークモジュール
- E-09: `lib/stream.js` - ストリームモジュール
- E-10: `lib/fs.js` - ファイルシステムモジュール
- E-11: `lib/child_process.js` - 子プロセスモジュール
- E-12: `lib/cluster.js` - クラスターモジュール
- E-13: `lib/worker_threads.js` - ワーカースレッドモジュール
- E-14: `lib/dgram.js` - UDPソケットモジュール
- E-15: `lib/dns.js` - DNS解決モジュール
- E-16: `lib/crypto.js` - 暗号化モジュール
- E-17: `lib/events.js` - イベントモジュール
- E-18: `lib/buffer.js` - バッファモジュール
- E-19: `lib/sqlite.js` - SQLiteモジュール（実験的）
- E-20: `lib/async_hooks.js` - 非同期フックモジュール
- E-21: `lib/perf_hooks.js` - パフォーマンスフックモジュール
- E-22: `lib/diagnostics_channel.js` - 診断チャネルモジュール
- E-23: `lib/timers.js` - タイマーモジュール
- E-24: `lib/zlib.js` - 圧縮モジュール
- E-25: `lib/readline.js` - Readlineモジュール
- E-26: `lib/vm.js` - VMモジュール
- E-27: `lib/inspector.js` - Inspectorモジュール
- E-28: `lib/url.js` - URLモジュール
- E-29: `lib/querystring.js` - クエリ文字列モジュール
- E-30: `lib/assert.js` - アサーションモジュール
- E-31: `lib/path.js` - パスモジュール
- E-32: `lib/test.js` - テストモジュール
- E-33: `test/parallel/test-http-*.js` - HTTPテストファイル群
- E-34: `test/parallel/test-net-*.js` - ネットワークテストファイル群
- E-35: `test/sequential/test-*.js` - シーケンシャルテストファイル群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPサーバー・クライアント間通信 | E-01, E-02, E-03, E-33 | ○ |
| C-02 | HTTPSサーバー・クライアント間TLS通信 | E-05, E-06, E-33 | ○ |
| C-03 | HTTP/2サーバー・クライアント間多重化通信 | E-07, E-33 | ○ |
| C-04 | TCP Socket上でのHTTPプロトコル連携 | E-08, E-01, E-34 | ○ |
| C-05 | TLS上でのHTTPS連携 | E-06, E-05, E-33 | ○ |
| C-06 | Stream APIとNet Socketの連携 | E-09, E-08 | ○ |
| C-07 | FileSystemとStreamの連携 | E-10, E-09 | ○ |
| C-08 | 親子プロセス間IPC通信 | E-11 | ○ |
| C-09 | Clusterモジュールのワーカー連携 | E-12 | ○ |
| C-10 | Worker Threadsのメッセージング | E-13 | ○ |
| C-11 | UDPソケット通信 | E-14 | ○ |
| C-12 | DNS解決とNet接続の連携 | E-15, E-08 | ○ |
| C-13 | 暗号化モジュールとTLSの連携 | E-16, E-06 | ○ |
| C-14 | EventEmitterとStreamの連携 | E-17, E-09 | ○ |
| C-15 | BufferとStreamの連携 | E-18, E-09 | ○ |
| C-16 | SQLiteデータベース基本操作 | E-19 | △ |
| C-17 | 非同期フック追跡とNet連携 | E-20, E-08 | ○ |
| C-18 | パフォーマンス計測とHTTPの連携 | E-21, E-01 | ○ |
| C-19 | 診断チャネルとHTTPの連携 | E-22, E-01 | ○ |
| C-20 | タイマーとStreamの連携 | E-23, E-09 | ○ |
| C-21 | HTTPエージェントの接続プール管理 | E-04 | ○ |
| C-22 | 圧縮・解凍とStreamの連携 | E-24, E-09 | ○ |
| C-23 | Readlineとストリーム入力の連携 | E-25, E-09 | ○ |
| C-24 | VM環境でのコンテキスト分離 | E-26 | ○ |
| C-25 | InspectorプロトコルによるDebug連携 | E-27 | ○ |
| C-26 | HTTP上でのWebSocket通信 | E-01 | △ |
| C-27 | URLパースとHTTPリクエストの連携 | E-28, E-01 | ○ |
| C-28 | クエリ文字列とHTTPの連携 | E-29, E-01 | ○ |
| C-29 | アサーションとテスト実行の連携 | E-30, E-32 | ○ |
| C-30 | パス操作とファイルシステムの連携 | E-31, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-16 SQLite連携**：lib/sqlite.jsは実験的機能（experimental）であり、internalBindingを直接exportしている。詳細な結合テスト仕様はソースコードから完全に特定できない
  - 候補：Node.js公式ドキュメント / GitHub Issues / テストファイル test/sqlite/
- **C-26 WebSocket通信**：WebSocket実装はundici依存であり、lib/http.js内でlazyLoadされる。詳細な連携仕様はundiciのコードを参照する必要がある
  - 候補：internal/deps/undici/undici / undici公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - IT-017, IT-018, IT-019, IT-020, IT-025（低優先度のテストケース）
- **1: 中リスク** - IT-006, IT-007, IT-011, IT-012, IT-013, IT-014, IT-015, IT-022, IT-023, IT-024, IT-027, IT-028, IT-029, IT-030（中優先度、一般的な連携テスト）
- **2: 高リスク** - IT-016（SQLite実験的機能）, IT-026（WebSocket依存関係）

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001〜IT-005の高優先度テストケースが網羅的に定義されているか確認
- [ ] IT-016 SQLiteテストケースの実行可能性を確認（実験的機能のため）
- [ ] IT-026 WebSocketテストケースのundici依存関係を確認
- [ ] 各テストケースの前提条件が実行環境で満たせるか確認
- [ ] テスト手順が再現可能な粒度で記載されているか確認
- [ ] 期待結果が検証可能な形で定義されているか確認
