# 通知設計書 1-Force Push通知

## 概要

本ドキュメントは、Node.jsリポジトリにおけるmainブランチへのforce-push発生時にSlackへ通知を送信する機能の設計書である。

### 本通知の処理概要

本通知は、GitHub Actionsを利用してmainブランチへのforce-pushイベントを検知し、Slackワークスペースへ警告通知を送信する機能を提供する。

**業務上の目的・背景**：mainブランチはリリース用の安定ブランチであり、force-pushは履歴の書き換えを伴うため、予期しない変更やコード消失のリスクがある。そのため、force-pushが発生した場合には、チームメンバーへ即座に通知し、状況を確認・対応できるようにする必要がある。

**通知の送信タイミング**：mainブランチへのpushイベントが発生し、かつそのpushがforce-push（`github.event.forced`がtrue）である場合に通知が送信される。

**通知の受信者**：Slackワークスペースの指定チャンネルに参加しているメンバー全員。通知メッセージには`<!here>`メンションが含まれるため、オンラインメンバーに通知される。

**通知内容の概要**：force-pushを実行したユーザー名、対象ブランチ、変更前後のコミットハッシュとそのリンクが含まれる。

**期待されるアクション**：受信者はforce-pushの内容を確認し、意図した変更であるかを検証する。問題がある場合は、force-pushを実行したユーザーに連絡し、必要に応じてコードの復旧を行う。

## 通知種別

Slack通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（GitHub Actions経由） |
| 優先度 | 高 |
| リトライ | GitHub Actions標準のリトライ機構に依存 |

### 送信先決定ロジック

Slackの`SLACK_WEBHOOK`シークレットで指定されたWebhook URLに対応するチャンネルへ送信される。受信者はそのチャンネルに参加しているメンバー全員で、`<!here>`メンションによりオンラインメンバーに通知される。

## 通知テンプレート

### Slack通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元名称 | nodejs-bot |
| アイコン | https://github.com/nodejs.png?size=48 |
| 通知カラー | #DE512A（警告色） |

### 本文テンプレート

```
タイトル: {actor} force-pushed to {ref}

本文:
<!here> A commit was force-pushed to <https://github.com/{repository}/tree/{ref_name}|{repository}@{ref_name}> by <https://github.com/{actor}|{actor}>

Before: <https://github.com/{repository}/commit/{before}|{before}>
After: <https://github.com/{repository}/commit/{after}|{after}>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| actor | force-pushを実行したユーザー名 | github.actor | Yes |
| ref | 対象のブランチ参照（refs/heads/main） | github.ref | Yes |
| ref_name | ブランチ名（main） | github.ref_name | Yes |
| repository | リポジトリ名（nodejs/node） | github.repository | Yes |
| before | 変更前のコミットハッシュ | github.event.before | Yes |
| after | 変更後のコミットハッシュ | github.event.after | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Webhook | push to main branch | `github.event.forced == true` かつ `github.repository == 'nodejs/node'` | mainブランチへのforce-push時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リポジトリがnodejs/node以外 | フォークリポジトリでは通知しない |
| force-pushでない場合 | 通常のpushでは通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[mainブランチへのpushイベント発生] --> B{リポジトリがnodejs/node?}
    B -->|No| C[処理終了]
    B -->|Yes| D{force-push?}
    D -->|No| C
    D -->|Yes| E[Slackメッセージ構築]
    E --> F[rtCamp/action-slack-notify実行]
    F --> G{送信成功?}
    G -->|Yes| H[ログ記録・終了]
    G -->|No| I[エラーログ記録・終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。全てのデータはGitHubイベントのペイロードから取得される。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | GitHubイベントペイロードのみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Webhook送信失敗 | ネットワークエラー、Slack API障害 | GitHub Actionsがジョブ失敗としてマーク |
| シークレット未設定 | SLACK_WEBHOOKが設定されていない | ジョブ失敗、管理者による設定確認が必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準に依存 |
| リトライ間隔 | GitHub Actions標準に依存 |
| リトライ対象エラー | 一時的なネットワークエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Slack APIの制限に依存 |
| 1日あたり上限 | なし |

### 配信時間帯

時間帯制限なし（24時間365日送信可能）

## セキュリティ考慮事項

- SLACK_WEBHOOKはGitHub Secretsに保存され、ワークフロー実行時のみアクセス可能
- Webhook URLが漏洩した場合、任意のメッセージが送信される可能性があるため、定期的なローテーションを推奨
- リポジトリのcontents:readパーミッションのみを要求し、最小権限の原則に従う

## 備考

- 本通知はNode.js公式リポジトリ（nodejs/node）専用であり、フォークでは動作しない
- rtCamp/action-slack-notify v2.3.3を使用
- force-pushは通常の運用では発生しないため、この通知が発火した場合は必ず確認が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ワークフロー定義を理解する

GitHub Actionsのワークフロー定義ファイルを読み、通知のトリガー条件と処理内容を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notify-on-push.yml | `.github/workflows/notify-on-push.yml` | トリガー条件（on.push.branches）、ジョブ条件（if）、環境変数の設定方法 |

**読解のコツ**: YAMLのインデントに注意し、`if`条件式でのGitHubコンテキスト変数の使用方法を理解する。

#### Step 2: エントリーポイントを理解する

ワークフローの発火条件とジョブ実行条件を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notify-on-push.yml | `.github/workflows/notify-on-push.yml` | 1-10行目：トリガー定義、11-28行目：notifyOnForcePushジョブ |

**主要処理フロー**:
1. **1-4行目**: pushイベントでmainブランチを対象にトリガー
2. **11-13行目**: ジョブ名と条件（`github.event.forced`がtrue）
3. **16-28行目**: rtCamp/action-slack-notifyアクションの実行と環境変数設定

### プログラム呼び出し階層図

```
GitHub push event (main branch)
    │
    ├─ Workflow trigger check
    │      └─ on.push.branches: [main]
    │
    └─ Job: notifyOnForcePush
           │
           ├─ Condition check: github.event.forced == true
           │
           └─ Step: rtCamp/action-slack-notify
                  └─ Slack Webhook API call
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GitHub Event Payload ───▶ GitHub Actions Workflow ───▶ Slack Channel
  - actor                     - 条件チェック               - 通知メッセージ
  - ref                       - メッセージ構築
  - before/after              - Webhook送信
  - forced flag
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notify-on-push.yml | `.github/workflows/notify-on-push.yml` | ワークフロー定義 | Force Push通知のメイン処理定義 |
