# 通知設計書 10-コンソール出力通知

## 概要

本ドキュメントは、Node.jsのconsoleモジュールにおける診断チャンネル通知機能の設計書である。

### 本通知の処理概要

コンソール出力通知は、Node.jsアプリケーションがconsole.log()、console.warn()、console.error()などのコンソールメソッドを呼び出す際に診断チャンネルに通知を送信する機能を提供する。これにより、アプリケーションのコンソール出力を外部から監視・計装することが可能となる。

**業務上の目的・背景**：アプリケーションのログ出力はデバッグや運用監視において重要である。コンソール出力通知により、標準ログ出力を横取りしてログアグリゲーター、APMツール、カスタムログ処理などに転送することが可能となる。アプリケーションコードを変更せずにログ収集を実現できる。

**通知の送信タイミング**：
- console.log: console.log()呼び出し時
- console.warn: console.warn()呼び出し時
- console.error: console.error()呼び出し時
- console.info: console.info()呼び出し時
- console.debug: console.debug()呼び出し時

**通知の受信者**：各診断チャンネルに対してsubscribe()で登録したコールバック関数。ログアグリゲーター、APMツール、カスタムログ処理などが想定される。

**通知内容の概要**：コンソールメソッドに渡された引数の配列。

**期待されるアクション**：購読者は受信したデータを使用して、ログの転送、フィルタリング、フォーマット変換などを行う。

## 通知種別

内部イベント通知（diagnostics_channel）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中（ログ出力は頻繁だが即時性は低い） |
| リトライ | なし（同期実行のため） |

### 送信先決定ロジック

各チャンネルに対してsubscribe()を呼び出した購読者に送信される。hasSubscribersで事前チェックを行い、購読者がいない場合はpublish()をスキップしてパフォーマンスオーバーヘッドを最小化。

## 通知テンプレート

### チャンネル一覧

| チャンネル名 | タイミング | 説明 |
|-------------|---------|------|
| console.log | console.log()呼び出し時 | 標準出力へのログ出力時に発火 |
| console.warn | console.warn()呼び出し時 | 警告出力時に発火 |
| console.error | console.error()呼び出し時 | エラー出力時に発火 |
| console.info | console.info()呼び出し時 | 情報出力時に発火 |
| console.debug | console.debug()呼び出し時 | デバッグ出力時に発火 |

### データ構造

```javascript
// console.log / console.warn / console.error / console.info / console.debug
// 全て同じ構造
args  // console.xxx()に渡された引数の配列
```

**注意**: データはオブジェクト形式ではなく、引数の配列がそのまま渡される。

### 添付ファイル

該当なし（プログラム内部通知のため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| args | コンソールメソッドに渡された引数 | console.xxx()のrest parameters | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ログ出力 | console.log() | hasSubscribers == true | 標準出力時 |
| 警告出力 | console.warn() | hasSubscribers == true | 警告出力時 |
| エラー出力 | console.error() | hasSubscribers == true | エラー出力時 |
| 情報出力 | console.info() | hasSubscribers == true | 情報出力時 |
| デバッグ出力 | console.debug() | hasSubscribers == true | デバッグ出力時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 購読者なし | hasSubscribersがfalseの場合、publish()をスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[console.log呼び出し] --> B{hasSubscribers?}
    B -->|Yes| C[console.log発火]
    B -->|No| D[スキップ]
    C --> E[kWriteToConsole]
    D --> E
    E --> F[標準出力へ書き込み]

    G[console.warn呼び出し] --> H{hasSubscribers?}
    H -->|Yes| I[console.warn発火]
    H -->|No| J[スキップ]
    I --> K[kWriteToConsole]
    J --> K
    K --> L[標準エラー出力へ書き込み]

    M[console.error呼び出し] --> N{hasSubscribers?}
    N -->|Yes| O[console.error発火]
    N -->|No| P[スキップ]
    O --> Q[kWriteToConsole]
    P --> Q
    Q --> R[標準エラー出力へ書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | メモリ内オブジェクトのみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ストリームエラー | 標準出力/エラーへの書き込み失敗 | ignoreErrorsオプションに応じてエラー処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（通知自体にはリトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（制限なし） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（プログラム実行中は常時利用可能）

## セキュリティ考慮事項

- コンソール出力には機密情報（パスワード、APIキー、個人情報等）が含まれる可能性があるため、購読者はログ転送時に適切なフィルタリング/マスキングを行うべき
- 大量のログ出力がある場合、購読者の処理がパフォーマンスボトルネックになる可能性がある
- 購読者のパフォーマンスがアプリケーション全体のログ出力パフォーマンスに影響するため、軽量な処理を心がける

## 備考

- Node.js v18.17.0でconsole.log/warn/error/info/debugチャンネルが追加
- hasSubscribersチェックにより、購読者がいない場合のオーバーヘッドは最小限
- 通知は標準出力/エラー出力への実際の書き込み前に発火する
- console.log/info/debugは標準出力（stdout）へ、console.warn/errorは標準エラー出力（stderr）へ書き込まれる
- グローバルconsoleオブジェクトだけでなく、new Console()で作成したインスタンスでも同様に通知が発火する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: チャンネル定義を理解する

まず、診断チャンネルの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constructor.js | `lib/internal/console/constructor.js` | 66-72行目：5つの診断チャンネルの定義 |

**読解のコツ**: channel()関数で各コンソールメソッドに対応するチャンネルを作成している点を確認する。

#### Step 2: consoleMethodsオブジェクトを理解する

各コンソールメソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | constructor.js | `lib/internal/console/constructor.js` | 411-445行目：consoleMethods定義 |

**主要処理フロー**:

**console.log (411-417行目)**:
1. hasSubscribersチェック
2. onLog.publish(args)
3. kWriteToConsole(kUseStdout, ...)

**console.info (419-424行目)**:
1. hasSubscribersチェック
2. onInfo.publish(args)
3. kWriteToConsole(kUseStdout, ...)

**console.debug (426-431行目)**:
1. hasSubscribersチェック
2. onDebug.publish(args)
3. kWriteToConsole(kUseStdout, ...)

**console.warn (433-438行目)**:
1. hasSubscribersチェック
2. onWarn.publish(args)
3. kWriteToConsole(kUseStderr, ...)

**console.error (440-445行目)**:
1. hasSubscribersチェック
2. onError.publish(args)
3. kWriteToConsole(kUseStderr, ...)

### プログラム呼び出し階層図

```
console.log(...args)
    │
    └─ consoleMethods.log() [411行目]
           │
           ├─ onLog.hasSubscribers チェック [413行目]
           │
           ├─ onLog.publish(args) [414行目]
           │      └─ 引数配列をそのまま送信
           │
           └─ this[kWriteToConsole](kUseStdout, ...) [416行目]
                  └─ 標準出力へ書き込み

console.warn(...args)
    │
    └─ consoleMethods.warn() [433行目]
           │
           ├─ onWarn.hasSubscribers チェック [434行目]
           │
           ├─ onWarn.publish(args) [435行目]
           │      └─ 引数配列をそのまま送信
           │
           └─ this[kWriteToConsole](kUseStderr, ...) [437行目]
                  └─ 標準エラー出力へ書き込み

console.error(...args)
    │
    └─ consoleMethods.error() [440行目]
           │
           ├─ onError.hasSubscribers チェック [441行目]
           │
           ├─ onError.publish(args) [442行目]
           │      └─ 引数配列をそのまま送信
           │
           └─ this[kWriteToConsole](kUseStderr, ...) [444行目]
                  └─ 標準エラー出力へ書き込み
```

### データフロー図

```
[入力]                    [処理]                         [出力]

console.log()          consoleMethods              診断チャンネル購読者
    │                        │                            │
    ▼                        ▼                            ▼
args ─────────────▶ log() ─────────────────────▶ console.log
    │                        │                            │
    │                        ▼                            ▼
    │              kWriteToConsole ────────────▶ stdout
    │                        │
    │                        ▼
    └─────────────▶ フォーマット済み文字列


console.warn()         consoleMethods              診断チャンネル購読者
    │                        │                            │
    ▼                        ▼                            ▼
args ─────────────▶ warn() ────────────────────▶ console.warn
    │                        │                            │
    │                        ▼                            ▼
    │              kWriteToConsole ────────────▶ stderr
    │                        │
    │                        ▼
    └─────────────▶ フォーマット済み文字列
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| constructor.js | `lib/internal/console/constructor.js` | ソース | Consoleクラス実装、診断チャンネル通知 |
| diagnostics_channel.js | `lib/diagnostics_channel.js` | ソース | diagnostics_channelモジュール |
| console.js | `lib/console.js` | ソース | consoleモジュールエントリーポイント |
