# 通知設計書 2-無効なコミットメッセージ通知

## 概要

本ドキュメントは、Node.jsリポジトリにおいてmainブランチに無効なコミットメッセージがpushされた際にSlackへ通知を送信する機能の設計書である。

### 本通知の処理概要

本通知は、GitHub Actionsを利用してmainブランチへのpushイベントを検知し、コミットメッセージの検証を行った後、検証に失敗した場合にSlackワークスペースへ警告通知を送信する機能を提供する。

**業務上の目的・背景**：Node.jsプロジェクトでは、コミットメッセージに厳格な規約（conventional commit形式など）が設けられている。mainブランチは本番リリースの基盤となるため、規約に違反したコミットメッセージがマージされた場合は、チームに通知して修正対応を促す必要がある。これにより、変更履歴の一貫性とリリースノートの自動生成品質を維持する。

**通知の送信タイミング**：mainブランチへのpushイベント発生後、`core-validate-commit`コマンドによるコミットメッセージ検証が失敗した場合に通知が送信される。

**通知の受信者**：Slackワークスペースの指定チャンネルに参加しているメンバー全員。通知メッセージには`<!here>`メンションが含まれるため、オンラインメンバーに通知される。

**通知内容の概要**：無効なコミットがpushされたことの警告、対象ブランチ、変更前後のコミットハッシュとそのリンク、pushを実行したユーザー名が含まれる。

**期待されるアクション**：受信者はコミットメッセージの問題を確認し、必要に応じてコミットの修正（rebase/amend）やリバートを検討する。また、pushを実行したユーザーに連絡し、今後のコミットメッセージ規約の遵守を促す。

## 通知種別

Slack通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（GitHub Actions経由） |
| 優先度 | 高 |
| リトライ | GitHub Actions標準のリトライ機構に依存 |

### 送信先決定ロジック

Slackの`SLACK_WEBHOOK`シークレットで指定されたWebhook URLに対応するチャンネルへ送信される。受信者はそのチャンネルに参加しているメンバー全員で、`<!here>`メンションによりオンラインメンバーに通知される。

## 通知テンプレート

### Slack通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元名称 | nodejs-bot |
| アイコン | https://github.com/nodejs.png?size=48 |
| 通知カラー | #DE512A（警告色） |

### 本文テンプレート

```
タイトル: Invalid commit was pushed to {ref}

本文:
<!here> A commit with an invalid message was pushed to <https://github.com/{repository}/tree/{ref_name}|{repository}@{ref_name}> by <https://github.com/{actor}|{actor}>.

Before: <https://github.com/{repository}/commit/{before}|{before}>
After: <https://github.com/{repository}/commit/{after}|{after}>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| actor | pushを実行したユーザー名 | github.actor | Yes |
| ref | 対象のブランチ参照（refs/heads/main） | github.ref | Yes |
| ref_name | ブランチ名（main） | github.ref_name | Yes |
| repository | リポジトリ名（nodejs/node） | github.repository | Yes |
| before | 変更前のコミットハッシュ | github.event.before | Yes |
| after | 変更後のコミットハッシュ | github.event.after | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Webhook | push to main branch | `github.repository == 'nodejs/node'` かつ `core-validate-commit`が失敗 | mainブランチへのpush時にコミット検証が失敗した場合に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リポジトリがnodejs/node以外 | フォークリポジトリでは通知しない |
| コミットメッセージが有効な場合 | 検証成功時は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[mainブランチへのpushイベント発生] --> B{リポジトリがnodejs/node?}
    B -->|No| C[処理終了]
    B -->|Yes| D[リポジトリをチェックアウト]
    D --> E[core-validate-commitでコミット検証]
    E --> F{検証結果}
    F -->|成功| C
    F -->|失敗| G[Slackメッセージ構築]
    G --> H[rtCamp/action-slack-notify実行]
    H --> I{送信成功?}
    I -->|Yes| J[ログ記録・終了]
    I -->|No| K[エラーログ記録・終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。全てのデータはGitHubイベントのペイロードから取得される。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | GitHubイベントペイロードのみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Webhook送信失敗 | ネットワークエラー、Slack API障害 | GitHub Actionsがジョブ失敗としてマーク |
| シークレット未設定 | SLACK_WEBHOOKが設定されていない | ジョブ失敗、管理者による設定確認が必要 |
| チェックアウト失敗 | リポジトリアクセスエラー | ジョブ失敗、後続ステップは実行されない |
| core-validate-commit実行エラー | npmパッケージの問題 | ジョブ失敗としてマーク |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準に依存 |
| リトライ間隔 | GitHub Actions標準に依存 |
| リトライ対象エラー | 一時的なネットワークエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Slack APIの制限に依存 |
| 1日あたり上限 | なし |

### 配信時間帯

時間帯制限なし（24時間365日送信可能）

## セキュリティ考慮事項

- SLACK_WEBHOOKはGitHub Secretsに保存され、ワークフロー実行時のみアクセス可能
- リポジトリのチェックアウト時に`persist-credentials: false`を指定し、認証情報の永続化を防止
- リポジトリのcontents:readパーミッションのみを要求し、最小権限の原則に従う
- npxコマンドで`-q`（quiet）オプションを使用し、出力を最小限に抑制

## 備考

- 本通知はNode.js公式リポジトリ（nodejs/node）専用であり、フォークでは動作しない
- rtCamp/action-slack-notify v2.3.3を使用
- actions/checkout v6.0.1を使用
- コミットメッセージの検証には`core-validate-commit`パッケージを使用
- 検証は最新のpushされたコミット（`github.event.after`）に対して実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ワークフロー定義を理解する

GitHub Actionsのワークフロー定義ファイルを読み、通知のトリガー条件と処理内容を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notify-on-push.yml | `.github/workflows/notify-on-push.yml` | トリガー条件、validateCommitMessageジョブの構成 |

**読解のコツ**: ジョブが複数のステップで構成されていること、各ステップの`if`条件に注意する。

#### Step 2: エントリーポイントを理解する

ワークフローの発火条件とジョブ実行条件を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notify-on-push.yml | `.github/workflows/notify-on-push.yml` | 30-56行目：validateCommitMessageジョブ |

**主要処理フロー**:
1. **30-32行目**: ジョブ名と条件（リポジトリがnodejs/node）
2. **34-37行目**: リポジトリのチェックアウト（persist-credentials: false）
3. **38-42行目**: core-validate-commitによるコミット検証
4. **43-56行目**: 検証失敗時のSlack通知

### プログラム呼び出し階層図

```
GitHub push event (main branch)
    │
    ├─ Workflow trigger check
    │      └─ on.push.branches: [main]
    │
    └─ Job: validateCommitMessage
           │
           ├─ Condition check: github.repository == 'nodejs/node'
           │
           ├─ Step: actions/checkout
           │      └─ persist-credentials: false
           │
           ├─ Step: Check commit message
           │      └─ npx core-validate-commit $COMMIT
           │
           └─ Step: Slack Notification (if failure)
                  └─ rtCamp/action-slack-notify
                         └─ Slack Webhook API call
```

### データフロー図

```
[入力]                    [処理]                              [出力]

GitHub Event Payload ───▶ リポジトリチェックアウト ───▶ コミット検証
  - actor                     │
  - ref                       ▼
  - before/after         core-validate-commit
                              │
                              ▼
                         検証失敗判定 ────────────────▶ Slack Channel
                                                        - 警告メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notify-on-push.yml | `.github/workflows/notify-on-push.yml` | ワークフロー定義 | 無効コミットメッセージ通知のメイン処理定義 |
