# 通知設計書 3-レビュー要求通知

## 概要

本ドキュメントは、Node.jsリポジトリにおいてPR（Pull Request）またはIssueに「review wanted」ラベルが付与された際にSlackへ通知を送信する機能の設計書である。

### 本通知の処理概要

本通知は、GitHub Actionsを利用してPR/Issueへのラベル付与イベントを検知し、「review wanted」ラベルが付与された場合にSlackワークスペースへ通知を送信する機能を提供する。

**業務上の目的・背景**：Node.jsプロジェクトは大規模なオープンソースプロジェクトであり、多数のPRやIssueが日々作成される。メンテナーがレビューを必要とする項目を見逃さないよう、「review wanted」ラベルが付与された際にSlackで通知することで、迅速なレビュー対応を促進する。これにより、コントリビューターの待ち時間を短縮し、プロジェクトの開発速度を維持する。

**通知の送信タイミング**：PR（pull_request_target）またはIssue（issues）に「review wanted」ラベルが付与された（labeled）際に通知が送信される。

**通知の受信者**：Slackワークスペースの指定チャンネルに参加しているNode.jsメンテナー全員。

**通知内容の概要**：PRまたはIssueのタイトル、番号、リンク、レビューが必要であるというメッセージが含まれる。

**期待されるアクション**：受信者（Node.jsメンテナー）は通知されたPR/Issueを確認し、コードレビューや技術的なフィードバックを提供する。

## 通知種別

Slack通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（GitHub Actions経由） |
| 優先度 | 中 |
| リトライ | GitHub Actions標準のリトライ機構に依存 |

### 送信先決定ロジック

Slackの`SLACK_WEBHOOK`シークレットで指定されたWebhook URLに対応するチャンネルへ送信される。MSG_MINIMAL設定により、アクションURLのみが含まれるシンプルな通知となる。

## 通知テンプレート

### Slack通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元名称 | nodejs-bot |
| アイコン | https://github.com/nodejs.png?size=48 |
| 通知カラー | #3d85c6（情報色・青） |

### 本文テンプレート

#### PRの場合
```
タイトル: {PR title}

本文:
The PR (#{number}) requires review from Node.js maintainers. See: https://github.com/{repository}/pull/{number}
```

#### Issueの場合
```
タイトル: {Issue title}

本文:
The issue (#{number}) requires review from Node.js maintainers. See: https://github.com/{repository}/issues/{number}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | PR/Issueのタイトル | github.event.pull_request.title または github.event.issue.title | Yes |
| number | PR/Issueの番号 | github.event.pull_request.number または github.event.issue.number | Yes |
| repository | リポジトリ名（nodejs/node） | github.repository | Yes |
| message | 生成されたメッセージ | ワークフロー内で動的生成 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHub Webhook | issues.labeled | `github.repository == 'nodejs/node'` かつ `label.name == 'review wanted'` | Issueにreview wantedラベルが付与された時 |
| GitHub Webhook | pull_request_target.labeled | `github.repository == 'nodejs/node'` かつ `label.name == 'review wanted'` | PRにreview wantedラベルが付与された時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リポジトリがnodejs/node以外 | フォークリポジトリでは通知しない |
| ラベルがreview wanted以外 | 他のラベルでは通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PR/Issueにラベル付与イベント発生] --> B{リポジトリがnodejs/node?}
    B -->|No| C[処理終了]
    B -->|Yes| D{ラベルがreview wanted?}
    D -->|No| C
    D -->|Yes| E{PRかIssueか判定}
    E -->|PR| F[PRメッセージ生成]
    E -->|Issue| G[Issueメッセージ生成]
    F --> H[Slackメッセージ構築]
    G --> H
    H --> I[rtCamp/action-slack-notify実行]
    I --> J{送信成功?}
    J -->|Yes| K[ログ記録・終了]
    J -->|No| L[エラーログ記録・終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。全てのデータはGitHubイベントのペイロードから取得される。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | GitHubイベントペイロードのみ使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Webhook送信失敗 | ネットワークエラー、Slack API障害 | GitHub Actionsがジョブ失敗としてマーク |
| シークレット未設定 | SLACK_WEBHOOKが設定されていない | ジョブ失敗、管理者による設定確認が必要 |
| イベントデータ不正 | PR/Issueの情報が取得できない | ジョブ失敗 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準に依存 |
| リトライ間隔 | GitHub Actions標準に依存 |
| リトライ対象エラー | 一時的なネットワークエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Slack APIの制限に依存 |
| 1日あたり上限 | なし |

### 配信時間帯

時間帯制限なし（24時間365日送信可能）

## セキュリティ考慮事項

- SLACK_WEBHOOKはGitHub Secretsに保存され、ワークフロー実行時のみアクセス可能
- pull_request_targetを使用しているため、フォークからのPRでも安全にシークレットにアクセス可能
- リポジトリのcontents:readパーミッションのみを要求し、最小権限の原則に従う
- 環境変数TITLE_ISSUEおよびTITLE_PRを使用してタイトルを安全に渡している

## 備考

- 本通知はNode.js公式リポジトリ（nodejs/node）専用であり、フォークでは動作しない
- rtCamp/action-slack-notify v2.3.3を使用
- MSG_MINIMAL設定により、通知にはアクションURLのみが含まれる
- PRとIssueの判定はgithub.event.pull_request.numberの有無で行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ワークフロー定義を理解する

GitHub Actionsのワークフロー定義ファイルを読み、通知のトリガー条件と処理内容を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notify-on-review-wanted.yml | `.github/workflows/notify-on-review-wanted.yml` | トリガー条件（issues.labeled, pull_request_target.labeled）、ジョブ条件 |

**読解のコツ**: issuesとpull_request_targetの両方のイベントをトリガーとしていること、labeledタイプに限定していることに注意する。

#### Step 2: エントリーポイントを理解する

ワークフローの発火条件とジョブ実行条件を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notify-on-review-wanted.yml | `.github/workflows/notify-on-review-wanted.yml` | 2-7行目：トリガー定義、12-14行目：ジョブ条件 |

**主要処理フロー**:
1. **2-7行目**: issues.labeledとpull_request_target.labeledでトリガー
2. **12-14行目**: ジョブ条件（リポジトリとラベル名のチェック）
3. **15-33行目**: PRかIssueかの判定とメッセージ生成
4. **35-44行目**: rtCamp/action-slack-notifyの実行

#### Step 3: PR/Issue判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notify-on-review-wanted.yml | `.github/workflows/notify-on-review-wanted.yml` | 22-33行目：条件分岐によるメッセージ生成 |

**主要処理フロー**:
- **22-27行目**: github.event.pull_request.numberが存在する場合はPR
- **28-33行目**: 存在しない場合はIssue

### プログラム呼び出し階層図

```
GitHub labeled event (issues/pull_request_target)
    │
    ├─ Workflow trigger check
    │      ├─ issues: [labeled]
    │      └─ pull_request_target: [labeled]
    │
    └─ Job: notifyOnReviewWanted
           │
           ├─ Condition check
           │      ├─ github.repository == 'nodejs/node'
           │      └─ github.event.label.name == 'review wanted'
           │
           ├─ Step: Determine PR or Issue
           │      ├─ if PR: generate PR message
           │      └─ if Issue: generate Issue message
           │
           └─ Step: rtCamp/action-slack-notify
                  └─ Slack Webhook API call
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GitHub Event Payload ───▶ PR/Issue判定 ───▶ メッセージ生成 ───▶ Slack Channel
  - label.name               │                    │              - 通知メッセージ
  - pull_request/issue       ▼                    ▼
  - number/title        条件分岐           動的メッセージ構築
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notify-on-review-wanted.yml | `.github/workflows/notify-on-review-wanted.yml` | ワークフロー定義 | レビュー要求通知のメイン処理定義 |
