---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-Force_Push通知.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `.github/workflows/notify-on-push.yml` 1-4行目（トリガー定義）
- E-02: `.github/workflows/notify-on-push.yml` 11-13行目（ジョブ条件）
- E-03: `.github/workflows/notify-on-push.yml` 16-28行目（Slackアクション設定）
- E-04: `.github/workflows/notify-on-push.yml` 19行目（SLACK_COLOR設定）
- E-05: `.github/workflows/notify-on-push.yml` 20行目（SLACK_ICON設定）
- E-06: `.github/workflows/notify-on-push.yml` 22-26行目（SLACK_MESSAGE設定）
- E-07: `.github/workflows/notify-on-push.yml` 27行目（SLACK_USERNAME設定）
- E-08: `.github/workflows/notify-on-push.yml` 28行目（SLACK_WEBHOOK設定）
- E-09: `.github/workflows/notify-on-push.yml` 7-8行目（permissions設定）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 2行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mainブランチへのpushイベントでトリガーされる | E-01 | ○ |
| C-02 | force-pushの場合のみ通知する | E-02 | ○ |
| C-03 | リポジトリがnodejs/nodeの場合のみ動作 | E-02 | ○ |
| C-04 | 通知カラーは#DE512A | E-04 | ○ |
| C-05 | アイコンURLはhttps://github.com/nodejs.png?size=48 | E-05 | ○ |
| C-06 | 送信元名称はnodejs-bot | E-07 | ○ |
| C-07 | メッセージに<!here>メンションが含まれる | E-06 | ○ |
| C-08 | メッセージに変更前後のコミットハッシュが含まれる | E-06 | ○ |
| C-09 | SLACK_WEBHOOKはシークレットとして管理 | E-08 | ○ |
| C-10 | contents:readパーミッションのみを要求 | E-09 | ○ |
| C-11 | rtCamp/action-slack-notify v2.3.3を使用 | E-03 | ○ |
| C-12 | タイトルにactorとref情報が含まれる | E-03 | ○ |
| C-13 | 通知種別はSlack通知 | E-10 | ○ |
| C-14 | GitHub Actions: notify-on-push.ymlで実装 | E-10 | ○ |
| C-15 | rtCamp/action-slack-notifyを使用 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `.github/workflows/notify-on-push.yml`のトリガー条件が正確に記載されているか確認
- [ ] Slackメッセージテンプレートの変数展開が正しいか確認
- [ ] セキュリティ考慮事項が適切か確認
