---
generated_at: 2026-01-30 17:58:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-コンソール出力通知.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/internal/console/constructor.js` 66-72行目（診断チャンネル定義）
- E-02: `lib/internal/console/constructor.js` 68行目（onLog）
- E-03: `lib/internal/console/constructor.js` 69行目（onWarn）
- E-04: `lib/internal/console/constructor.js` 70行目（onError）
- E-05: `lib/internal/console/constructor.js` 71行目（onInfo）
- E-06: `lib/internal/console/constructor.js` 72行目（onDebug）
- E-07: `lib/internal/console/constructor.js` 411-417行目（console.log実装）
- E-08: `lib/internal/console/constructor.js` 419-424行目（console.info実装）
- E-09: `lib/internal/console/constructor.js` 426-431行目（console.debug実装）
- E-10: `lib/internal/console/constructor.js` 433-438行目（console.warn実装）
- E-11: `lib/internal/console/constructor.js` 440-445行目（console.error実装）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 11行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5つの診断チャンネルを使用 | E-01 | ○ |
| C-02 | console.logチャンネルが存在 | E-02 | ○ |
| C-03 | console.warnチャンネルが存在 | E-03 | ○ |
| C-04 | console.errorチャンネルが存在 | E-04 | ○ |
| C-05 | console.infoチャンネルが存在 | E-05 | ○ |
| C-06 | console.debugチャンネルが存在 | E-06 | ○ |
| C-07 | console.log()でonLog.publish発火 | E-07 | ○ |
| C-08 | console.info()でonInfo.publish発火 | E-08 | ○ |
| C-09 | console.debug()でonDebug.publish発火 | E-09 | ○ |
| C-10 | console.warn()でonWarn.publish発火 | E-10 | ○ |
| C-11 | console.error()でonError.publish発火 | E-11 | ○ |
| C-12 | hasSubscribersで事前チェック | E-07, E-08, E-09, E-10, E-11 | ○ |
| C-13 | 引数配列をそのまま送信 | E-07, E-08, E-09, E-10, E-11 | ○ |
| C-14 | 通知種別は内部イベント通知 | E-12 | ○ |
| C-15 | lib/internal/console/constructor.jsで実装 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `lib/internal/console/constructor.js`の5つの診断チャンネル定義が正確か確認
- [ ] 各通知ポイント（log/warn/error/info/debug）の発火タイミングが正確か確認
- [ ] 通知データ構造（args配列）が正確か確認
- [ ] hasSubscribersチェックが全ての通知ポイントで行われているか確認
- [ ] stdout/stderrの使い分けが正確か確認（log/info/debug -> stdout、warn/error -> stderr）
