---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-QUICセッション通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項**：セッションチケットの機密性に関する具体的な仕様確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/internal/quic/quic.js` 行164-184（診断チャンネル定義）
- E-02: `lib/internal/quic/quic.js` 行1748-1762（QuicEndpointコンストラクタ）
- E-03: `lib/internal/quic/quic.js` 行1224-1230（sendDatagram実装）
- E-04: `lib/internal/quic/quic.js` 行1535-1540（ハンドシェイク通知）
- E-05: `lib/internal/quic/quic.js` 行1160-1166（ストリーム開始通知）
- E-06: `lib/internal/quic/quic.js` 行1424-1430（データグラム受信通知）
- E-07: `lib/internal/quic/quic.js` 行22-25（実験的機能フラグチェック）
- E-08: `lib/diagnostics_channel.js` 行151-162（publish実装）
- E-09: `lib/diagnostics_channel.js` 行147-149（hasSubscribersプロパティ）
- E-10: `lib/internal/quic/state.js` 行125-230（QuicEndpointState）
- E-11: `lib/internal/quic/state.js` 行232-422（QuicSessionState）
- E-12: `lib/internal/quic/stats.js` 行145-301（QuicEndpointStats）
- E-13: `lib/internal/quic/symbols.js` 全体（シンボル定義）
- E-14: `lib/internal/quic/quic.js` 行1801-1806（ビジー状態変更）
- E-15: `lib/internal/quic/quic.js` 行2008-2013（エンドポイントエラー）
- E-16: `lib/internal/quic/quic.js` 行1361-1366（セッションクローズ）
- E-17: `lib/internal/quic/quic.js` 行1245-1249（キー更新通知）
- E-18: `lib/internal/quic/quic.js` 行1270-1274（セッションクローズ中通知）
- E-19: `lib/internal/quic/quic.js` 行1459-1469（パス検証通知）
- E-20: `lib/internal/quic/quic.js` 行1478-1483（セッションチケット通知）
- E-21: `lib/internal/quic/quic.js` 行1494-1501（バージョンネゴシエーション通知）
- E-22: `lib/internal/quic/quic.js` 行1561-1566（ストリーム受信通知）
- E-23: `lib/internal/quic/quic.js` 行2034-2038（サーバーセッション通知）
- E-24: `lib/internal/quic/quic.js` 行2326-2333（クライアントセッション通知）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 20個の診断チャンネルが定義されている | E-01 | ○ |
| C-02 | quic.endpoint.createdチャンネルはエンドポイント作成時に通知 | E-02 | ○ |
| C-03 | sendDatagramでquic.session.send.datagramチャンネルに通知 | E-03 | ○ |
| C-04 | ハンドシェイク完了時にquic.session.handshakeチャンネルに通知 | E-04 | ○ |
| C-05 | ストリーム開始時にquic.session.open.streamチャンネルに通知 | E-05 | ○ |
| C-06 | データグラム受信時にquic.session.receive.datagramチャンネルに通知 | E-06 | ○ |
| C-07 | --experimental-quicフラグが必要 | E-07 | ○ |
| C-08 | publishメソッドで購読者コールバックを呼び出し | E-08 | ○ |
| C-09 | hasSubscribersがtrueの場合のみ通知処理実行 | E-09 | ○ |
| C-10 | QuicEndpointStateはDataViewを使用してC++層とデータ共有 | E-10 | ○ |
| C-11 | QuicSessionStateはセッション状態を管理 | E-11 | ○ |
| C-12 | QuicEndpointStatsはBigUint64Arrayで統計情報を管理 | E-12 | ○ |
| C-13 | kOwner, kFinishClose等のシンボルが定義されている | E-13 | ○ |
| C-14 | ビジー状態変更時にquic.endpoint.busy.changeチャンネルに通知 | E-14 | ○ |
| C-15 | エラー発生時にquic.endpoint.errorチャンネルに通知 | E-15 | ○ |
| C-16 | セッションクローズ時にquic.session.closedチャンネルに通知 | E-16 | ○ |
| C-17 | キー更新時にquic.session.update.keyチャンネルに通知 | E-17 | ○ |
| C-18 | クローズ処理中にquic.session.closingチャンネルに通知 | E-18 | ○ |
| C-19 | パス検証完了時にquic.session.path.validationチャンネルに通知 | E-19 | ○ |
| C-20 | セッションチケット受信時にquic.session.ticketチャンネルに通知 | E-20 | ○ |
| C-21 | バージョンネゴシエーション時にquic.session.version.negotiationチャンネルに通知 | E-21 | ○ |
| C-22 | ストリーム受信時にquic.session.received.streamチャンネルに通知 | E-22 | ○ |
| C-23 | サーバーセッション作成時にquic.session.created.serverチャンネルに通知 | E-23 | ○ |
| C-24 | クライアントセッション作成時にquic.session.created.clientチャンネルに通知 | E-24 | ○ |
| C-25 | セッションチケットは再接続時の認証に使用され機密性が高い | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25のセッションチケットの機密性に関する具体的なセキュリティ仕様
  - 候補：TLS 1.3仕様書 / QUICプロトコル仕様 / Node.jsセキュリティガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 診断チャンネルの仕組み自体は既存の確立された機能
- 1: 中リスク - QUIC機能は実験的であり、APIが変更される可能性
- 1: 中リスク - セッションチケットなど機密情報の取り扱いに注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 診断チャンネル名が全て正確に記載されているか確認
- [ ] 各通知のペイロード構造がソースコードと一致しているか確認
- [ ] セキュリティ考慮事項が十分か確認
- [ ] 実験的機能である旨の注意書きが適切か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
