---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-EventEmitter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、優先レビュー項目なし
  - ただし、コードリーディングガイドの行番号はソースコード更新時に要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/events.js` 行208-210（EventEmitterコンストラクタ）
- E-02: `lib/events.js` 行331-353（init()メソッド）
- E-03: `lib/events.js` 行255-257（プロトタイププロパティ）
- E-04: `lib/events.js` 行455-534（emit()メソッド）
- E-05: `lib/events.js` 行467-500（errorイベントの特殊処理）
- E-06: `lib/events.js` 行536-591（_addListener内部関数）
- E-07: `lib/events.js` 行599-603（on/addListenerメソッド）
- E-08: `lib/events.js` 行669-721（removeListenerメソッド）
- E-09: `lib/events.js` 行641-646（onceメソッド）
- E-10: `lib/events.js` 行617-633（_onceWrap関数）
- E-11: `lib/events.js` 行963-1005（静的onceメソッド）
- E-12: `lib/events.js` 行1047-1201（静的onメソッド - AsyncIterator）
- E-13: `lib/events.js` 行261（defaultMaxListeners = 10）
- E-14: `lib/events.js` 行268-278（defaultMaxListenersプロパティ定義）
- E-15: `lib/events.js` 行577-586（MaxListenersExceededWarning）
- E-16: `lib/events.js` 行507-530（リスナー呼び出しロジック）
- E-17: `lib/events.js` 行355-375（addCatch関数）
- E-18: `lib/events.js` 行224-235（captureRejectionsプロパティ）
- E-19: `lib/events.js` 行548-557（newListenerイベント発火）
- E-20: `lib/events.js` 行692-693, 716-717（removeListenerイベント発火）
- E-21: `lib/events.js` 行88（kErrorMonitorシンボル）
- E-22: `lib/events.js` 行245（errorMonitorエクスポート）
- E-23: `lib/events.js` 行460-461（errorMonitorへのemit）
- E-24: `lib/events.js` 行612-615（prependListenerメソッド）
- E-25: `lib/events.js` 行655-661（prependOnceListenerメソッド）
- E-26: `lib/events.js` 行102-201（EventEmitterAsyncResource）
- E-27: `lib/events.js` 行865-876（arrayClone関数）
- E-28: `lib/events.js` 行264-266（checkListener関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventEmitterコンストラクタはinit()を呼び出す | E-01 | ○ |
| C-02 | init()で_events, _eventsCount, _maxListenersが初期化される | E-02 | ○ |
| C-03 | _eventsは`{ __proto__: null }`で初期化される | E-02 | ○ |
| C-04 | emit()はイベント名'error'を特別扱いする | E-04, E-05 | ○ |
| C-05 | errorリスナーがない場合は例外がスローされる | E-05 | ○ |
| C-06 | リスナーは登録順に呼び出される | E-16 | ○ |
| C-07 | _addListener内部関数でリスナー追加ロジックを実装 | E-06 | ○ |
| C-08 | on()はaddListener()のエイリアス | E-07 | ○ |
| C-09 | removeListener()でリスナーを削除できる | E-08 | ○ |
| C-10 | once()で一回限りのリスナーを登録できる | E-09, E-10 | ○ |
| C-11 | 静的once()メソッドはPromiseを返す | E-11 | ○ |
| C-12 | 静的on()メソッドはAsyncIteratorを返す | E-12 | ○ |
| C-13 | defaultMaxListenersのデフォルト値は10 | E-13 | ○ |
| C-14 | setMaxListeners()で最大リスナー数を変更できる | E-14 | ○ |
| C-15 | リスナー数が閾値を超えるとMaxListenersExceededWarningが発行される | E-15 | ○ |
| C-16 | captureRejectionsでPromise rejectionをハンドリングできる | E-17, E-18 | ○ |
| C-17 | newListenerイベントはリスナー追加前に発火する | E-19 | ○ |
| C-18 | removeListenerイベントはリスナー削除後に発火する | E-20 | ○ |
| C-19 | errorMonitorシンボルでエラーを監視できる | E-21, E-22, E-23 | ○ |
| C-20 | prependListener()でリスナーを先頭に追加できる | E-24 | ○ |
| C-21 | prependOnceListener()で一回限りのリスナーを先頭に追加できる | E-25 | ○ |
| C-22 | EventEmitterAsyncResourceクラスが存在する | E-26 | ○ |
| C-23 | リスナー配列はクローンされてからイテレートされる | E-27 | ○ |
| C-24 | checkListener()でリスナーの型検証が行われる | E-28 | ○ |
| C-25 | emit()はリスナーがない場合falseを返す | E-04（行504-505） | ○ |
| C-26 | emit()はリスナーを呼び出した場合trueを返す | E-04（行533） | ○ |
| C-27 | リスナーはReflectApplyで呼び出される | E-16（行508, 520） | ○ |
| C-28 | 単一リスナーは配列ではなく関数として保存される最適化がある | E-06（行562-564） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - EventEmitterはNode.jsの最も安定した基盤機能の1つ
- 0: 低リスク - ソースコードから直接的に確認可能な主張のみ
- 1: 中リスク - コードリーディングガイドの行番号はソースコード更新により変動する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] emit()メソッドのerrorイベント特殊処理が正確に記載されているか確認
- [ ] リスナー登録順序の説明が正確か確認（prepend系メソッドの動作含む）
- [ ] captureRejectionsの動作説明が正確か確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] プログラム呼び出し階層図が実際の実装と一致しているか確認
