---
generated_at: 2026-01-30 17:32:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-無効なコミットメッセージ通知.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `.github/workflows/notify-on-push.yml` 1-4行目（トリガー定義）
- E-02: `.github/workflows/notify-on-push.yml` 30-32行目（ジョブ名と条件）
- E-03: `.github/workflows/notify-on-push.yml` 34-37行目（チェックアウト設定）
- E-04: `.github/workflows/notify-on-push.yml` 38-42行目（コミット検証ステップ）
- E-05: `.github/workflows/notify-on-push.yml` 43-44行目（Slack通知条件）
- E-06: `.github/workflows/notify-on-push.yml` 45-56行目（Slackアクション設定）
- E-07: `.github/workflows/notify-on-push.yml` 47行目（SLACK_COLOR設定）
- E-08: `.github/workflows/notify-on-push.yml` 48行目（SLACK_ICON設定）
- E-09: `.github/workflows/notify-on-push.yml` 50-54行目（SLACK_MESSAGE設定）
- E-10: `.github/workflows/notify-on-push.yml` 55行目（SLACK_USERNAME設定）
- E-11: `.github/workflows/notify-on-push.yml` 56行目（SLACK_WEBHOOK設定）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 3行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mainブランチへのpushイベントでトリガーされる | E-01 | ○ |
| C-02 | リポジトリがnodejs/nodeの場合のみ動作 | E-02 | ○ |
| C-03 | core-validate-commitでコミット検証を行う | E-04 | ○ |
| C-04 | 検証失敗時のみSlack通知が送信される | E-05 | ○ |
| C-05 | 通知カラーは#DE512A | E-07 | ○ |
| C-06 | アイコンURLはhttps://github.com/nodejs.png?size=48 | E-08 | ○ |
| C-07 | 送信元名称はnodejs-bot | E-10 | ○ |
| C-08 | メッセージに<!here>メンションが含まれる | E-09 | ○ |
| C-09 | メッセージに変更前後のコミットハッシュが含まれる | E-09 | ○ |
| C-10 | SLACK_WEBHOOKはシークレットとして管理 | E-11 | ○ |
| C-11 | actions/checkoutでリポジトリをチェックアウト | E-03 | ○ |
| C-12 | persist-credentials: falseを設定 | E-03 | ○ |
| C-13 | タイトルに「Invalid commit was pushed」が含まれる | E-06 | ○ |
| C-14 | COMMITはgithub.event.afterから取得 | E-04 | ○ |
| C-15 | npx -qオプションでquietモード | E-04 | ○ |
| C-16 | 通知種別はSlack通知 | E-12 | ○ |
| C-17 | rtCamp/action-slack-notifyを使用 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `.github/workflows/notify-on-push.yml`のvalidateCommitMessageジョブが正確に記載されているか確認
- [ ] core-validate-commitの実行条件とオプションが正しいか確認
- [ ] Slack通知の条件（failure && steps.commit-check.conclusion == 'failure'）が正確か確認
