---
generated_at: 2026-01-30 17:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-レビュー要求通知.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `.github/workflows/notify-on-review-wanted.yml` 2-7行目（トリガー定義）
- E-02: `.github/workflows/notify-on-review-wanted.yml` 12-14行目（ジョブ条件）
- E-03: `.github/workflows/notify-on-review-wanted.yml` 15-33行目（メッセージ生成ステップ）
- E-04: `.github/workflows/notify-on-review-wanted.yml` 22-27行目（PR判定ロジック）
- E-05: `.github/workflows/notify-on-review-wanted.yml` 28-33行目（Issue判定ロジック）
- E-06: `.github/workflows/notify-on-review-wanted.yml` 35-44行目（Slackアクション設定）
- E-07: `.github/workflows/notify-on-review-wanted.yml` 37行目（MSG_MINIMAL設定）
- E-08: `.github/workflows/notify-on-review-wanted.yml` 38行目（SLACK_COLOR設定）
- E-09: `.github/workflows/notify-on-review-wanted.yml` 39行目（SLACK_ICON設定）
- E-10: `.github/workflows/notify-on-review-wanted.yml` 43行目（SLACK_USERNAME設定）
- E-11: `.github/workflows/notify-on-review-wanted.yml` 44行目（SLACK_WEBHOOK設定）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 4行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | issues.labeledとpull_request_target.labeledでトリガー | E-01 | ○ |
| C-02 | リポジトリがnodejs/nodeの場合のみ動作 | E-02 | ○ |
| C-03 | ラベルがreview wantedの場合のみ動作 | E-02 | ○ |
| C-04 | PRかIssueかをpull_request.numberで判定 | E-04, E-05 | ○ |
| C-05 | PRの場合はpullsのURLを生成 | E-04 | ○ |
| C-06 | Issueの場合はissuesのURLを生成 | E-05 | ○ |
| C-07 | 通知カラーは#3d85c6 | E-08 | ○ |
| C-08 | アイコンURLはhttps://github.com/nodejs.png?size=48 | E-09 | ○ |
| C-09 | 送信元名称はnodejs-bot | E-10 | ○ |
| C-10 | SLACK_WEBHOOKはシークレットとして管理 | E-11 | ○ |
| C-11 | MSG_MINIMALでactions urlを設定 | E-07 | ○ |
| C-12 | タイトルはdefine-messageステップの出力から取得 | E-06 | ○ |
| C-13 | メッセージはdefine-messageステップの出力から取得 | E-06 | ○ |
| C-14 | TITLE_ISSUEとTITLE_PRを環境変数で設定 | E-03 | ○ |
| C-15 | 通知種別はSlack通知 | E-12 | ○ |
| C-16 | rtCamp/action-slack-notifyを使用 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `.github/workflows/notify-on-review-wanted.yml`のトリガー条件（issues/pull_request_target）が正確に記載されているか確認
- [ ] PR/Issue判定ロジックが正しく動作するか確認
- [ ] ラベル名「review wanted」の条件チェックが正確か確認
