---
generated_at: 2026-01-30 17:48:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-HTTPサーバーリクエスト通知.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/_http_server.js` 103-106行目（診断チャンネル定義）
- E-02: `lib/_http_server.js` 104行目（onRequestStartChannel）
- E-03: `lib/_http_server.js` 105行目（onResponseCreatedChannel）
- E-04: `lib/_http_server.js` 106行目（onResponseFinishChannel）
- E-05: `lib/_http_server.js` 202-240行目（ServerResponseコンストラクタ）
- E-06: `lib/_http_server.js` 234-239行目（response.created通知）
- E-07: `lib/_http_server.js` 1184-1315行目（parserOnIncoming関数）
- E-08: `lib/_http_server.js` 1224-1231行目（request.start通知）
- E-09: `lib/_http_server.js` 1114-1167行目（resOnFinish関数）
- E-10: `lib/_http_server.js` 1115-1122行目（response.finish通知）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 8行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つの診断チャンネルを使用 | E-01 | ○ |
| C-02 | http.server.request.startチャンネルが存在 | E-02 | ○ |
| C-03 | http.server.response.createdチャンネルが存在 | E-03 | ○ |
| C-04 | http.server.response.finishチャンネルが存在 | E-04 | ○ |
| C-05 | ServerResponseコンストラクタでresponse.created通知 | E-06 | ○ |
| C-06 | parserOnIncoming()でrequest.start通知 | E-08 | ○ |
| C-07 | resOnFinish()でresponse.finish通知 | E-10 | ○ |
| C-08 | hasSubscribersで事前チェック | E-06, E-08, E-10 | ○ |
| C-09 | response.createdは{request, response}を送信 | E-06 | ○ |
| C-10 | request.startは{request, response, socket, server}を送信 | E-08 | ○ |
| C-11 | response.finishは{request, response, socket, server}を送信 | E-10 | ○ |
| C-12 | ServerResponseはreqを引数に取る | E-05 | ○ |
| C-13 | parserOnIncomingでServerResponseを作成 | E-07 | ○ |
| C-14 | diagnostics_channelのchannel()を使用 | E-01 | ○ |
| C-15 | 通知種別は内部イベント通知 | E-11 | ○ |
| C-16 | lib/_http_server.jsで実装 | E-11 | ○ |
| C-17 | 同期実行される | E-06, E-08, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] `lib/_http_server.js`の3つの診断チャンネル定義が正確か確認
- [ ] 各通知ポイント（created/start/finish）の発火タイミングが正確か確認
- [ ] 通知データ構造（request/response/socket/server）が正確か確認
- [ ] hasSubscribersチェックが全ての通知ポイントで行われているか確認
