---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **日常業務フローの最適化手順**：具体的なコード最適化方法の詳細は推測
  2. **対応ブラウザの詳細**：一般的な推奨ブラウザの記載（明示的な記載なし）
  3. **エラーメッセージの網羅性**：代表的なもののみ記載

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報
- E-03: `docs/code-to-docs/画面設計書/1-V8ToolsLandingPage.md` - Landing Page設計書
- E-04: `docs/code-to-docs/画面設計書/2-SystemAnalyzer.md` - System Analyzer設計書
- E-05: `docs/code-to-docs/画面設計書/3-Profview.md` - Profview設計書
- E-06: `docs/code-to-docs/画面設計書/4-Turbolizer.md` - Turbolizer設計書
- E-07: `docs/code-to-docs/画面設計書/5-TurbolizerInfoView.md` - Turbolizer Info View設計書
- E-08: `docs/code-to-docs/画面設計書/6-HeapStatistics.md` - Heap Statistics設計書
- E-09: `docs/code-to-docs/画面設計書/7-HeapLayout.md` - Heap Layout設計書
- E-10: `docs/code-to-docs/画面設計書/8-ZoneStatistics.md` - Zone Statistics設計書
- E-11: `docs/code-to-docs/画面設計書/9-Callstats.md` - Callstats設計書
- E-12: `docs/code-to-docs/画面設計書/10-ParseProcessor.md` - Parse Processor設計書

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | V8 Toolsは8つの主要ツールを提供 | E-02, E-03 | ○ |
| C-02 | Landing PageはV8 Tools Landing Pageから各ツールへナビゲーション | E-03 | ○ |
| C-03 | System AnalyzerはMaps/ICs/Deoptの分析ツール | E-04 | ○ |
| C-04 | System Analyzerはv8.logファイルを読み込む | E-04 | ○ |
| C-05 | System Analyzerのキーボードナビゲーション | E-04 | ○ |
| C-06 | ProfviewはサンプリングプロファイルをビジュアライズするツールはV8 Profviewから | E-05 | ○ |
| C-07 | Profviewはv8.jsonファイルを読み込む（前処理必要） | E-05 | ○ |
| C-08 | Profviewの表示モード（Bottom-up、Top-down、Function List） | E-05 | ○ |
| C-09 | TurbolizerはTurboFanグラフを可視化 | E-06 | ○ |
| C-10 | Turbolizerは--trace-turboで生成したJSONを読み込む | E-06 | ○ |
| C-11 | Turbolizerのキーボードショートカット（CTRL+L等） | E-06, E-07 | ○ |
| C-12 | Turbolizer Info Viewはヘルプ情報を提供 | E-07 | ○ |
| C-13 | Heap Statisticsは--trace-gc-object-statsで収集したデータを可視化 | E-08 | ○ |
| C-14 | Heap Statisticsの入力ファイル形式（V8出力、results.html、trace.json.gzip） | E-08 | ○ |
| C-15 | Heap Layoutは--trace-gc-heap-layoutで収集したデータを可視化 | E-09 | ○ |
| C-16 | Heap LayoutはEChartsを使用 | E-09 | ○ |
| C-17 | Heap LayoutのPrev/Nextボタンでスナップショット移動 | E-09 | ○ |
| C-18 | Zone Statisticsは--trace-zone-statsで収集したデータを可視化 | E-10 | ○ |
| C-19 | Zone StatisticsはGoogle Chartsを使用 | E-10 | ○ |
| C-20 | Callstatsはランタイムコール統計の比較ツール | E-11 | ○ |
| C-21 | Callstatsの行展開/折りたたみ機能 | E-11 | ○ |
| C-22 | Parse Processorは--log-function-eventsで収集したデータを可視化 | E-12 | ○ |
| C-23 | Parse Processorのスクリプトサイズバーの色分け | E-12 | ○ |
| C-24 | Parse ProcessorはGoogle Chartsを使用 | E-12 | ○ |
| C-25 | System Analyzerのタイムライントラック（tick, timer, map, ic, deopt, code） | E-04 | ○ |
| C-26 | System Analyzerの詳細パネル（script, code, map, ic-list等） | E-04 | ○ |
| C-27 | 認証・権限制御なし（全ツール共通） | E-03, E-04, E-05, E-06 | ○ |
| C-28 | CORS制限の存在（一部ツール） | E-08, E-10 | ○ |
| C-29 | local-server.shでローカルサーバー起動可能 | E-04 | ○ |
| C-30 | データベース操作なし（全ツール共通） | E-03, E-04, E-05, E-06 | ○ |
| C-31 | Landing PageのURL（deps/v8/tools/index.html） | E-03 | ○ |
| C-32 | System AnalyzerのURL（deps/v8/tools/system-analyzer/index.html） | E-04 | ○ |
| C-33 | ProfviewのURL（deps/v8/tools/profview/index.html） | E-05 | ○ |
| C-34 | TurbolizerのURL（deps/v8/tools/turbolizer/index.html） | E-06 | ○ |
| C-35 | Heap StatisticsのURL（deps/v8/tools/heap-stats/index.html） | E-08 | ○ |
| C-36 | Heap LayoutのURL（deps/v8/tools/heap-layout/index.html） | E-09 | ○ |
| C-37 | Zone StatisticsのURL（deps/v8/tools/zone-stats/index.html） | E-10 | ○ |
| C-38 | CallstatsのURL（deps/v8/tools/callstats.html） | E-11 | ○ |
| C-39 | Parse ProcessorのURL（deps/v8/tools/parse-processor.html） | E-12 | ○ |
| C-40 | pako.jsでgzip解凍対応 | E-08, E-10 | ○ |
| C-41 | oboe.jsでJSONストリーミング処理対応 | E-08, E-10 | ○ |
| C-42 | IntersectionObserverで遅延読み込み | E-12 | ○ |
| C-43 | 対応ブラウザ（Chrome、Edge、Safari、Firefox最新版） | **根拠なし** | △ |
| C-44 | 日常業務フローの最適化手順詳細 | **根拠なし** | △ |
| C-45 | エラーメッセージ一覧の網羅性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 対応ブラウザの明示的な記載がドキュメントになし
  - 候補：package.json / README.md / 公式ドキュメント
- 最適化手順の詳細は開発者の知識に依存
  - 候補：V8公式ドキュメント / チュートリアル
- エラーメッセージの完全なリストはソースコード解析が必要
  - 候補：各ツールのソースコード / エラーハンドリング実装

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、各ツールの基本機能説明
- **0: 低リスク** - ファイルパス、URL情報
- **0: 低リスク** - キーボードショートカット、UI要素説明
- **1: 中リスク** - 対応ブラウザ（一般的な推奨値を記載）
- **1: 中リスク** - 日常業務フローの最適化手順（推測を含む）
- **0: 低リスク** - エラーメッセージ（代表例のみ記載と明記）

## 6) レビュアーチェックリスト（最小）
- [ ] 各ツールのURL/ファイルパスが正確か確認
- [ ] キーボードショートカットが最新のソースコードと一致するか確認
- [ ] ログファイル生成コマンドが現行バージョンで動作するか確認
- [ ] 対応ブラウザ情報が組織のポリシーと整合するか確認
- [ ] CORSに関する説明が実際の動作と一致するか確認
- [ ] エラーメッセージの記載漏れがないか確認（必要に応じて追加）
