# V8 Tools 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（V8 Tools Landing Page）](#3-トップページv8-tools-landing-page)

**【業務フローに沿った機能】**
4. [【STEP1】分析データの準備（ログファイル生成）](#4-step1分析データの準備ログファイル生成)
5. [【STEP2-3】パフォーマンス分析ツール（プロファイリング・パース分析）](#5-step2-3パフォーマンス分析ツールプロファイリングパース分析)
6. [【STEP3-4】メモリ分析ツール（ヒープ・Zone分析）](#6-step3-4メモリ分析ツールヒープzone分析)
7. [【STEP4-5】コンパイラ分析ツール（Turbolizer・System Analyzer）](#7-step4-5コンパイラ分析ツールturbolizersystem-analyzer)

**【サポート機能】**
8. [Turbolizer Info View（ヘルプ機能）](#8-turbolizer-info-viewヘルプ機能)
9. [Callstats（比較分析機能）](#9-callstats比較分析機能)
10. [各ツールの共通操作](#10-各ツールの共通操作)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 V8 Toolsとは

V8 Toolsは、V8 JavaScriptエンジンの開発・デバッグ・パフォーマンス分析を支援するWebベースのツール群です。Node.jsおよびChrome/V8エンジンの開発者、パフォーマンスエンジニアが、JavaScriptの実行パフォーマンスを分析・最適化するために使用します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **パフォーマンス分析** | サンプリングプロファイル分析、パース・コンパイル時間分析、ランタイムコール統計 |
| **メモリ分析** | ヒープメモリ使用量分析、ヒープレイアウト可視化、Zoneメモリ分析 |
| **コンパイラ分析** | TurboFanグラフ可視化、Maps/ICs/Deopt分析、最適化フェーズ追跡 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------+
|                        業務フロー                                     |
+---------------------------------------------------------------------+
|                                                                     |
|  【STEP 1】V8/d8/Chromeで分析対象のログファイルを生成                  |
|      |                                                              |
|  【STEP 2】V8 Tools Landing Pageにアクセスし、目的に応じたツールを選択  |
|      |                                                              |
|  【STEP 3】各ツールにログファイルをアップロードし、可視化               |
|      |                                                              |
|  【STEP 4】タイムライン・グラフ・詳細パネルで問題箇所を特定             |
|      |                                                              |
|  【STEP 5】分析結果を基にコードの最適化・改善を実施                     |
|                                                                     |
+---------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **V8/Node.js開発者** | コンパイラ内部動作の分析、最適化フェーズの確認、Maps/ICs/Deoptの追跡 |
| **パフォーマンスエンジニア** | 実行時間のプロファイリング、パース・コンパイル時間の最適化 |
| **メモリ分析者** | ヒープメモリ使用パターンの分析、メモリリークの特定、GC動作の確認 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| System Analyzer | Maps/ICs/Deoptのトレース・デバッグ・分析 | STEP 3-4 |
| Profview | サンプリングプロファイルのビジュアライズ | STEP 3-4 |
| Turbolizer | TurboFanグラフ（Sea of Nodes）の可視化 | STEP 3-4 |
| Heap Statistics | ヒープメモリ使用状況の統計・グラフ表示 | STEP 3-4 |
| Heap Layout | ヒープメモリレイアウトの可視化 | STEP 3-4 |
| Zone Statistics | Zoneメモリ使用量の統計・タイムライン表示 | STEP 3-4 |
| Parse Processor | パース・コンパイル・初回実行の分析 | STEP 3-4 |
| Callstats | ランタイムコール統計の比較 | STEP 3-4 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| V8開発者 | V8エンジン内部の動作を分析・デバッグする開発者 |
| Node.js開発者 | Node.jsアプリケーションのパフォーマンスを最適化する開発者 |
| パフォーマンスエンジニア | Webアプリケーションの実行性能を分析・改善するエンジニア |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

> **注意**: 一部のツールはES Modulesを使用しているため、モダンブラウザが必要です。

---

## 2. ログイン・ログアウト手順

### 2.1 アクセス方法

V8 Toolsは認証不要の静的Webアプリケーションです。ログイン・ログアウト機能はありません。

**アクセス方法：**

1. ブラウザでHTMLファイルを直接開く
   - `deps/v8/tools/index.html`をブラウザで開く

2. ローカルWebサーバー経由でアクセス
   - System Analyzerの場合：`tools/system-analyzer/local-server.sh`を実行
   - `http://localhost:8000/`にアクセス

3. v8.devサイト経由でアクセス（オンライン環境）
   - `https://v8.dev/tools/`にアクセス

### 2.2 CORS制限について

> **重要**: 一部のツール（Heap Statistics、Zone Statistics等）はCORSの制限があり、Webサーバー経由でのアクセスが必要です。ローカルファイルを直接開くと正常に動作しない場合があります。

---

## 3. トップページ（V8 Tools Landing Page）

### 3.1 Landing Pageの概要

V8 Tools Landing Pageは、各種V8開発ツールへのナビゲーションを提供するポータルページです。

**アクセス方法：**
- ファイルパス: `deps/v8/tools/index.html`
- オンライン: `https://v8.dev/tools/`

### 3.2 画面構成

| 領域 | 説明 |
|------|------|
| ヘッダー | V8ロゴ、Tools/Tools Versions/Main Pageへのリンク |
| ツールカードグリッド | 8つの主要ツールへのリンクカード |
| フッター | GitHubリポジトリへのリンク |

### 3.3 各ツールへのアクセス

Landing Pageから各ツールカードをクリックすると、対応するツール画面に遷移します。

| カード名 | 機能概要 |
|---------|---------|
| System Analyzer | Maps/ICsのトレース・デバッグ・分析 |
| Callstats | ランタイムコール統計のビジュアライズ・比較 |
| Heap Stats | ヒープメモリ使用状況のビジュアライズ |
| Heap Layout | ヒープメモリレイアウトのビジュアライズ |
| Parse Processor | パース・コンパイル・初回実行分析 |
| Profview | サンプリングプロファイルビューワー |
| Turbolizer | TurboFanグラフ可視化 |
| Zone Stats | Zoneメモリ使用量分析 |

---

## 4. 【STEP1】分析データの準備（ログファイル生成）

> **業務フローでの位置**: V8/d8/Chromeで分析対象のログファイルを生成するステップです。

### 4.1 ログファイルの種類と生成方法

各ツールで使用するログファイルは、V8の特定フラグを使用して生成します。

| ツール | ログファイル | 生成コマンド例 |
|--------|------------|---------------|
| System Analyzer | v8.log | `d8 --log-all your-script.js` |
| Profview | v8.json | `d8 --prof your-script.js` + 前処理 |
| Turbolizer | TurboFan JSON | `d8 --trace-turbo your-script.js` |
| Heap Stats | トレースファイル | `d8 --trace-gc-object-stats your-script.js` |
| Heap Layout | トレースファイル | `d8 --trace-gc-heap-layout your-script.js` |
| Zone Stats | トレースファイル | `d8 --trace-zone-stats your-script.js` |
| Parse Processor | v8.log | `d8 --log-function-events your-script.js` |
| Callstats | 統計ファイル | ランタイムコール統計出力 |

### 4.2 System Analyzer用ログの生成

**d8での生成：**
```bash
/path/to/d8 --log-all your-script.js
```

**使用可能なフラグ：**
- `--log-all`: 全てのログを出力
- `--log-maps`: Mapイベントのみ
- `--log-ic`: ICイベントのみ
- `--log-deopt`: Deoptイベントのみ
- `--log-code`: コードイベントのみ

### 4.3 Profview用ログの生成

**ステップ1: プロファイル収集**
```bash
/path/to/d8 --prof your-script.js
```

**ステップ2: 前処理**
```bash
linux-tick-processor --preprocess v8.log > v8.json
```

> **Tips**: ソースコード表示を有効にするには、`--log-source-code`フラグを追加してください。

### 4.4 Turbolizer用ログの生成

```bash
/path/to/d8 --trace-turbo your-script.js
```

出力されたJSONファイルをTurbolizerにアップロードします。

---

## 5. 【STEP2-3】パフォーマンス分析ツール（プロファイリング・パース分析）

> **業務フローでの位置**: 生成したログファイルをアップロードし、パフォーマンスを分析するステップです。

### 5.1 Profview（サンプリングプロファイラ）

#### 5.1.1 アクセス方法
- Landing Pageから「Profview」カードをクリック
- 直接アクセス: `deps/v8/tools/profview/index.html`

#### 5.1.2 基本的な操作手順

1. **ファイル選択**: 画面上部のファイル入力で`v8.json`を選択
2. **タイムライン確認**: 時系列でのサンプル分布を確認
3. **コールツリー分析**: 関数呼び出しの階層を確認
4. **時間範囲選択**: タイムライン上でドラッグして範囲を絞り込み

#### 5.1.3 表示モード

| モード | 説明 |
|--------|------|
| Bottom-up | 呼び出し先から呼び出し元を辿る |
| Top-down | 呼び出し元から呼び出し先を辿る |
| Function List | 関数リスト形式で表示 |

#### 5.1.4 カスタマイズオプション

| オプション | 説明 |
|-----------|------|
| Attribution | 帰属方法の選択（js-exclude-bc等） |
| Categories | カテゴリ別表示（code-type、none等） |
| Sort | ソート方法（time、own-time等） |

### 5.2 Parse Processor（パース・コンパイル分析）

#### 5.2.1 アクセス方法
- Landing Pageから「Parse Processor」カードをクリック
- 直接アクセス: `deps/v8/tools/parse-processor.html`

#### 5.2.2 基本的な操作手順

1. **ファイル選択**: `v8.log`ファイルをアップロード
2. **スクリプト一覧確認**: スクリプトサイズバーで全体像を把握
3. **詳細グラフ確認**: スクリプトをクリックして時間推移を確認
4. **関数リスト表示**: グラフポイントをクリックして該当関数を確認

#### 5.2.3 スクリプトサイズバーの色分け

| 色 | 意味 |
|----|------|
| グレー（#505050） | 通常スクリプト |
| オレンジ（#ee6300fc） | eval由来スクリプト |
| 青（#008aff） | ストリーミングコンパイル |
| 緑（#1fad00fc） | デシリアライズ済み |

#### 5.2.4 グラフ操作

- **ズームイン**: グラフ上でドラッグ
- **ズームリセット**: 右クリック
- **関数リスト表示**: ポイントをクリック

---

## 6. 【STEP3-4】メモリ分析ツール（ヒープ・Zone分析）

> **業務フローでの位置**: ヒープメモリやZoneメモリの使用状況を可視化・分析するステップです。

### 6.1 Heap Statistics

#### 6.1.1 アクセス方法
- Landing Pageから「Heap Stats」カードをクリック
- 直接アクセス: `deps/v8/tools/heap-stats/index.html`

#### 6.1.2 基本的な操作手順

1. **ファイルアップロード**: トレースファイルをドラッグ＆ドロップ
2. **グローバルタイムライン確認**: 全期間のメモリ使用量推移を確認
3. **詳細選択**: 特定のオブジェクトタイプや時間範囲を選択
4. **ヒストグラム確認**: オブジェクト分布を確認

#### 6.1.3 対応ファイル形式

- V8出力ファイル
- results.html
- trace.json.gzip

### 6.2 Heap Layout

#### 6.2.1 アクセス方法
- Landing Pageから「Heap Layout」カードをクリック
- 直接アクセス: `deps/v8/tools/heap-layout/index.html`

#### 6.2.2 基本的な操作手順

1. **ファイルアップロード**: トレースファイルをドラッグ＆ドロップ
2. **ヒープサイズトレンド確認**: 時系列変化を確認
3. **スナップショット選択**: クリックまたはPrev/Nextボタンで移動
4. **レイアウト確認**: 選択時点のヒープレイアウトを確認

### 6.3 Zone Statistics

#### 6.3.1 アクセス方法
- Landing Pageから「Zone Stats」カードをクリック
- 直接アクセス: `deps/v8/tools/zone-stats/index.html`

#### 6.3.2 基本的な操作手順

1. **ファイルアップロード**: トレースファイルをドラッグ＆ドロップ
2. **グローバルタイムライン確認**: Zoneメモリ使用量推移を確認
3. **詳細選択**: 特定のZoneや時間範囲を選択

---

## 7. 【STEP4-5】コンパイラ分析ツール（Turbolizer・System Analyzer）

> **業務フローでの位置**: コンパイラの内部動作を分析し、最適化問題を特定するステップです。

### 7.1 Turbolizer

#### 7.1.1 アクセス方法
- Landing Pageから「Turbolizer」カードをクリック
- 直接アクセス: `deps/v8/tools/turbolizer/index.html`

#### 7.1.2 基本的な操作手順

1. **ファイルアップロード**: `CTRL+L`またはアップロードボタンでJSONファイルを選択
2. **フェーズ選択**: フェーズタブから表示するフェーズを選択
3. **ノード選択**: グラフビューでノードをクリック
4. **連携ビュー確認**: ソースコード、逆アセンブリ、Rangesビューで詳細確認

#### 7.1.3 キーボードショートカット

| キー | 動作 |
|-----|------|
| CTRL+L | ファイル選択ダイアログを開く |
| r | グラフ再レイアウト |
| n | 選択ノードの次フェーズ表示 |
| b | 選択ノードの前フェーズ表示 |
| h | ホバーノードの履歴表示 |
| a | 全ノード選択 |
| / | 検索ボックス選択 |

#### 7.1.4 Sea of Nodes固有操作

| キー | 動作 |
|-----|------|
| i | ノードの入力ノードを表示 |
| o | ノードの出力ノードを表示 |
| s | 選択ノードを非表示 |
| u | 非選択ノードを非表示 |

### 7.2 System Analyzer（Indicium）

#### 7.2.1 アクセス方法
- Landing Pageから「System Analyzer」カードをクリック
- 直接アクセス: `deps/v8/tools/system-analyzer/index.html`
- ローカルサーバー: `tools/system-analyzer/local-server.sh`を実行

#### 7.2.2 基本的な操作手順

1. **ファイルアップロード**: v8.logをドラッグ＆ドロップまたはファイル選択
2. **タイムライン確認**: 各トラック（Samples、Timers、Map、IC、Deopt、Code）を確認
3. **時間範囲選択**: タイムライン上でドラッグして範囲を選択
4. **詳細パネル確認**: 各パネルで詳細情報を確認

#### 7.2.3 タイムライントラック

| トラック | 説明 |
|---------|------|
| tick-track | サンプリングプロファイラのtickデータ |
| timer-track | タイマーイベント |
| map-track | Mapイベント |
| ic-track | ICイベント |
| deopt-track | Deoptイベント |
| code-track | コードイベント |

#### 7.2.4 詳細パネル

| パネル | 説明 |
|--------|------|
| script-panel | スクリプトソースコード表示 |
| code-panel | 生成コード詳細表示 |
| map-panel | Map遷移図表示 |
| ic-list | ICイベント一覧 |
| map-list | Mapイベント一覧 |
| deopt-list | Deoptイベント一覧 |
| code-list | コードイベント一覧 |
| profiler-panel | プロファイラー詳細表示 |

#### 7.2.5 キーボードナビゲーション

| キー | 動作 |
|-----|------|
| CTRL + Mouse Move | ツールチップ即座表示 |
| A | 左スクロール |
| D | 右スクロール |
| SHIFT + Arrow Up | Map遷移を前方へ |
| SHIFT + Arrow Down | Map遷移を後方へ |
| + | タイムラインズームイン |
| - | タイムラインズームアウト |

---

## 8. Turbolizer Info View（ヘルプ機能）

### 8.1 アクセス方法

Turbolizerの「Info」タブをクリックすると、キーボードショートカットヘルプが表示されます。

### 8.2 ヘルプ内容

| セクション | 内容 |
|-----------|------|
| Global shortcuts | 全体で使用可能なショートカット |
| Sea of Nodes/Turboshaft graph view | グラフビュー共通操作 |
| Sea of Nodes graph view | Sea of Nodes固有操作 |
| Turboshaft graph view | Turboshaft固有操作 |
| Graph search | 検索機能の使い方 |
| Turboshaft operation effects | エフェクト凡例 |

---

## 9. Callstats（比較分析機能）

### 9.1 アクセス方法
- Landing Pageから「Callstats」カードをクリック
- 直接アクセス: `deps/v8/tools/callstats.html`

### 9.2 基本的な操作手順

1. **ファイルアップロード**: ランタイム統計データファイルをアップロード
2. **ベースライン選択**: 比較基準となるバージョンを選択
3. **データフィルタリング**: カテゴリ別、関数別でフィルタリング
4. **詳細確認**: 行をクリックして詳細を確認

### 9.3 表示機能

| 機能 | 説明 |
|------|------|
| 行展開/折りたたみ | 親行クリックで子行を展開/折りたたみ |
| ポップオーバー | 関数名ホバーで詳細情報表示 |
| ページ詳細テーブル | ページ別の統計確認 |

---

## 10. 各ツールの共通操作

### 10.1 ファイルアップロード

全てのツールで共通のファイルアップロード方法：

1. **ドラッグ＆ドロップ**: ファイルをアップロードエリアにドラッグ＆ドロップ
2. **ファイル選択**: 「ファイルを選択」ボタンをクリックしてファイルを選択

### 10.2 gzip圧縮ファイルの対応

Heap StatisticsとZone Statisticsでは、gzip圧縮されたトレースファイル（trace.json.gzip）を直接アップロードできます。

### 10.3 大容量ファイルの処理

大容量ファイルの場合、以下の機能で効率的に処理されます：
- **プログレス表示**: ファイル読み込み進捗を表示
- **ストリーミング処理**: oboe.jsによるJSONストリーミング処理
- **遅延読み込み**: IntersectionObserverによるグラフの遅延読み込み

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
================================================================
【STEP 1】V8/d8/Chromeで分析対象のログファイルを生成 -> 4章参照
    |
【STEP 2】V8 Tools Landing Pageにアクセス -> 3章参照
    |
【STEP 3】各ツールにログファイルをアップロード -> 5-7章参照
    |
【STEP 4】タイムライン・グラフで問題箇所を特定 -> 5-7章参照
    |
【STEP 5】分析結果を基にコードの最適化を実施
================================================================
```

### 11.1 【開発者】STEP1: ログファイルの生成

分析目的に応じたフラグを使用してログファイルを生成します。

**パフォーマンスプロファイリングの場合：**
```bash
d8 --prof your-script.js
linux-tick-processor --preprocess v8.log > v8.json
```

**メモリ分析の場合：**
```bash
d8 --trace-gc-object-stats your-script.js
```

### 11.2 【開発者】STEP2: ツールへのアクセス

1. ブラウザでV8 Tools Landing Pageを開く
2. 分析目的に応じたツールカードをクリック

### 11.3 【開発者】STEP3-4: データのアップロードと分析

1. 生成したログファイルをツールにアップロード
2. タイムライン・グラフで全体像を把握
3. 問題が疑われる箇所を時間範囲選択で絞り込み
4. 詳細パネルで具体的な問題を特定

### 11.4 【開発者】STEP5: 最適化の実施

分析結果を基に以下の最適化を検討します：

| 問題種別 | 対処方法 |
|---------|---------|
| パース時間が長い | スクリプト分割、遅延読み込み |
| コンパイル時間が長い | 関数サイズの最適化 |
| Deoptが多発 | 型安定化、隠しクラスの維持 |
| メモリ使用量が多い | オブジェクト生成の削減 |

---

## 12. よくある質問と対処法

### 12.1 ログファイルに関するQ&A

**Q: v8.logファイルが生成されません**

A: 以下を確認してください：
1. 正しいフラグを指定しているか確認（`--log-all`等）
2. d8の実行権限があるか確認
3. 出力先ディレクトリの書き込み権限を確認

**Q: ログファイルが大きすぎて処理できません**

A: 以下を試してください：
1. 分析対象のスクリプトを絞り込む
2. 特定のログのみ出力（`--log-maps`等）
3. gzip圧縮してアップロード

### 12.2 ツールアクセスに関するQ&A

**Q: ツールが正しく表示されません**

A: 以下を確認してください：
1. モダンブラウザ（Chrome/Edge最新版）を使用
2. JavaScriptが有効になっているか確認
3. CORS制限がある場合はローカルサーバー経由でアクセス

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| Log file contains errors! | ログファイル解析エラー | 正しい形式のログファイルか確認 |
| Error: Exception during load | JSONファイル読み込みエラー | ファイル形式を確認、sessionStorageをクリア |
| CORS error | クロスオリジン制限 | ローカルサーバー経由でアクセス |

### 13.2 よくあるトラブルと解決方法

**グラフが表示されない**
- 原因: 大容量ファイル、不正なデータ形式
- 解決: ファイルサイズを確認、正しいツールを使用しているか確認

**ファイルがアップロードできない**
- 原因: ファイル形式不一致、CORS制限
- 解決: 対応形式を確認、ローカルサーバーを使用

**タイムラインが空白**
- 原因: ログ生成時のフラグ不足
- 解決: 必要なフラグを追加してログを再生成

### 13.3 ローカルサーバーの起動方法

System Analyzer用のローカルサーバーを起動するには：

```bash
cd deps/v8/tools/system-analyzer
./local-server.sh
```

サーバーが起動したら、`http://localhost:8000/`にアクセスします。

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-30 | 初版作成 |

---

*本マニュアルは、V8 Toolsのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
