---
generated_at: 2026-01-30 18:45:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **NFT-040 クラスタワーカー再起動テスト**：具体的なテストファイル未確認
  2. **NFT-043 インスペクタ接続テスト**：具体的なテストファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `benchmark/common.js` - ベンチマーク共通フレームワーク
- E-02: `benchmark/README.md` - ベンチマークガイドライン
- E-03: `benchmark/http/simple.js` - HTTPベンチマーク実装
- E-04: `benchmark/net/tcp-raw-c2s.js` - TCP転送ベンチマーク実装
- E-05: `benchmark/tls/tls-connect.js` - TLS接続ベンチマーク実装
- E-06: `benchmark/crypto/randomBytes.js` - 暗号化処理ベンチマーク実装
- E-07: `test/README.md` - テストディレクトリガイド
- E-08: `test/pummel/` - 負荷テストディレクトリ
- E-09: `test/pummel/test-crypto-dh-hash.js` - DH暗号テスト実装
- E-10: `test/pummel/test-fs-largefile.js` - 大容量ファイルテスト実装
- E-11: `test/pummel/test-http-many-keep-alive-connections.js` - 大量接続テスト
- E-12: `test/pummel/test-vm-memleak.js` - メモリリークテスト
- E-13: `test/pummel/test-heapsnapshot-near-heap-limit.js` - ヒープスナップショットテスト
- E-14: `SECURITY.md` - セキュリティポリシー・脅威モデル
- E-15: `BUILDING.md` - ビルド手順・サポートプラットフォーム
- E-16: `benchmark/crypto/` - 暗号化ベンチマークディレクトリ
- E-17: `benchmark/streams/` - ストリームベンチマークディレクトリ
- E-18: `benchmark/buffers/` - Bufferベンチマークディレクトリ
- E-19: `test/pummel/test-tls-server-large-request.js` - TLS大容量リクエストテスト
- E-20: `test/pummel/test-https-large-response.js` - HTTPS大容量レスポンステスト
- E-21: `test/abort/` - アボートテストディレクトリ
- E-22: `lib/cluster.js` - クラスタモジュール
- E-23: `benchmark/diagnostics_channel/` - 診断チャネルベンチマーク
- E-24: `benchmark/perf_hooks/` - パフォーマンスフックベンチマーク
- E-25: `benchmark/misc/startup-core.js` - 起動時間ベンチマーク
- E-26: `benchmark/async_hooks/` - 非同期フックベンチマーク
- E-27: `test/pummel/test-crypto-dh-keys.js` - DH鍵交換テスト
- E-28: `test/pummel/test-crypto-pqc-sign-verify-slh-dsa.mjs` - PQC署名テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP接続スループット測定 | E-03 | ○ |
| C-02 | TCP生データ転送スループット測定 | E-04 | ○ |
| C-03 | TLS接続確立性能測定 | E-05 | ○ |
| C-04 | 暗号化処理スループット測定 | E-06 | ○ |
| C-05 | ハッシュ生成スループット測定 | E-16 | ○ |
| C-06 | AES-GCM暗号化/復号スループット測定 | E-16 | ○ |
| C-07 | RSA署名/検証スループット測定 | E-16 | ○ |
| C-08 | Buffer操作スループット測定 | E-18 | ○ |
| C-09 | ストリームパイプ性能測定 | E-17 | ○ |
| C-10 | ファイルシステム読み書き性能測定 | E-01, E-02 | ○ |
| C-11 | URL解析性能測定 | E-01, E-02 | ○ |
| C-12 | HTTP/2接続性能測定 | E-01, E-02 | ○ |
| C-13 | 大量HTTP接続KeepAlive保持テスト | E-11 | ○ |
| C-14 | 大量クライアント同時接続テスト | E-08 | ○ |
| C-15 | HTTP長時間アップロードテスト | E-08 | ○ |
| C-16 | KeepAlive長時間維持テスト | E-08 | ○ |
| C-17 | タイマー長時間実行テスト | E-08 | ○ |
| C-18 | 大容量ファイル処理テスト | E-10 | ○ |
| C-19 | 大容量Buffer確保テスト | E-08 | ○ |
| C-20 | VMメモリリークテスト | E-12 | ○ |
| C-21 | ヒープスナップショット取得テスト | E-13 | ○ |
| C-22 | 子プロセス大量生成テスト | E-08 | ○ |
| C-23 | process.nextTick無限呼び出しテスト | E-08 | ○ |
| C-24 | DH鍵生成整合性テスト | E-09 | ○ |
| C-25 | DH鍵交換テスト | E-27 | ○ |
| C-26 | PQC署名検証テスト | E-28 | ○ |
| C-27 | TLS大容量リクエスト処理テスト | E-19 | ○ |
| C-28 | TLSスロットル処理テスト | E-08 | ○ |
| C-29 | HTTPS大容量レスポンステスト | E-20 | ○ |
| C-30 | HTTPSレスポンス未読み込みテスト | E-08 | ○ |
| C-31 | Linux x64 Tier1互換性テスト | E-15 | ○ |
| C-32 | Linux arm64 Tier1互換性テスト | E-15 | ○ |
| C-33 | Windows x64 Tier1互換性テスト | E-15 | ○ |
| C-34 | macOS x64 Tier1互換性テスト | E-15 | ○ |
| C-35 | macOS arm64 Tier1互換性テスト | E-15 | ○ |
| C-36 | GCC 12.2以降ビルドテスト | E-15 | ○ |
| C-37 | Clang 19.1以降ビルドテスト | E-15 | ○ |
| C-38 | Visual Studio 2022ビルドテスト | E-15 | ○ |
| C-39 | 未捕捉例外によるアボートテスト | E-21 | ○ |
| C-40 | クラスタワーカー再起動テスト | E-22 | △ |
| C-41 | 診断チャネル動作テスト | E-23 | ○ |
| C-42 | パフォーマンスフック動作テスト | E-24 | ○ |
| C-43 | インスペクタ接続テスト | **根拠なし** | △ |
| C-44 | コンソール出力性能テスト | E-01, E-02 | ○ |
| C-45 | ヒープダンプ取得テスト | E-08 | ○ |
| C-46 | ランタイム起動時間測定 | E-25 | ○ |
| C-47 | 非同期フック遅延測定 | E-26 | ○ |
| C-48 | イベントループ遅延測定 | E-01, E-02 | ○ |
| C-49 | ストリームマルチパイプテスト | E-08 | ○ |
| C-50 | 大容量文字列デコードテスト | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-040 クラスタワーカー再起動テスト**：lib/cluster.jsにクラスタ機能は存在するが、ワーカー再起動の具体的な非機能テストファイルが見当たらない
  - 候補：test/parallel/test-cluster-*.js / test/sequential/test-cluster-*.js / 新規テスト作成
- **NFT-043 インスペクタ接続テスト**：lib/inspector.jsは存在するが、接続性能・安定性に関する具体的な非機能テストファイルが見当たらない
  - 候補：test/inspector/ / benchmark/inspector/ / 新規テスト作成

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 性能テスト（NFT-001〜012）：ベンチマークファイルが存在し、測定基盤が確立されている
- **0: 低リスク** - 互換性テスト（NFT-031〜038）：BUILDING.mdに明確なプラットフォーム・ツールチェーンサポート情報が記載
- **1: 中リスク** - 負荷テスト（NFT-013〜023）：test/pummelディレクトリにテストが存在するが、CI上での実行頻度は低い可能性
- **1: 中リスク** - セキュリティテスト（NFT-024〜030）：テストファイルは存在するが、脅威モデルとの完全な対応関係は要確認
- **2: 高リスク** - 可用性テスト（NFT-039〜040）：回復性テストの網羅性が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各性能テストのベースライン値が定義されているか確認
- [ ] 負荷テスト（pummelテスト）のCI実行状況を確認
- [ ] セキュリティテストがSECURITY.mdの脅威モデルを網羅しているか確認
- [ ] Tier 2プラットフォーム（Windows arm64, SmartOS, AIX等）のテストケースが必要か検討
- [ ] クラスタワーカー再起動テストの具体的なテストファイル有無を確認
- [ ] インスペクタ接続テストの具体的なテストファイル有無を確認
- [ ] 実験的プラットフォーム（Alpine Linux, FreeBSD等）のテスト方針を検討
