---
generated_at: 2026-01-30 16:20:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **可用性要件（稼働率・RTO・RPO）**：具体的な数値がコードベースから特定不可
  2. **V8ヒープサイズ設定**：CLIオプションとして存在するが、本コードベース外での定義
  3. **UV_THREADPOOL_SIZE**：libuv側の環境変数であり、Node.jsコードベース外

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/net.js` - ネットワーク接続、タイムアウト、ソケット設定
- E-02: `lib/_http_server.js` - HTTPサーバータイムアウト設定（requestTimeout, headersTimeout, keepAliveTimeout）
- E-03: `lib/tls.js` - TLS設定（バージョン、証明書、再ネゴシエーション制限）
- E-04: `lib/crypto.js` - 暗号化機能（ハッシュ、暗号、鍵生成）
- E-05: `lib/internal/cluster/primary.js` - クラスター構成、スケジューリングポリシー
- E-06: `lib/internal/http2/core.js` - HTTP/2定数（最大フレームサイズ、最大ストリーム数）
- E-07: `lib/perf_hooks.js` - パフォーマンス監視API
- E-08: `lib/internal/util/debuglog.js` - デバッグログ機能
- E-09: `lib/internal/crypto/*.js` - 各種暗号化実装（AES、RSA、ECDSA等）
- E-10: `lib/internal/tls/common.js` - TLS共通設定
- E-11: `lib/diagnostics_channel` - 診断チャンネル（HTTPトレーシング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPリクエストタイムアウトが300,000ms | E-02 (`_http_server.js` L473) | ○ |
| C-02 | HTTPヘッダータイムアウトが60,000ms | E-02 (`_http_server.js` L481) | ○ |
| C-03 | Keep-Aliveタイムアウトが5,000ms | E-02 (`_http_server.js` L493) | ○ |
| C-04 | 接続タイムアウト最小値が10ms | E-01 (`net.js` L264-266) | ○ |
| C-05 | サーバー接続バックログが511 | E-01 (`net.js` L1937) | ○ |
| C-06 | maxConnectionsでの接続数制限 | E-01 (`net.js` L2246) | ○ |
| C-07 | HTTP/2最大ストリーム数が2^32-1 | E-06 (`http2/core.js` L234) | ○ |
| C-08 | HTTP/2最大フレームサイズが2^24-1 | E-06 (`http2/core.js` L231) | ○ |
| C-09 | HTTP/2初期ウィンドウサイズが2^31-1 | E-06 (`http2/core.js` L233) | ○ |
| C-10 | TCP NoDelayオプション対応 | E-01 (`net.js` L608-623) | ○ |
| C-11 | TCP KeepAliveオプション対応 | E-01 (`net.js` L626-652) | ○ |
| C-12 | highWaterMarkでバッファサイズ設定可能 | E-01 (`net.js` L1791-1798) | ○ |
| C-13 | クラスターRound-Robinスケジューリング | E-05 (`cluster/primary.js` L42, L48-58) | ○ |
| C-14 | Primary/Workerアーキテクチャ | E-05 (`cluster/primary.js` L36-39) | ○ |
| C-15 | ワーカープロセス終了検知 | E-05 (`cluster/primary.js` L174-189) | ○ |
| C-16 | Happy Eyeballs対応 | E-01 (`net.js` L143-144, L1118-1220) | ○ |
| C-17 | BlockList対応 | E-01 (`net.js` L509-514, L1078-1081) | ○ |
| C-18 | TLS最小バージョンがTLSv1.2 | E-03 (`tls.js` L92-101) | ○ |
| C-19 | TLS最大バージョンがTLSv1.3 | E-03 (`tls.js` L103-108) | ○ |
| C-20 | クライアント再ネゴシエーション制限3回/600秒 | E-03 (`tls.js` L85-86) | ○ |
| C-21 | ECDH曲線がauto | E-03 (`tls.js` L90) | ○ |
| C-22 | バンドルルート証明書サポート | E-03 (`tls.js` L44-46, L116-120) | ○ |
| C-23 | システムCA証明書サポート | E-03 (`tls.js` L136-141, L162) | ○ |
| C-24 | NODE_EXTRA_CA_CERTSサポート | E-03 (`tls.js` L171-177) | ○ |
| C-25 | AES暗号化サポート | E-04, E-09 (`crypto/aes.js`) | ○ |
| C-26 | ChaCha20-Poly1305サポート | E-09 (`crypto/chacha20_poly1305.js`) | ○ |
| C-27 | RSA暗号化サポート | E-09 (`crypto/rsa.js`) | ○ |
| C-28 | ECDSA/EdDSAサポート | E-09 (`crypto/ec.js`, `crypto/cfrg.js`) | ○ |
| C-29 | ML-DSA/ML-KEMサポート | E-09 (`crypto/ml_dsa.js`, `crypto/ml_kem.js`) | ○ |
| C-30 | PBKDF2/scrypt/HKDF/Argon2サポート | E-04, E-09 | ○ |
| C-31 | 暗号論的乱数生成サポート | E-04 (`crypto.js` L54-58) | ○ |
| C-32 | FIPS準拠オプション | E-04 (`crypto.js` L45-47) | ○ |
| C-33 | maxHeaderSizeオプション | E-02 (`_http_server.js` L453-456) | ○ |
| C-34 | insecureHTTPParserオプション | E-02 (`_http_server.js` L463-466) | ○ |
| C-35 | NODE_DEBUG環境変数サポート | E-08 (`debuglog.js` L32-43) | ○ |
| C-36 | diagnostics_channelサポート | E-02, E-06 (各ファイルの`dc.channel()`) | ○ |
| C-37 | Performance API実装 | E-07 (`perf_hooks.js`) | ○ |
| C-38 | monitorEventLoopDelay | E-07 (`perf_hooks.js` L30) | ○ |
| C-39 | eventLoopUtilization | E-07 (`perf_hooks.js` L31) | ○ |
| C-40 | timerify | E-07 (`perf_hooks.js` L32) | ○ |
| C-41 | HTTPトレーシングチャンネル | E-02 (`_http_server.js` L104-106) | ○ |
| C-42 | HTTP/2トレーシングチャンネル | E-06 (`http2/core.js` L190-201) | ○ |
| C-43 | 稼働率の具体的な数値 | **根拠なし** | △ |
| C-44 | V8ヒープサイズ設定 | **根拠なし**（CLIオプション、コードベース外） | △ |
| C-45 | UV_THREADPOOL_SIZE | **根拠なし**（libuv側の設定） | △ |

## 4) 不足情報（Unknown / Missing）
- **可用性要件の具体的な数値**：Node.jsはランタイムであり、稼働率・RTO・RPOの具体的な要件はアプリケーション設計に依存する
  - 候補：運用ドキュメント / デプロイメントガイド / SLA定義書
- **V8関連設定**：V8エンジン側のオプションであり、Node.jsコードベースでは参照のみ
  - 候補：V8ドキュメント / Node.js CLIオプションドキュメント
- **libuv関連設定**：libuvライブラリ側の設定であり、Node.jsコードベースでは環境変数として参照
  - 候補：libuvドキュメント / Node.jsガイド

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：性能要件（タイムアウト値、バッファサイズ等）- コードから直接抽出
- 0（低リスク）：セキュリティ要件（TLS設定、暗号化機能）- コードから直接抽出
- 0（低リスク）：拡張性要件（クラスター、HTTP/2）- コードから直接抽出
- 0（低リスク）：監視要件（Performance API、診断チャンネル）- コードから直接抽出
- 1（中リスク）：可用性要件 - アプリケーション設計依存のため一般的な記載
- 1（中リスク）：V8/libuv関連 - 外部コンポーネントの設定

## 6) レビュアーチェックリスト（最小）
- [ ] タイムアウト値がソースコードの該当箇所と一致しているか確認
- [ ] TLS設定値が`lib/tls.js`の実装と一致しているか確認
- [ ] HTTP/2定数が`lib/internal/http2/core.js`の定義と一致しているか確認
- [ ] クラスター設定が`lib/internal/cluster/primary.js`の実装と一致しているか確認
- [ ] 可用性要件の「実装依存」表記が適切かどうか確認
- [ ] 暗号化機能一覧が`lib/crypto.js`および`lib/internal/crypto/`の実装を網羅しているか確認
- [ ] 診断チャンネル名がソースコードの定義と一致しているか確認
