# 非機能要件定義書

## 概要

本ドキュメントは、Node.jsランタイム環境の非機能要件を定義します。Node.jsは、サーバーサイドおよびネットワークアプリケーション開発のための高性能なJavaScriptランタイムです。本定義書では、パフォーマンス、可用性、セキュリティ、拡張性、保守性、運用・監視に関する要件をコードベースの分析に基づいて記載します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| HTTPリクエストタイムアウト | 300,000ms（5分）以内 | `_http_server.js`のデフォルト`requestTimeout`値 |
| HTTPヘッダー受信タイムアウト | 60,000ms（1分）以内 | `headersTimeout`のデフォルト値（requestTimeoutの最小値） |
| Keep-Aliveタイムアウト | 5,000ms（5秒） | `keepAliveTimeout`のデフォルト値 |
| 接続タイムアウト（Auto Select Family） | 10ms以上 | `autoSelectFamilyAttemptTimeout`の最小値 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| サーバー接続バックログ | 511（実効512） | `net.js`のデフォルト`backlog`値（カーネルが次の2のべき乗に切り上げ） |
| 最大同時接続数 | 設定可能（`maxConnections`） | サーバーオプションで制限可能 |
| HTTP/2最大ストリーム数 | 2^32 - 1 | `kMaxStreams`定数 |
| HTTP/2最大フレームサイズ | 2^24 - 1 バイト | `kMaxFrameSize`定数 |
| HTTP/2初期ウィンドウサイズ | 2^31 - 1 バイト | `kMaxInitialWindowSize`定数 |

### ネットワークパフォーマンス

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| TCP NoDelay | オプション対応 | Nagleアルゴリズムの無効化によるレイテンシ削減 |
| TCP KeepAlive | オプション対応 | 接続維持のための定期的なプローブ送信 |
| ソケットバッファサイズ | `highWaterMark`で設定可能 | デフォルトは`getDefaultHighWaterMark()`から取得 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 実装依存 | アプリケーションレベルで設計が必要 |
| 計画停止時間 | 設定可能 | graceful shutdownをサポート |
| 障害復旧時間（RTO） | 実装依存 | クラスター構成で短縮可能 |
| 目標復旧時点（RPO） | 実装依存 | アプリケーションレベルで設計が必要 |

### クラスター構成による高可用性

- **スケジューリングポリシー**: Round-Robin（`SCHED_RR`）またはOSネイティブ（`SCHED_NONE`）を選択可能
- **ワーカープロセス管理**: Primary/Workerアーキテクチャによるプロセス分離
- **自動フェイルオーバー**: ワーカープロセスの終了検知と再起動をサポート
- **接続ハンドオフ**: SharedHandleまたはRoundRobinHandleによる接続分散

### ネットワーク冗長性

- **Happy Eyeballs（RFC 8305）対応**: IPv4/IPv6デュアルスタック接続の自動選択
- **接続リトライ**: 複数アドレスへの順次接続試行
- **BlockList対応**: 特定IPアドレスのブロック機能

## セキュリティ要件

### 暗号化・TLS

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| TLS最小バージョン | TLSv1.2（デフォルト） | `--tls-min-v1.0`〜`--tls-min-v1.3`で変更可能 |
| TLS最大バージョン | TLSv1.3（デフォルト） | `--tls-max-v1.2`〜`--tls-max-v1.3`で変更可能 |
| クライアント再ネゴシエーション制限 | 3回/600秒 | DoS攻撃対策 |
| ECDH曲線 | 'auto'（デフォルト） | `DEFAULT_ECDH_CURVE`定数 |

### 証明書管理

- **バンドルルート証明書**: Node.jsに同梱されたCA証明書
- **システムCA証明書**: `--use-system-ca`オプションで利用可能
- **追加CA証明書**: `NODE_EXTRA_CA_CERTS`環境変数で指定可能
- **OpenSSL CA**: `--use-openssl-ca`オプションで利用可能

### 暗号化機能

- **対称暗号**: AES、ChaCha20-Poly1305
- **非対称暗号**: RSA、ECDSA、EdDSA（CFRG曲線）、ML-DSA、ML-KEM
- **ハッシュ関数**: SHA-256、SHA-384、SHA-512等
- **鍵導出関数**: PBKDF2、scrypt、HKDF、Argon2
- **乱数生成**: cryptographically secure PRNG（randomBytes, randomFill, randomUUID）
- **FIPS準拠**: `--enable-fips`または`--force-fips`オプションで有効化可能

### HTTP解析セキュリティ

- **最大ヘッダーサイズ**: `maxHeaderSize`オプションで制限可能
- **不正HTTPパーサー**: `insecureHTTPParser`オプション（非推奨）
- **ステータスコード検証**: 100-999の範囲でのみ許可

## 拡張性要件

### 水平スケーリング

- **クラスターモード**: `cluster`モジュールによるマルチプロセス構成
- **ワーカープロセス**: CPUコア数に応じたワーカー生成
- **ポート共有**: SO_REUSEPORTオプションによる負荷分散

### 垂直スケーリング

- **V8ヒープサイズ**: `--max-old-space-size`、`--max-semi-space-size`で調整可能
- **スレッドプール**: `UV_THREADPOOL_SIZE`環境変数で調整可能

### プロトコル拡張

- **HTTP/1.0、HTTP/1.1**: 標準サポート
- **HTTP/2**: `http2`モジュールで完全サポート
- **QUIC**: 実験的サポート（`internal/quic`）
- **WebSocket**: Upgradeプロトコルでサポート

## 保守性要件

### デバッグ機能

- **NODE_DEBUG環境変数**: モジュール別のデバッグログ出力
- **診断チャンネル**: `diagnostics_channel`による詳細なイベントトレース
- **トレースイベント**: Chrome DevTools形式のパフォーマンストレース
- **インスペクター**: V8 Inspector Protocolによるリモートデバッグ

### コード品質

- **型定義**: TypeScript型定義ファイル（`typings/`）
- **ESLint設定**: 統一されたコーディングスタイル
- **テストカバレッジ**: `test/`ディレクトリによる包括的テスト

### 後方互換性

- **安定版API**: 安定したAPIの長期サポート
- **非推奨警告**: `deprecate()`による段階的な移行サポート
- **レガシーエイリアス**: 旧API名の維持（例: `cluster.isMaster` -> `cluster.isPrimary`）

## 運用・監視要件

### パフォーマンス監視

| 機能 | 説明 | 参照 |
| --- | --- | --- |
| Performance API | W3C Performance APIの実装 | `perf_hooks.js` |
| イベントループ遅延監視 | `monitorEventLoopDelay()` | ヒストグラム形式での計測 |
| イベントループ使用率 | `eventLoopUtilization()` | アイドル時間と処理時間の比率 |
| 関数計測 | `timerify()` | 任意関数の実行時間計測 |
| リソースタイミング | `PerformanceResourceTiming` | ネットワークリクエストの詳細計測 |

### ロギング

| 機能 | 説明 | 参照 |
| --- | --- | --- |
| デバッグログ | `NODE_DEBUG`環境変数 | モジュール別フィルタリング |
| 警告出力 | `process.emitWarning()` | 非推奨APIやセキュリティ警告 |
| コンソール | `console`モジュール | 標準出力・エラー出力 |

### HTTPトレーシング

- **診断チャンネル**:
  - `http.server.request.start`: リクエスト開始
  - `http.server.response.created`: レスポンス作成
  - `http.server.response.finish`: レスポンス完了
- **HTTP/2トレーシング**:
  - `http2.client.stream.*`: クライアントストリームイベント
  - `http2.server.stream.*`: サーバーストリームイベント

### ネットワーク監視

- **診断チャンネル**:
  - `net.client.socket`: クライアントソケット作成
  - `net.server.socket`: サーバーソケット作成
  - `net.server.listen`: サーバーリッスン開始

### メモリ・リソース監視

- **secureHeapUsed()**: 暗号化用セキュアヒープの使用状況
- **process.memoryUsage()**: ヒープ使用量（ランタイムAPI）
- **バッファ統計**: バッファプールの使用状況

## 備考

### 設定可能なタイムアウト一覧

| パラメータ | デフォルト値 | 設定箇所 |
| --- | --- | --- |
| `requestTimeout` | 300,000ms | HTTPサーバーオプション |
| `headersTimeout` | 60,000ms | HTTPサーバーオプション |
| `keepAliveTimeout` | 5,000ms | HTTPサーバーオプション |
| `keepAliveTimeoutBuffer` | 設定可能 | HTTPサーバーオプション |
| `autoSelectFamilyAttemptTimeout` | CLI設定可能 | ネットワークオプション |

### 環境変数による設定

| 環境変数 | 用途 |
| --- | --- |
| `NODE_DEBUG` | デバッグログ出力モジュールの指定 |
| `NODE_EXTRA_CA_CERTS` | 追加CA証明書ファイルパス |
| `NODE_CLUSTER_SCHED_POLICY` | クラスタースケジューリングポリシー（`rr`または`none`） |
| `NODE_PENDING_PIPE_INSTANCES` | Windowsでのパイプインスタンス数 |
| `UV_THREADPOOL_SIZE` | libuvスレッドプールサイズ |

### プラットフォーム固有の考慮事項

- **Windows**: Round-Robinスケジューリングはパフォーマンス上の理由から非推奨
- **Unix**: IPCソケットパスの長さ制限（約100バイト）
- **IPv6リンクローカル**: サーバーバインド時に非リンクローカルアドレスを優先
