---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **エラーレスポンス形式の詳細**：OpenSearch固有のエラーレスポンス形式はコードベースから推測した部分がある
  2. **権限名（パーミッション）の正確性**：セキュリティプラグインの権限名はコアコードに定義がなく推測を含む
  3. **レスポンスJSONサンプルのフィールド網羅性**：レスポンス例は代表的なフィールドのみ記載しており、全フィールドを網羅していない可能性がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/_common.json` — 共通パラメータ定義
- E-02: `rest-api-spec/src/main/resources/rest-api-spec/api/search.json` — Search API仕様
- E-03: `rest-api-spec/src/main/resources/rest-api-spec/api/index.json` — Index Document API仕様
- E-04: `rest-api-spec/src/main/resources/rest-api-spec/api/get.json` — Get Document API仕様
- E-05: `rest-api-spec/src/main/resources/rest-api-spec/api/delete.json` — Delete Document API仕様
- E-06: `rest-api-spec/src/main/resources/rest-api-spec/api/update.json` — Update Document API仕様
- E-07: `rest-api-spec/src/main/resources/rest-api-spec/api/bulk.json` — Bulk API仕様
- E-08: `rest-api-spec/src/main/resources/rest-api-spec/api/mget.json` — Multi Get API仕様
- E-09: `rest-api-spec/src/main/resources/rest-api-spec/api/msearch.json` — Multi Search API仕様
- E-10: `rest-api-spec/src/main/resources/rest-api-spec/api/count.json` — Count API仕様
- E-11: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_by_query.json` — Delete by Query API仕様
- E-12: `rest-api-spec/src/main/resources/rest-api-spec/api/update_by_query.json` — Update by Query API仕様
- E-13: `rest-api-spec/src/main/resources/rest-api-spec/api/reindex.json` — Reindex API仕様
- E-14: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.create.json` — Create Index API仕様
- E-15: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get.json` — Get Index API仕様
- E-16: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.delete.json` — Delete Index API仕様
- E-17: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_mapping.json` — Put Mapping API仕様
- E-18: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_mapping.json` — Get Mapping API仕様
- E-19: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_settings.json` — Put Settings API仕様
- E-20: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_alias.json` — Put Alias API仕様
- E-21: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.health.json` — Cluster Health API仕様
- E-22: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.state.json` — Cluster State API仕様
- E-23: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.stats.json` — Cluster Stats API仕様
- E-24: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.info.json` — Nodes Info API仕様
- E-25: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.stats.json` — Nodes Stats API仕様
- E-26: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.put_pipeline.json` — Put Pipeline API仕様
- E-27: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.get_pipeline.json` — Get Pipeline API仕様
- E-28: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create.json` — Create Snapshot API仕様
- E-29: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.indices.json` — CAT Indices API仕様
- E-30: `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.list.json` — Tasks List API仕様
- E-31: `rest-api-spec/src/main/resources/rest-api-spec/api/info.json` — Info API仕様
- E-32: `server/src/main/java/org/opensearch/rest/RestController.java` — RESTコントローラ実装
- E-33: `server/src/main/java/org/opensearch/rest/BaseRestHandler.java` — RESTハンドラ基底クラス
- E-34: `server/src/main/java/org/opensearch/rest/RestHandler.java` — RESTハンドラインタフェース
- E-35: `server/src/main/java/org/opensearch/plugins/ActionPlugin.java` — プラグインAPIインタフェース（認証ラッパー）
- E-36: `server/src/main/java/org/opensearch/rest/action/` — RESTアクションハンドラディレクトリ（155+クラス）
- E-37: `server/src/main/java/org/opensearch/action/ActionModule.java` — アクション登録モジュール

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ベースURLはデフォルトでport 9200 | E-32（RestController, HttpServerTransport） | ○ |
| C-02 | 認証はプラグインベースのWrapper方式で提供 | E-35（ActionPlugin.getRestHandlerWrapper） | ○ |
| C-03 | 共通パラメータ（pretty, human, error_trace, source, filter_path） | E-01（_common.json） | ○ |
| C-04 | Search APIのパス・メソッド・パラメータ定義 | E-02（search.json） | ○ |
| C-05 | Search APIのクエリパラメータ一覧（30+パラメータ） | E-02（search.json params） | ○ |
| C-06 | Index Document APIのパス・メソッド定義 | E-03（index.json） | ○ |
| C-07 | Index Document APIのパラメータ（op_type, refresh, version等） | E-03（index.json params） | ○ |
| C-08 | Get Document APIのパス・メソッド・パラメータ定義 | E-04（get.json） | ○ |
| C-09 | Delete Document APIのパス・メソッド・パラメータ定義 | E-05（delete.json） | ○ |
| C-10 | Update Document APIのパス・メソッド・パラメータ定義 | E-06（update.json） | ○ |
| C-11 | Update APIのretry_on_conflictパラメータ | E-06（update.json params） | ○ |
| C-12 | Bulk APIのパス・メソッド・パラメータ定義 | E-07（bulk.json） | ○ |
| C-13 | Bulk APIのContent-Typeはapplication/x-ndjson | E-07（bulk.json serialize:bulk） | ○ |
| C-14 | Multi Get APIのパス・メソッド・パラメータ定義 | E-08（mget.json） | ○ |
| C-15 | Multi Search APIのパス・メソッド・パラメータ定義 | E-09（msearch.json） | ○ |
| C-16 | Count APIのパス・メソッド・パラメータ定義 | E-10（count.json） | ○ |
| C-17 | Delete by Query APIのパス・メソッド・パラメータ定義 | E-11（delete_by_query.json） | ○ |
| C-18 | Delete by Query APIのconflictsパラメータ（abort/proceed） | E-11（delete_by_query.json params） | ○ |
| C-19 | Update by Query APIのパス・メソッド・パラメータ定義 | E-12（update_by_query.json） | ○ |
| C-20 | Reindex APIのパス・メソッド・パラメータ定義 | E-13（reindex.json） | ○ |
| C-21 | Create Index APIのパス・メソッド・パラメータ定義 | E-14（indices.create.json） | ○ |
| C-22 | Get Index APIのパス・メソッド・パラメータ定義 | E-15（indices.get.json） | ○ |
| C-23 | Delete Index APIのパス・メソッド・パラメータ定義 | E-16（indices.delete.json） | ○ |
| C-24 | Put Mapping APIのパス・メソッド・パラメータ定義 | E-17（indices.put_mapping.json） | ○ |
| C-25 | Put Mapping APIのwrite_index_onlyパラメータ | E-17（indices.put_mapping.json params） | ○ |
| C-26 | Get Mapping APIのパス・メソッド定義 | E-18（indices.get_mapping.json） | ○ |
| C-27 | Put Settings APIのパス・メソッド・パラメータ定義 | E-19（indices.put_settings.json） | ○ |
| C-28 | Put Alias APIのパス・メソッド定義 | E-20（indices.put_alias.json） | ○ |
| C-29 | Cluster Health APIのパス・メソッド・パラメータ定義 | E-21（cluster.health.json） | ○ |
| C-30 | Cluster Health APIのlevelパラメータ（cluster/indices/shards/awareness_attributes） | E-21（cluster.health.json params） | ○ |
| C-31 | Cluster State APIのパス・メソッド・パラメータ定義 | E-22（cluster.state.json） | ○ |
| C-32 | Cluster Stats APIのパス・メソッド定義 | E-23（cluster.stats.json） | ○ |
| C-33 | Nodes Info APIのパス・メソッド・メトリクス定義 | E-24（nodes.info.json） | ○ |
| C-34 | Nodes Stats APIのパス・メソッド・メトリクス定義 | E-25（nodes.stats.json） | ○ |
| C-35 | Ingest Put Pipeline APIのパス・メソッド定義 | E-26（ingest.put_pipeline.json） | ○ |
| C-36 | Ingest Get Pipeline APIのパス・メソッド定義 | E-27（ingest.get_pipeline.json） | ○ |
| C-37 | Snapshot Create APIのパス・メソッド・パラメータ定義 | E-28（snapshot.create.json） | ○ |
| C-38 | CAT Indices APIのパス・メソッド・パラメータ定義 | E-29（cat.indices.json） | ○ |
| C-39 | Tasks List APIのパス・メソッド・パラメータ定義（stability:experimental） | E-30（tasks.list.json） | ○ |
| C-40 | Info APIのパス定義（GET /） | E-31（info.json） | ○ |
| C-41 | REST APIアーキテクチャの多層構造（HTTP→REST→Transport） | E-32, E-33, E-34, E-36, E-37 | ○ |
| C-42 | master_timeoutが2.0.0で非推奨、cluster_manager_timeoutに置換 | E-14, E-15, E-21（deprecatedフィールド） | ○ |
| C-43 | エラーレスポンスのJSON形式（error.root_cause構造） | **根拠なし**（コードからの推測） | △ |
| C-44 | 各APIの権限名（indices:data/write/index等） | **根拠なし**（セキュリティプラグイン固有のため） | △ |
| C-45 | レスポンスJSONサンプルの全フィールド正確性 | **根拠なし**（一部は一般的な知識に基づく） | △ |

## 4) 不足情報（Unknown / Missing）
- エラーレスポンスの正確な形式は `server/src/main/java/org/opensearch/rest/BytesRestResponse.java` 等のシリアライズ処理を詳細に追跡する必要がある
  - 候補：BytesRestResponse.java / RestStatus.java / OpenSearchException.java
- 各APIの権限名はセキュリティプラグイン（OpenSearch Security Plugin）のコードベースに定義されており、本プロジェクトのスコープ外
  - 候補：opensearch-security プラグインの設定ファイル / ドキュメント
- レスポンスJSONの全フィールドは各Transportアクションのシリアライズ処理を追跡する必要がある
  - 候補：各TransportAction実装 / XContentBuilder使用箇所

## 5) リスクフラグ（レビュー観点）
- 0: API一覧のエンドポイントパスとHTTPメソッド — REST API仕様ファイル（166 JSON）に完全に基づいている
- 0: クエリパラメータの名前・型・デフォルト値 — 各仕様ファイルのparamsから直接抽出
- 1: レスポンスJSONサンプル — 代表的なフィールドは正確だが、網羅性は保証されない
- 1: 権限名 — セキュリティプラグイン依存のため、実際の権限名と異なる可能性がある
- 0: 非推奨パラメータ情報 — JSON仕様のdeprecatedフィールドに基づく
- 1: エラーレスポンス形式 — 一般的なOpenSearchエラー形式だが、API個別のエラーパターンは網羅していない

## 6) レビュアーチェックリスト（最小）
- [ ] API一覧が166エンドポイントを適切にカバーしているか（主要カテゴリの網羅性）
- [ ] 各エンドポイントのHTTPメソッドがrest-api-spec JSONと一致しているか
- [ ] クエリパラメータのデフォルト値が仕様ファイルと一致しているか
- [ ] レスポンスJSONサンプルが実際のOpenSearch応答と整合しているか（実環境での検証推奨）
- [ ] 権限名がセキュリティプラグインの実装と一致しているか（セキュリティプラグイン利用時）
- [ ] 非推奨パラメータの記載が最新バージョンと整合しているか
