# OpenSearch

## 概要

OpenSearchは、Apache 2.0ライセンスのもとで公開されているオープンソースの分散型検索・分析エンジンです。大規模な非構造化データに対して、全文検索、ログ分析、オブザーバビリティなどの機能を提供するエンタープライズ向けソフトウェアスイートです。Elasticsearch 7.10.2からフォークされ、コミュニティ主導で開発が進められています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| 全文検索 | Apache Luceneベースの高速な全文検索エンジン。インデックス作成、クエリDSL、アグリゲーション等をサポート |
| 分散クラスタ | ノード間でのシャード分散、レプリケーション、クラスタ管理、ノードディスカバリ機能 |
| インジェストパイプライン | ドキュメント取り込み時のデータ変換・加工パイプライン（ingest-common, ingest-geoip, ingest-user-agent等） |
| インジェスチョン（データ取り込み） | Kafka, Kinesis, ファイルシステムからのデータストリーミング取り込み |
| プラグインシステム | 拡張可能なプラグインアーキテクチャ（分析、リポジトリ、ディスカバリ、トランスポート等） |
| スクリプティング | Painless, Mustache, Expressionなど複数のスクリプト言語サポート |
| 多言語解析 | ICU, Kuromoji（日本語）, Nori（韓国語）, SmartCN（中国語）, Stempel（ポーランド語）, ウクライナ語等の解析プラグイン |
| リポジトリバックエンド | S3, Azure Blob Storage, GCS, HDFSへのスナップショット保存 |
| セキュリティ | TLS/SSL対応、FIPS 140-2準拠モード、暗号鍵管理（crypto-kms） |
| トランスポート | Netty4ベースのトランスポート層、gRPCサポート、Reactor Netty4対応 |
| オブザーバビリティ | OpenTelemetryベースのテレメトリ機能 |
| キャッシュ | Ehcacheベースのキャッシュ機能 |
| ワークロード管理 | クエリワークロードの管理・制御機能 |

## 技術スタック

### コア

- 言語: Java (JDK 11以上、JDK 24まで対応)
- ビルドツール: Gradle (Gradle Wrapper)
- 検索エンジン基盤: Apache Lucene
- トランスポート: Netty4, gRPC, Reactor Netty4
- ライセンス: Apache License 2.0

### 主要ライブラリ

- Apache Lucene - 全文検索エンジンライブラリ
- Netty4 - 非同期ネットワーク通信フレームワーク
- Protocol Buffers (Protobuf) - クロスバージョン互換性のためのシリアライゼーション
- Ehcache - キャッシュライブラリ
- OpenTelemetry - テレメトリ・オブザーバビリティ
- ANTLR4 / ASM - Painlessスクリプト言語実装
- Spotless (Eclipse JDT formatter) - コードフォーマッタ
- JUnit - テストフレームワーク

## ディレクトリ構成

```
OpenSearch/
├── server/              # OpenSearchサーバーコアコンポーネント
│   └── src/main/java/org/opensearch/
│       ├── action/      # アクション（API操作）
│       ├── cluster/     # クラスタ管理
│       ├── common/      # 共通ユーティリティ
│       ├── index/       # インデックス管理
│       ├── indices/     # インデックスサービス
│       ├── search/      # 検索エンジン
│       ├── transport/   # トランスポート層
│       ├── rest/        # REST API
│       ├── node/        # ノード管理
│       ├── gateway/     # ゲートウェイ
│       ├── discovery/   # ノードディスカバリ
│       ├── plugins/     # プラグインフレームワーク
│       └── ...
├── libs/                # 内部ライブラリ
│   ├── core/            # コアライブラリ
│   ├── common/          # 共通ユーティリティ
│   ├── x-content/       # コンテンツパーサー(JSON, YAML等)
│   ├── geo/             # 地理情報ライブラリ
│   ├── nio/             # NIOユーティリティ
│   ├── ssl-config/      # SSL設定
│   ├── compress/        # 圧縮ライブラリ
│   ├── cli/             # CLIフレームワーク
│   ├── telemetry/       # テレメトリ
│   └── ...
├── modules/             # 標準同梱モジュール
│   ├── analysis-common/ # 共通解析モジュール
│   ├── lang-painless/   # Painlessスクリプト言語
│   ├── reindex/         # Reindex API
│   ├── ingest-common/   # 共通インジェストプロセッサ
│   ├── transport-netty4/# Netty4トランスポート
│   ├── transport-grpc/  # gRPCトランスポート
│   └── ...
├── plugins/             # オプションプラグイン
│   ├── analysis-icu/    # ICU解析
│   ├── analysis-kuromoji/# 日本語解析
│   ├── repository-s3/   # S3リポジトリ
│   ├── discovery-ec2/   # EC2ディスカバリ
│   ├── ingestion-kafka/ # Kafkaインジェスチョン
│   └── ...
├── distribution/        # ディストリビューション(tar, zip, rpm, deb, docker)
├── buildSrc/            # Gradleビルドプラグイン
├── client/              # クライアントライブラリ(REST, Sniffer)
├── test/                # テストフレームワーク・フィクスチャ
├── qa/                  # 品質保証テスト(マルチバージョン、統合テスト等)
├── sandbox/             # 実験的機能(libs, modules, plugins)
├── benchmarks/          # パフォーマンスベンチマーク
├── rest-api-spec/       # REST API仕様
├── scripts/             # ユーティリティスクリプト
└── gradle/              # Gradleビルド設定
```

## セットアップ

### 必要条件

- JDK 11以上（推奨: Temurin/Adoptium JDK 17またはJDK 21）
  - `JAVA_HOME`環境変数の設定が必要
  - 後方互換テストのためにJDK 11、JDK 17も推奨（`JAVA11_HOME`, `JAVA17_HOME`）
- Docker（ディストリビューションビルドおよび一部テストスイートに必要）
- Git

### インストール手順

1. リポジトリをクローン:

```bash
git clone https://github.com/opensearch-project/OpenSearch.git
cd OpenSearch
```

2. 全ディストリビューションをビルド:

```bash
./gradlew assemble
```

3. ローカルプラットフォーム向けディストリビューションのみビルド:

```bash
./gradlew localDistro
```

4. OpenSearchを起動:

```bash
./gradlew run
```

起動後、`http://localhost:9200` でアクセス可能になります。

### Windowsの場合

- `_JAVA_OPTIONS: -Xmx4096M` を設定
- レジストリで `LongPathsEnabled=0x1` を有効化（`Computer\HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\FileSystem`）

## 開発

### テスト実行

```bash
# フルテストスイート
./gradlew check

# プリコミットチェック（小規模テストセット）
./gradlew precommit
```

### コードフォーマット

Eclipse JDT formatterベースのSpotless Gradleプラグインを使用しています。

```bash
# フォーマットチェック
./gradlew spotlessJavaCheck

# フォーマット適用
./gradlew spotlessApply
```

### Protobufコード生成

```bash
./gradlew generateProto
```

### プラグイン付きでの起動

```bash
./gradlew run -PinstalledPlugins="['plugin1', 'plugin2']"
```

### IDE設定

- **IntelliJ IDEA**: File > Open からルートの `build.gradle` を開き、Open as Projectを選択。SDK名を "11" に設定。
- **Visual Studio Code**: Java用コーディングパックとGradle Tasksエクステンションをインストール。
- **Eclipse**: Eclipse Buildshipプラグインをインストール後、`./gradlew eclipse` を実行してからインポート。
