# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph External["外部クライアント"]
        Client["クライアントアプリケーション"]
        Dashboards["OpenSearch Dashboards"]
    end

    subgraph OpenSearchCluster["OpenSearch クラスタ"]
        subgraph Node1["ノード (Coordinating / Data / ClusterManager)"]
            subgraph REST["REST API 層"]
                HttpTransport["HttpServerTransport<br/>(Netty4HttpServerTransport)"]
                RestController["RestController"]
                RestHandlers["RestHandler 群"]
            end

            subgraph ActionLayer["Action / Transport 層"]
                NodeClient["NodeClient"]
                ActionModule["ActionModule<br/>(DynamicActionRegistry)"]
                TransportActions["TransportAction 群"]
                TransportService["TransportService"]
            end

            subgraph ClusterLayer["Cluster 管理層"]
                ClusterService["ClusterService"]
                Coordinator["Coordinator<br/>(Raft-like合意)"]
                DiscoveryModule["DiscoveryModule"]
                GatewayService["GatewayService"]
            end

            subgraph IndexSearchLayer["Index / Search 層"]
                IndicesService["IndicesService"]
                IndexService["IndexService"]
                SearchService["SearchService"]
                IngestService["IngestService"]
                SearchPipeline["SearchPipelineService"]
            end

            subgraph StorageLayer["Storage / Engine 層"]
                IndexShard["IndexShard"]
                InternalEngine["InternalEngine"]
                Translog["Translog"]
                Lucene["Apache Lucene"]
            end

            subgraph PluginLayer["Plugin 層"]
                PluginsService["PluginsService"]
                PluginInterfaces["Plugin Interfaces<br/>(ActionPlugin, SearchPlugin,<br/>AnalysisPlugin, etc.)"]
            end

            subgraph CrossCutting["横断的関心事"]
                ThreadPool["ThreadPool"]
                CircuitBreaker["CircuitBreakerService"]
                IdentityService["IdentityService"]
                Telemetry["Telemetry<br/>(Tracer / MetricsRegistry)"]
                AdmissionControl["AdmissionControlService"]
            end
        end

        subgraph Node2["他ノード"]
            Transport2["TransportService"]
        end
    end

    subgraph ExternalStorage["外部ストレージ"]
        S3["AWS S3"]
        Azure["Azure Blob"]
        GCS["Google Cloud Storage"]
        HDFS["HDFS"]
    end

    subgraph ExternalServices["外部サービス"]
        Kafka["Apache Kafka"]
        Kinesis["AWS Kinesis"]
        OTel["OpenTelemetry Collector"]
    end

    Client -->|"HTTP/HTTPS"| HttpTransport
    Dashboards -->|"HTTP/HTTPS"| HttpTransport
    HttpTransport --> RestController
    RestController --> RestHandlers
    RestHandlers --> NodeClient
    NodeClient --> ActionModule
    ActionModule --> TransportActions
    TransportActions --> TransportService
    TransportActions --> IndicesService
    TransportActions --> SearchService
    TransportActions --> ClusterService

    TransportService -->|"TCP (カスタムプロトコル)"| Transport2

    ClusterService --> Coordinator
    Coordinator --> DiscoveryModule
    ClusterService --> GatewayService

    IndicesService --> IndexService
    IndexService --> IndexShard
    SearchService --> IndexShard
    IngestService --> IndicesService
    SearchPipeline --> SearchService

    IndexShard --> InternalEngine
    InternalEngine --> Lucene
    InternalEngine --> Translog

    PluginsService -.->|"拡張"| RestHandlers
    PluginsService -.->|"拡張"| TransportActions
    PluginsService -.->|"拡張"| IndicesService
    PluginsService -.->|"拡張"| SearchService
    PluginsService -.->|"拡張"| DiscoveryModule

    IndexShard -.->|"スナップショット/リモートストア"| S3
    IndexShard -.->|"スナップショット/リモートストア"| Azure
    IndexShard -.->|"スナップショット/リモートストア"| GCS
    IndexShard -.->|"スナップショット/リモートストア"| HDFS

    IngestService -.->|"ingestion-kafka"| Kafka
    IngestService -.->|"ingestion-kinesis"| Kinesis
    Telemetry -.->|"telemetry-otel"| OTel
```

## リクエスト処理フロー

```mermaid
sequenceDiagram
    participant Client as クライアント
    participant HTTP as HttpServerTransport<br/>(Netty4)
    participant RC as RestController
    participant RH as RestHandler
    participant NC as NodeClient
    participant TA as TransportAction
    participant TS as TransportService
    participant DN as Data Node
    participant IS as IndexShard
    participant Engine as InternalEngine<br/>(Lucene)

    Client->>HTTP: HTTP Request
    HTTP->>RC: dispatchRequest()
    RC->>RH: handleRequest()
    RH->>NC: execute(ActionType, Request)
    NC->>TA: doExecute()

    alt ローカルノードで処理
        TA->>IS: 読み書き操作
        IS->>Engine: Lucene操作
        Engine-->>IS: 結果
        IS-->>TA: 結果
    else リモートノードへ転送
        TA->>TS: sendRequest()
        TS->>DN: TCP (カスタムプロトコル)
        DN->>IS: 読み書き操作
        IS->>Engine: Lucene操作
        Engine-->>IS: 結果
        IS-->>DN: 結果
        DN-->>TS: TransportResponse
        TS-->>TA: 結果
    end

    TA-->>NC: ActionResponse
    NC-->>RH: Response
    RH-->>RC: RestResponse
    RC-->>HTTP: BytesRestResponse
    HTTP-->>Client: HTTP Response
```

## プラグインシステム構成図

```mermaid
graph LR
    subgraph Core["OpenSearch Server Core"]
        Plugin["Plugin<br/>(基底クラス)"]
        PS["PluginsService"]

        subgraph Interfaces["プラグインインターフェース"]
            AP["ActionPlugin"]
            AnP["AnalysisPlugin"]
            SP["SearchPlugin"]
            IP["IngestPlugin"]
            DP["DiscoveryPlugin"]
            NP["NetworkPlugin"]
            RP["RepositoryPlugin"]
            ScP["ScriptPlugin"]
            MP["MapperPlugin"]
            EP["EnginePlugin"]
            IdP["IdentityPlugin"]
            CP["CachePlugin"]
            TP["TelemetryPlugin"]
            SPP["SearchPipelinePlugin"]
            ISP["IndexStorePlugin"]
        end
    end

    subgraph Modules["バンドルモジュール (modules/)"]
        TN4["transport-netty4"]
        LP["lang-painless"]
        IC["ingest-common"]
        AC["analysis-common"]
        RE["reindex"]
        TGRPC["transport-grpc"]
    end

    subgraph Plugins["オプションプラグイン (plugins/)"]
        DE2["discovery-ec2"]
        RS3["repository-s3"]
        AI["analysis-icu"]
        TOT["telemetry-otel"]
        CE["cache-ehcache"]
        IK["ingestion-kafka"]
    end

    PS --> Plugin
    Plugin --> Interfaces

    TN4 -->|implements| NP
    LP -->|implements| ScP
    IC -->|implements| IP
    AC -->|implements| AnP
    RE -->|implements| AP

    DE2 -->|implements| DP
    RS3 -->|implements| RP
    AI -->|implements| AnP
    TOT -->|implements| TP
    CE -->|implements| CP
    IK -->|implements| IP
```

## クラスタ管理・ノード間通信構成図

```mermaid
graph TB
    subgraph Cluster["OpenSearch クラスタ"]
        subgraph CM["Cluster Manager ノード"]
            Coord["Coordinator"]
            CSPub["PublicationTransportHandler"]
            JoinHelper["JoinHelper"]
            LeaderChecker["LeaderChecker"]
        end

        subgraph DN1["Data ノード 1"]
            TS1["TransportService"]
            FC1["FollowersChecker"]
            CS1["ClusterService"]
        end

        subgraph DN2["Data ノード 2"]
            TS2["TransportService"]
            FC2["FollowersChecker"]
            CS2["ClusterService"]
        end

        subgraph DN3["Data ノード 3"]
            TS3["TransportService"]
            FC3["FollowersChecker"]
            CS3["ClusterService"]
        end
    end

    Coord -->|"ClusterState Publish"| CSPub
    CSPub -->|"TCP"| TS1
    CSPub -->|"TCP"| TS2
    CSPub -->|"TCP"| TS3

    DN1 -->|"Join Request"| JoinHelper
    DN2 -->|"Join Request"| JoinHelper
    DN3 -->|"Join Request"| JoinHelper

    LeaderChecker -->|"Heartbeat"| DN1
    LeaderChecker -->|"Heartbeat"| DN2
    LeaderChecker -->|"Heartbeat"| DN3

    FC1 -->|"Leader Check"| CM
    FC2 -->|"Leader Check"| CM
    FC3 -->|"Leader Check"| CM

    TS1 <-->|"シャードレプリケーション"| TS2
    TS2 <-->|"シャードレプリケーション"| TS3
    TS1 <-->|"シャードレプリケーション"| TS3
```

## モジュール依存関係図

```mermaid
graph TD
    Server["server<br/>(opensearch)"]

    subgraph Libs["libs/"]
        Common["opensearch-common"]
        Core["opensearch-core"]
        XContent["opensearch-x-content"]
        Compress["opensearch-compress"]
        Geo["opensearch-geo"]
        CLI["opensearch-cli"]
        SecureSM["opensearch-secure-sm"]
        Telemetry["opensearch-telemetry"]
        TaskCommons["opensearch-task-commons"]
        SSLConfig["opensearch-ssl-config"]
        PluginCL["opensearch-plugin-classloader"]
        Netty4Lib["opensearch-netty4"]
        NIO["opensearch-nio"]
    end

    subgraph External["外部依存"]
        Lucene["Apache Lucene"]
        Log4j["Log4j 2"]
        Netty["Netty 4"]
        Guice["Google Guice"]
        Protobuf["Protobuf"]
        Reactor["Project Reactor"]
        JNA["JNA"]
    end

    Server --> Common
    Server --> Core
    Server --> XContent
    Server --> Compress
    Server --> Geo
    Server --> CLI
    Server --> SecureSM
    Server --> Telemetry
    Server --> TaskCommons
    Server --> Lucene
    Server --> Log4j
    Server --> Guice
    Server --> Protobuf
    Server --> Reactor
    Server --> JNA

    Common --> Core
    XContent --> Core
    Compress --> Core
    CLI --> Core
```
