---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 31
  claims_without_evidence: 4
confidence_derived: 0.89
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：31 / 35、根拠なし：4
- 優先レビュー（高）
  1. **バックアップ頻度・保持期間**：コードからは運用パラメータが特定不可
  2. **本番環境のノード台数・スペック**：テスト構成のみ確認可能
  3. **HAProxyバージョンの本番適用**：テスト用docker-composeからの推定
  4. **監視設計の詳細**：外部監視ツール（Prometheus等）の設定が未検出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `distribution/docker/src/docker/Dockerfile` — Dockerイメージのビルド定義
- E-02: `distribution/docker/docker-compose.yml` — 2ノードクラスタテスト構成
- E-03: `distribution/docker/src/docker/config/opensearch.yml` — Docker用OpenSearch設定
- E-04: `distribution/docker/src/docker/bin/docker-entrypoint.sh` — コンテナエントリーポイント
- E-05: `qa/remote-clusters/docker-compose.yml` — リモートクラスタ+HAProxy構成
- E-06: `qa/remote-clusters/haproxy.cfg` — HAProxy設定
- E-07: `gradle.properties` — Gradleビルドプロパティ
- E-08: `.ci/java-versions.properties` — Java バージョン定義
- E-09: `buildSrc/version.properties` — OpenSearchバージョン定義（3.5.0）
- E-10: `scripts/build.sh` — ビルドスクリプト（マルチプラットフォーム対応）
- E-11: `.github/workflows/gradle-check.yml` — メインCIパイプライン
- E-12: `Vagrantfile` — Vagrant VM テスト環境定義
- E-13: `distribution/docker/build.gradle` — Docker マルチアーキテクチャビルド設定
- E-14: `test/fixtures/s3-fixture/docker-compose.yml` — S3テストフィクスチャ
- E-15: `test/fixtures/gcs-fixture/docker-compose.yml` — GCSテストフィクスチャ
- E-16: `test/fixtures/azure-fixture/docker-compose.yml` — Azureテストフィクスチャ
- E-17: `test/fixtures/minio-fixture/docker-compose.yml` — MinIOテストフィクスチャ
- E-18: `test/fixtures/krb5kdc-fixture/docker-compose.yml` — Kerberos KDCフィクスチャ
- E-19: `distribution/packages/build.gradle` — RPM/DEBパッケージビルド定義
- E-20: `.github/workflows/` — 23種のGitHub Actionsワークフロー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenSearchバージョンは3.5.0 | E-09 | ○ |
| C-02 | Dockerマルチステージビルドを使用 | E-01 | ○ |
| C-03 | tini 0.19.0をinitプロセスとして使用 | E-01 | ○ |
| C-04 | ベースイメージはdnfパッケージマネージャーを使用 | E-01 | ○ |
| C-05 | 非rootユーザー（UID 1000）で実行 | E-01, E-04 | ○ |
| C-06 | REST APIポート9200、Transportポート9300を使用 | E-01, E-02 | ○ |
| C-07 | HAProxyポート9600でリモートクラスタ接続 | E-05, E-06 | ○ |
| C-08 | HAProxyバージョン2.1.2を使用 | E-05 | ○ |
| C-09 | HAProxy maxconn 2000 | E-06 | ○ |
| C-10 | JVMヒープ512MB（テスト構成） | E-02 | ○ |
| C-11 | memlock無制限、nofile 65536設定 | E-02, E-05 | ○ |
| C-12 | network.host: 0.0.0.0で全インターフェースリッスン | E-03 | ○ |
| C-13 | TLS 1.2/1.3サポート | E-07 | ○ |
| C-14 | OpenJDK 21をビルド・ランタイムで使用 | E-08 | ○ |
| C-15 | Gradle 8.10+を使用 | E-07, E-08 | ○ |
| C-16 | Gradleビルドは並列実行・キャッシュ有効 | E-07 | ○ |
| C-17 | Gradle JVMに-Xmx3g割当 | E-07 | ○ |
| C-18 | x86_64, ARM64, PPC64LE, S390x, RISC-V対応 | E-10, E-13 | ○ |
| C-19 | tar.gz, zip, RPM, DEB, Docker形式で配布 | E-10, E-19 | ○ |
| C-20 | FIPS 140-2準拠モードサポート | E-04 | ○ |
| C-21 | キーストアパスワード管理機能 | E-04 | ○ |
| C-22 | setuid/setgidビット除去 | E-01 | ○ |
| C-23 | OS ベンダーCA証明書キーストア使用 | E-01 | ○ |
| C-24 | S3/GCS/Azure/HDFS スナップショットリポジトリ対応 | E-14, E-15, E-16, E-17 | ○ |
| C-25 | Kerberos認証サポート | E-18 | ○ |
| C-26 | GitHub Actions 23ワークフロー | E-20 | ○ |
| C-27 | Jenkins連携（Gradle Check、130分タイムアウト） | E-11 | ○ |
| C-28 | Codecovカバレッジレポート連携 | E-11 | ○ |
| C-29 | Dockerヘルスチェック（15秒待機、10秒間隔） | E-05 | ○ |
| C-30 | Vagrant VM テスト（8192MB/4コア） | E-12 | ○ |
| C-31 | 後方互換性テスト（2.0.0以降） | E-20 | ○ |
| C-32 | バックアップ頻度・保持期間は運用設定依存 | **根拠なし** | △ |
| C-33 | 本番環境ノード台数は2台以上 | **根拠なし** | △ |
| C-34 | 外部監視ツール（Prometheus等）の使用 | **根拠なし** | △ |
| C-35 | HAProxy 2.1.2が本番環境で使用される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **バックアップ運用パラメータ**: コードベースにはスナップショット機能の実装はあるが、運用上の頻度・保持期間はデプロイメント固有の設定であり、ソースコードからは特定不可
  - 候補: 運用マニュアル / デプロイメントガイド / Helmチャート
- **本番環境の具体的スペック**: テスト用docker-compose.ymlからはテスト構成のみ特定可能。本番構成はデプロイメント先に依存
  - 候補: 本番デプロイメント設定 / Terraformコード / Kubernetes マニフェスト
- **外部監視ツール**: Prometheus、Grafana等の監視ツールとの連携設定はコードベース内に検出されなかった
  - 候補: 運用監視設計書 / OpenSearch Dashboards設定 / 外部監視ツール設定
- **HAProxyの本番適用**: HAProxyはテスト用docker-compose.ymlにのみ定義されており、本番環境での使用は推定
  - 候補: 本番デプロイメント設定 / ロードバランサー設定

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: バックアップ設計の頻度・保持期間が未定義 — 運用開始前に具体的なパラメータの決定が必要
- **1（中リスク）**: 監視設計が内部ヘルスチェックに限定 — 本番環境では外部監視ツールとの連携が必要
- **0（低リスク）**: HAProxyバージョンがテスト構成からの推定 — 本番環境では最新安定版の使用を推奨
- **0（低リスク）**: テスト構成のJVMヒープ（512MB）は本番環境では不十分な可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] バックアップ頻度・保持期間の具体値を運用チームと確定する
- [ ] 本番環境のノード台数・JVMヒープサイズ・ディスク容量を確定する
- [ ] 外部監視ツール（Prometheus/Grafana等）との連携設計を追加する
- [ ] HAProxyの本番環境での使用有無とバージョンを確認する
- [ ] FIPS モードの本番環境での適用要否を確認する
- [ ] TLS証明書の管理方式（自動更新等）を確認する
