# インフラ構成図

## 全体システム構成図

```mermaid
graph TB
    subgraph "クライアント"
        CLIENT[REST API クライアント]
    end

    subgraph "ロードバランサー層"
        HAPROXY["HAProxy 2.1.2<br/>TCP Mode<br/>Port: 9600"]
    end

    subgraph "OpenSearch クラスタ"
        subgraph "ノード1"
            OS1["OpenSearch Node 1<br/>クラスタマネージャー / データノード<br/>JVM Heap: 512MB+<br/>Port: 9200 (REST), 9300 (Transport)"]
        end
        subgraph "ノード2"
            OS2["OpenSearch Node 2<br/>クラスタマネージャー / データノード<br/>JVM Heap: 512MB+<br/>Port: 9200 (REST), 9300 (Transport)"]
        end
        subgraph "ノードN"
            OSN["OpenSearch Node N<br/>水平スケーリング可能"]
        end
    end

    subgraph "ストレージ層"
        DATA1["データディレクトリ<br/>/usr/share/opensearch/data"]
        LOGS1["ログディレクトリ<br/>/usr/share/opensearch/logs"]
        REPO["スナップショットリポジトリ<br/>/tmp/opensearch-repo"]
    end

    subgraph "外部ストレージサービス"
        S3["Amazon S3"]
        GCS["Google Cloud Storage"]
        AZURE["Azure Blob Storage"]
        HDFS["HDFS"]
    end

    CLIENT -->|HTTP :9200| OS1
    CLIENT -->|HTTP :9200| OS2
    HAPROXY -->|TCP :9300| OS2
    OS1 <-->|Transport :9300| OS2
    OS1 <-->|Transport :9300| OSN
    OS2 <-->|Transport :9300| OSN
    OS1 --- DATA1
    OS1 --- LOGS1
    OS1 --- REPO
    REPO -.->|スナップショット| S3
    REPO -.->|スナップショット| GCS
    REPO -.->|スナップショット| AZURE
    REPO -.->|スナップショット| HDFS
```

## Docker コンテナ構成図

```mermaid
graph TB
    subgraph "Docker Host"
        subgraph "OpenSearch コンテナ"
            TINI["tini 0.19.0<br/>(init プロセス)"]
            ENTRY["docker-entrypoint.sh<br/>(エントリーポイント)"]
            JDK["OpenJDK 21"]
            OPENSEARCH["OpenSearch プロセス"]
            CONFIG["設定ファイル<br/>opensearch.yml<br/>log4j2.properties<br/>jvm.options"]
            KEYSTORE["OpenSearch Keystore<br/>(暗号化対応)"]

            TINI --> ENTRY
            ENTRY --> OPENSEARCH
            OPENSEARCH --> JDK
            OPENSEARCH --> CONFIG
            OPENSEARCH --> KEYSTORE
        end

        subgraph "ボリュームマウント"
            VOL_DATA["データボリューム<br/>/usr/share/opensearch/data"]
            VOL_LOGS["ログボリューム<br/>→ ホスト: build/logs/"]
            VOL_REPO["リポジトリボリューム<br/>→ ホスト: build/repo/"]
        end

        OPENSEARCH --> VOL_DATA
        OPENSEARCH --> VOL_LOGS
        OPENSEARCH --> VOL_REPO
    end

    subgraph "ネットワーク"
        PORT_9200["Port 9200<br/>REST API"]
        PORT_9300["Port 9300<br/>Transport"]
    end

    OPENSEARCH --> PORT_9200
    OPENSEARCH --> PORT_9300
```

## CI/CD パイプライン構成図

```mermaid
graph LR
    subgraph "ソース管理"
        GH["GitHub<br/>opensearch-project/OpenSearch"]
    end

    subgraph "GitHub Actions"
        GA_CHECK["gradle-check.yml<br/>メインCIパイプライン"]
        GA_ASSEMBLE["assemble.yml<br/>アーティファクト組立"]
        GA_PRECOMMIT["precommit.yml<br/>プレコミットチェック"]
        GA_CODEQL["codeql-analysis.yml<br/>セキュリティ分析"]
        GA_MAVEN["publish-maven-snapshots.yml<br/>Maven公開"]
        GA_RELEASE["auto-release.yml<br/>自動リリース"]
        GA_BENCH["benchmark-pull-request.yml<br/>性能ベンチマーク"]
    end

    subgraph "外部CI"
        JENKINS["Jenkins<br/>Gradle Check 実行<br/>タイムアウト: 130分"]
    end

    subgraph "品質管理"
        CODECOV["Codecov<br/>カバレッジレポート"]
        WHITESOURCE["WhiteSource<br/>依存関係スキャン"]
    end

    subgraph "アーティファクト"
        MAVEN["Maven Central<br/>ライブラリ公開"]
        DOCKER_REG["Docker Registry<br/>コンテナイメージ"]
        PACKAGES["パッケージ<br/>tar.gz / zip / RPM / DEB"]
    end

    GH -->|push/PR| GA_CHECK
    GH -->|push/PR| GA_PRECOMMIT
    GH -->|push/PR| GA_CODEQL
    GH -->|push/PR| GA_BENCH
    GA_CHECK -->|Webhook| JENKINS
    JENKINS -->|結果通知| GA_CHECK
    GA_CHECK -->|カバレッジ| CODECOV
    GA_RELEASE --> MAVEN
    GA_RELEASE --> DOCKER_REG
    GA_ASSEMBLE --> PACKAGES
    GA_MAVEN --> MAVEN
    GH -.-> WHITESOURCE
```

## マルチアーキテクチャビルド構成図

```mermaid
graph TB
    subgraph "ビルドシステム"
        GRADLE["Gradle 8.10+<br/>JVM: -Xmx3g<br/>並列ビルド有効"]
    end

    subgraph "ディストリビューション生成"
        subgraph "アーカイブ"
            TAR_LINUX_X64["Linux x64 tar.gz"]
            TAR_LINUX_ARM64["Linux ARM64 tar.gz"]
            TAR_DARWIN_X64["macOS x64 tar.gz"]
            TAR_DARWIN_ARM64["macOS ARM64 tar.gz"]
            ZIP_WIN_X64["Windows x64 zip"]
            ZIP_WIN_ARM64["Windows ARM64 zip"]
        end

        subgraph "パッケージ"
            RPM_X64["RPM x64"]
            RPM_ARM64["RPM ARM64"]
            DEB_X64["DEB x64"]
            DEB_ARM64["DEB ARM64"]
        end

        subgraph "Docker イメージ"
            DOCKER_X64["Docker x86_64"]
            DOCKER_ARM64["Docker ARM64"]
            DOCKER_PPC64LE["Docker PPC64LE"]
            DOCKER_S390X["Docker S390x"]
            DOCKER_RISCV64["Docker RISC-V 64"]
        end
    end

    GRADLE --> TAR_LINUX_X64
    GRADLE --> TAR_LINUX_ARM64
    GRADLE --> TAR_DARWIN_X64
    GRADLE --> TAR_DARWIN_ARM64
    GRADLE --> ZIP_WIN_X64
    GRADLE --> ZIP_WIN_ARM64
    GRADLE --> RPM_X64
    GRADLE --> RPM_ARM64
    GRADLE --> DEB_X64
    GRADLE --> DEB_ARM64
    GRADLE --> DOCKER_X64
    GRADLE --> DOCKER_ARM64
    GRADLE --> DOCKER_PPC64LE
    GRADLE --> DOCKER_S390X
    GRADLE --> DOCKER_RISCV64
```

## テスト基盤構成図

```mermaid
graph TB
    subgraph "テスト環境"
        subgraph "Docker Compose テスト"
            DC_CLUSTER["マルチノードクラスタ<br/>2ノード構成"]
            DC_REMOTE["リモートクラスタ<br/>2クラスタ + HAProxy"]
            DC_WILDFLY["Wildfly統合テスト"]
        end

        subgraph "テストフィクスチャ (Docker)"
            FIX_S3["S3 フィクスチャ"]
            FIX_GCS["GCS フィクスチャ"]
            FIX_AZURE["Azure フィクスチャ"]
            FIX_MINIO["MinIO フィクスチャ"]
            FIX_HDFS["HDFS フィクスチャ"]
            FIX_KRB["Kerberos KDC フィクスチャ"]
        end

        subgraph "Vagrant VM テスト"
            VM_UBUNTU["Ubuntu"]
            VM_DEBIAN["Debian"]
            VM_CENTOS["CentOS"]
            VM_ORACLE["OracleLinux"]
            VM_FEDORA["Fedora"]
            VM_SLES["SLES"]
            VM_RHEL["RHEL"]
            VM_WIN["Windows"]
        end
    end

    subgraph "Vagrant VM スペック"
        SPEC["VirtualBox<br/>メモリ: 8192MB<br/>CPU: 4コア"]
    end

    VM_UBUNTU --- SPEC
    VM_DEBIAN --- SPEC
    VM_CENTOS --- SPEC
    VM_ORACLE --- SPEC
```
