# インフラ設計書

## 概要

本ドキュメントは、OpenSearch（バージョン 3.5.0）のインフラストラクチャ構成を定義する。OpenSearchは分散型の検索・分析エンジンであり、Dockerコンテナ化されたクラスタ構成を基本とし、複数のアーキテクチャ（x86_64、ARM64、PPC64LE、S390x、RISC-V 64）に対応したマルチプラットフォーム配布を行う。CI/CDにはGitHub ActionsおよびJenkinsを使用し、ビルドシステムにはGradleを採用している。

## システム構成

### 全体構成

OpenSearchは以下の構成要素から成るクラスタ型分散システムである。

- **OpenSearchノード**: データの格納・検索・分析処理を担うコアコンポーネント。マルチノードクラスタ構成が可能
- **クラスタマネージャーノード**: クラスタ状態の管理、ノードの追加・削除を制御
- **HAProxy（テスト/マルチクラスタ環境）**: リモートクラスタ間のTCPレベルのロードバランシングを提供
- **テストフィクスチャ群**: S3、GCS、Azure Blob Storage、MinIO、HDFS、Kerberos KDCなどの外部ストレージシミュレーション

各ノードはDockerコンテナとしてデプロイ可能で、`tini` をinitプロセスとして使用し、専用のエントリーポイントスクリプトによりプロセス管理・セキュリティ設定を行う。

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| OpenSearchノード（データ/クラスタマネージャー兼用） | データ格納・検索・クラスタ管理 | JVMヒープ 512MB〜（`-Xms512m -Xmx512m`）、memlock無制限、nofile 65536 | 2台以上（テスト構成） |
| HAProxy | リモートクラスタ間のTCPプロキシ | maxconn 2000、HAProxy 2.1.2 | 1台（マルチクラスタ構成時） |
| テストフィクスチャ | 外部ストレージ（S3/GCS/Azure/MinIO/HDFS/Kerberos）のエミュレーション | 各サービス固有 | 各1台（テスト時のみ） |

### ネットワーク構成

OpenSearchは以下のポートを使用する。

| ポート | プロトコル | 用途 |
| --- | --- | --- |
| 9200 | HTTP | REST API（クライアント通信） |
| 9300 | TCP | ノード間通信（Transport層） |
| 9600 | TCP | HAProxyフロントエンド（リモートクラスタ接続用） |

- コンテナ環境では `network.host: 0.0.0.0` によりすべてのネットワークインターフェースでリッスン
- ノード間のクラスタ形成は `discovery.seed_hosts` および `cluster.initial_cluster_manager_nodes` 環境変数により制御
- マルチクラスタ構成では HAProxy がTCPモードで9600ポートにバインドし、バックエンドのOpenSearchノード（9300ポート）に転送
- TLS 1.2/1.3をサポート（`systemProp.jdk.tls.client.protocols=TLSv1.2,TLSv1.3`）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| OpenJDK | 21 | OpenSearchランタイム（ビルド: openjdk21、ランタイム: java21） |
| tini | 0.19.0 | コンテナ内initプロセス（シグナル転送・ゾンビプロセス回収） |
| HAProxy | 2.1.2 | リモートクラスタ間TCPロードバランサー |
| Gradle | 8.10+ | ビルドシステム |
| Docker | - | コンテナランタイム |
| Docker Compose | 3.x / 3.7 | マルチコンテナオーケストレーション（テスト環境） |
| dnf（OS パッケージマネージャー） | - | コンテナイメージ内パッケージ管理（ベースイメージ依存） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| Amazon S3 | スナップショットリポジトリ | AWS SDK（テスト時はS3フィクスチャ / MinIOで代替） |
| Google Cloud Storage (GCS) | スナップショットリポジトリ | GCS SDK（テスト時はGCSフィクスチャで代替） |
| Azure Blob Storage | スナップショットリポジトリ | Azure SDK（テスト時はAzureフィクスチャで代替） |
| HDFS | スナップショットリポジトリ | Hadoop クライアント（テスト時はHDFSフィクスチャで代替） |
| Kerberos KDC | 認証基盤 | GSSAPI/Kerberos プロトコル（テスト時はKDCフィクスチャで代替） |
| GitHub Actions | CI/CDパイプライン | Webhook / GitHub API |
| Jenkins | Gradle Check実行 | Generic Webhook Trigger |
| Codecov | コードカバレッジレポート | codecov-action（GitHub Actions連携） |
| Maven Central | 依存関係管理・アーティファクト公開 | Gradle Nebula Publishing |

## スケーリング設計

### 水平スケーリング

- OpenSearchクラスタはノードの追加・削除により水平スケーリング可能
- `cluster.initial_cluster_manager_nodes` でクラスタマネージャーノードを指定し、クォーラムベースのクラスタ形成を行う
- `discovery.seed_hosts` により新規ノードの自動検出が可能

### リソース制御

- JVMヒープサイズは `OPENSEARCH_JAVA_OPTS` 環境変数で制御（例: `-Xms512m -Xmx512m`）
- メモリロック（`bootstrap.memory_lock=true`）によりスワップ防止
- `ulimits` でmemlock（無制限）およびnofile（65536）を設定
- ディスクウォーターマーク設定（`cluster.routing.allocation.disk.watermark.*`）によるシャード配置制御

### マルチアーキテクチャ対応

ビルドシステムは以下のアーキテクチャ向けのディストリビューションを生成可能:

| アーキテクチャ | 配布形式 |
| --- | --- |
| x86_64 (x64) | tar.gz, rpm, deb, zip, Docker |
| ARM64 (aarch64) | tar.gz, rpm, deb, Docker |
| PPC64LE | Docker |
| S390x | Docker |
| RISC-V 64 | Docker |

## 可用性設計

### クラスタ冗長構成

- 最低2ノードのクラスタ構成（テスト環境の標準構成）
- クラスタマネージャーノードの冗長化により単一障害点を排除
- `node.attr.testattr` によるカスタム属性を利用したシャード配置制御が可能

### コンテナ耐障害性

- `tini` initプロセスによるシグナルの適切な転送とゾンビプロセス回収
- Dockerヘルスチェック設定:
  - 開始待機: 15秒
  - チェック間隔: 10秒
  - タイムアウト: 2秒
  - リトライ: 5回
  - チェック方式: `curl -f http://localhost:9200`

### セキュリティ対策

- 非rootユーザー実行（UID 1000 / GID 1000）
- setuid/setgidビットの除去によるスタッククラッシュ攻撃の緩和
- FIPS 140-2準拠モードのサポート（BouncyCastle FIPS）
- キーストアパスワード管理（`KEYSTORE_PASSWORD` 環境変数）
- OS ベンダーのCA証明書キーストアを使用（OpenJDK組み込みCAの置換）

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| インデックスデータ | スナップショットリポジトリ（S3/GCS/Azure/HDFS/共有ファイルシステム） | 運用設定に依存 | 運用設定に依存 |
| コンテナログ | ボリュームマウント（`/usr/share/opensearch/logs` → ホスト側 `build/logs/`） | リアルタイム | 運用設定に依存 |
| リポジトリデータ | 共有ボリューム（`path.repo=/tmp/opensearch-repo`） | スナップショット実行時 | 運用設定に依存 |

## 監視設計

### ヘルスチェック

- Docker Compose環境でのHTTPヘルスチェック（`curl -f http://localhost:9200`）
- HAProxyのTCPチェック（`option tcp-check`）

### ロギング

- Log4j2ベースのログ設定（`config/log4j2.properties`）
- コンテナログはボリュームマウントによりホスト側に永続化
- CI/CDではCodecovによるコードカバレッジ監視

### CI/CDパイプライン監視

- GitHub Actions ワークフロー（23種類）による自動テスト・ビルド・リリース監視
- Gradle Check（Jenkins連携）: 130分タイムアウト、テスト失敗時のPRコメント自動投稿
- CodeQL Analysisによるセキュリティ脆弱性の自動検出
- WhiteSourceによる依存関係脆弱性スキャン

## 備考

### ビルドシステム構成

- Gradle 8.10+によるマルチプロジェクトビルド（並列ビルド有効、ビルドキャッシュ有効）
- Gradle JVM設定: `-Xmx3g -XX:+HeapDumpOnOutOfMemoryError -Xss2m`
- テストJVM最適化: `-XX:TieredStopAtLevel=1 -XX:ReservedCodeCacheSize=64m`

### パッケージング

配布形式は以下をサポート:

| 形式 | 対象OS | JDK同梱 |
| --- | --- | --- |
| tar.gz | Linux, macOS | あり / なし |
| zip | Windows | あり / なし |
| RPM | RHEL系Linux | あり / なし |
| DEB | Debian系Linux | あり / なし |
| Docker | Linux (マルチアーキテクチャ) | あり |

### テスト基盤

- Vagrant: VirtualBox上の複数Linuxディストリビューション（Ubuntu、Debian、CentOS、OracleLinux、Fedora、SLES、RHEL）およびWindows環境でのパッケージテスト（メモリ: 8192MB、CPU: 4コア）
- Docker Compose: マルチノードクラスタテスト、リモートクラスタテスト（HAProxy経由）
- テストフィクスチャ: 外部ストレージサービス（S3/GCS/Azure/MinIO/HDFS）および認証基盤（Kerberos KDC）のコンテナ化されたモック環境
- 後方互換性テスト（BWC）: バージョン2.0.0以降との互換性検証
