---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 25
  claims_without_evidence: 5
confidence_derived: 0.83
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：25 / 30、根拠なし：5
- 優先レビュー（高）
  1. **監査ログの詳細仕様**：コアに監査ログが未実装である旨の確認が必要
  2. **CSRF対策の委譲先**：セキュリティプラグインでの具体的実装の確認が必要
  3. **XSS対策の網羅性**：フロントエンド（Dashboards）側の対策の確認が必要
  4. **RBAC権限体系の詳細**：セキュリティプラグインのロール定義の確認が必要
  5. **TLSプロトコル・暗号スイートの具体値**：運用環境の設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/identity/tokens/BasicAuthToken.java` — Basic認証トークン実装
- E-02: `server/src/main/java/org/opensearch/identity/tokens/BearerAuthToken.java` — Bearer Token実装
- E-03: `server/src/main/java/org/opensearch/identity/tokens/OnBehalfOfClaims.java` — OBO Tokenクレーム定義（300秒デフォルト）
- E-04: `server/src/main/java/org/opensearch/identity/tokens/TokenManager.java` — トークン管理インターフェース
- E-05: `server/src/main/java/org/opensearch/identity/IdentityService.java` — アイデンティティサービス
- E-06: `server/src/main/java/org/opensearch/identity/IdentityPlugin.java` — アイデンティティプラグインインターフェース
- E-07: `server/src/main/java/org/opensearch/identity/Subject.java` — Subject定義
- E-08: `server/src/main/java/org/opensearch/identity/noop/NoopIdentityPlugin.java` — No-Op実装
- E-09: `server/src/main/java/org/opensearch/action/support/ActionFilter.java` — アクションフィルターインターフェース
- E-10: `server/src/main/java/org/opensearch/action/support/ActionFilters.java` — フィルター管理
- E-11: `server/src/main/java/org/opensearch/action/RequestValidators.java` — リクエストバリデーションフレームワーク
- E-12: `server/src/main/java/org/opensearch/plugins/SecureTransportSettingsProvider.java` — Transport TLS設定インターフェース
- E-13: `server/src/main/java/org/opensearch/common/settings/KeyStoreWrapper.java` — キーストア暗号化（AES-GCM、PBKDF2）
- E-14: `server/src/main/java/org/opensearch/common/settings/SecureSettings.java` — セキュア設定インターフェース
- E-15: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/CryptoKmsPlugin.java` — AWS KMSプラグイン
- E-16: `server/src/main/java/org/opensearch/http/CorsHandler.java` — CORS実装
- E-17: `server/src/main/java/org/opensearch/http/HttpTransportSettings.java` — HTTP設定（CORS設定、サイズ制限等）
- E-18: `server/src/main/java/org/opensearch/bootstrap/Security.java` — Javaセキュリティマネージャー初期化
- E-19: `server/src/main/java/org/opensearch/common/util/concurrent/ThreadContext.java` — セキュリティコンテキスト伝播
- E-20: `server/src/main/java/org/opensearch/common/util/RequestUtils.java` — リクエストID検証
- E-21: `server/src/main/java/org/opensearch/bootstrap/SpecialPermission.java` — 特権コードマーキング
- E-22: `plugins/crypto-kms/src/main/plugin-metadata/plugin-security.policy` — プラグインセキュリティポリシー例
- E-23: `server/src/main/java/org/opensearch/OpenSearchSecurityException.java` — セキュリティ例外
- E-24: `server/src/main/java/org/opensearch/rest/RestController.java` — RESTリクエストディスパッチャー
- E-25: `server/src/main/java/org/opensearch/action/admin/cluster/node/reload/NodesReloadSecureSettingsAction.java` — セキュア設定リロード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Basic認証はBase64エンコードのusername:password形式 | E-01 | ○ |
| C-02 | Bearer TokenはJWT形式でheader.payload.signatureの3部構成 | E-02 | ○ |
| C-03 | On-Behalf-Of Tokenのデフォルト有効期限は300秒 | E-03 | ○ |
| C-04 | TokenManagerがOBOトークンとサービスアカウントトークンの発行を担当 | E-04 | ○ |
| C-05 | IdentityServiceが認証プラグインを管理する中央サービス | E-05 | ○ |
| C-06 | IdentityPluginが認証プロバイダのプラグインインターフェース | E-06 | ○ |
| C-07 | Subjectが認証済みエンティティを表現 | E-07 | ○ |
| C-08 | セキュリティプラグイン未導入時はNoopIdentityPluginがデフォルト | E-08 | ○ |
| C-09 | ActionFilterによるトランスポートアクションのインターセプト機構 | E-09, E-10 | ○ |
| C-10 | RequestValidatorsによるリクエスト実行前のバリデーション | E-11 | ○ |
| C-11 | コアにはビルトインのRBAC定義が存在しない | E-08, E-09 | ○ |
| C-12 | SecureTransportSettingsProviderでTLS/SSL設定を提供 | E-12 | ○ |
| C-13 | ホスト名検証がデフォルトで有効 | E-17 | ○ |
| C-14 | デュアルモードはデフォルトで無効 | E-17 | ○ |
| C-15 | KeyStoreWrapperはAES-GCM暗号化を使用 | E-13 | ○ |
| C-16 | 鍵導出にPBKDF2WithHmacSHA512（10,000イテレーション）を使用 | E-13 | ○ |
| C-17 | AWS KMS統合による鍵管理をプラグインで提供 | E-15 | ○ |
| C-18 | SecureSettingsインターフェースで暗号化設定へアクセス | E-14 | ○ |
| C-19 | CORSはデフォルトで無効（false） | E-16, E-17 | ○ |
| C-20 | CORS許可メソッドのデフォルトはOPTIONS,HEAD,GET,POST,PUT,DELETE | E-17 | ○ |
| C-21 | HTTP最大コンテンツ長のデフォルトは100MB | E-17 | ○ |
| C-22 | HTTPヘッダーサイズ制限のデフォルトは16KB | E-17 | ○ |
| C-23 | リクエストIDは32文字の16進数として検証される | E-20 | ○ |
| C-24 | Javaセキュリティマネージャーでプラグインをサンドボックス化 | E-18, E-21, E-22 | ○ |
| C-25 | ThreadContextでセキュリティコンテキストをスレッド間伝播 | E-19 | ○ |
| C-26 | コアにXSSフィルターは未実装、フロントエンドとプラグインに委譲 | **根拠なし** | △ |
| C-27 | コアにCSRFトークン機構は未実装、プラグインに委譲 | **根拠なし** | △ |
| C-28 | 監査ログの詳細機能はセキュリティプラグインが提供 | **根拠なし** | △ |
| C-29 | セキュリティプラグインがLDAP/SAML/OIDC等の外部認証を提供 | **根拠なし** | △ |
| C-30 | セキュリティプラグインがドキュメント/フィールドレベルセキュリティを提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-26〜C-30は、OpenSearch Security Plugin（本リポジトリ外）の機能に関する主張であり、本リポジトリ内のソースコードからは直接的な根拠を確認できない
  - 候補：OpenSearch Security Pluginリポジトリ / OpenSearch公式ドキュメント / セキュリティプラグインのREADME
- コアに「存在しない」ことの証明（C-26、C-27、C-28）は、コードベース全体の検索結果に基づく推定であり、完全な網羅性は保証できない

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: C-26〜C-28 — コアでのセキュリティ機能の未実装箇所。セキュリティプラグインの導入が前提となるため、プラグイン未導入環境でのリスクを確認する必要がある
- **0（低リスク）**: C-29〜C-30 — セキュリティプラグインの機能に関する主張。公式ドキュメントとの整合性確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティプラグイン未導入時のデフォルト動作（NoopIdentityPlugin）が許容可能か確認
- [ ] KeyStoreWrapperの暗号化パラメータ（AES-GCM、PBKDF2 10,000イテレーション）が組織のセキュリティポリシーに適合するか確認
- [ ] CORS設定のデフォルト値が運用環境のセキュリティ要件を満たすか確認
- [ ] セキュリティプラグインが提供する機能（監査ログ、RBAC、CSRF対策等）の導入状況を確認
- [ ] TLSプロトコルバージョンと暗号スイートの具体的な設定値を運用環境で確認
