---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標の方針（C-21）**：明示的な目標値が設定ファイルに存在しないため、「質重視」という方針は推測
  2. **テスト命名規則（C-35）**：コード上のパターンから推測しているが、明示的な規約ドキュメントは未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build.gradle`（ルート）— テストリトライ設定、JaCoCo設定、テストタスク定義
- E-02: `gradle/code-coverage.gradle` — JaCoCo 0.8.13、カバレッジ計測設定
- E-03: `gradle/libs.versions.toml` — テストライブラリバージョン（JUnit 4.13.2, RandomizedRunner 2.7.1, Mockito 5.20.0等）
- E-04: `test/framework/build.gradle` — テストフレームワーク依存関係定義
- E-05: `TESTING.md` — テスト実行方法、基底クラス、ベストプラクティス
- E-06: `DEVELOPER_GUIDE.md` — 開発環境セットアップ、テスト実行手順
- E-07: `.github/workflows/gradle-check.yml` — Jenkins gradle-check CI定義
- E-08: `.github/workflows/precommit.yml` — Precommit CIワークフロー定義
- E-09: `.github/workflows/assemble.yml` — Assemble CIワークフロー定義
- E-10: `.github/workflows/codeql-analysis.yml` — CodeQLセキュリティ解析定義
- E-11: `.github/workflows/benchmark-pull-request.yml` — ベンチマークワークフロー定義
- E-12: `test/framework/src/main/java/org/opensearch/test/OpenSearchTestCase.java` — テスト基底クラス
- E-13: `test/framework/src/main/java/org/opensearch/test/OpenSearchIntegTestCase.java` — 結合テスト基底クラス
- E-14: `test/framework/src/main/java/org/opensearch/test/OpenSearchSingleNodeTestCase.java` — 単一ノードテスト基底クラス
- E-15: `test/fixtures/` — テストフィクスチャ（gcs, s3, azure, minio, hdfs, krb5kdc）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenSearchバージョンは3.5.0 | E-03 | ○ |
| C-02 | Luceneバージョンは10.3.2 | E-03 | ○ |
| C-03 | JUnit 4.13.2を使用 | E-03, E-04 | ○ |
| C-04 | RandomizedTesting Runner 2.7.1を使用 | E-03, E-04 | ○ |
| C-05 | Mockito 5.20.0を使用 | E-03, E-04 | ○ |
| C-06 | Hamcrest 2.1を使用 | E-03, E-04 | ○ |
| C-07 | JaCoCo 0.8.13でカバレッジ計測 | E-02 | ○ |
| C-08 | Gradle Test Retry Plugin 1.6.2を使用 | E-01 | ○ |
| C-09 | CI環境で最大3回リトライ、最大10失敗 | E-01 | ○ |
| C-10 | failOnPassedAfterRetryがfalse | E-01 | ○ |
| C-11 | OpenSearchTestCaseが単体テスト基底クラス | E-05, E-12 | ○ |
| C-12 | OpenSearchSingleNodeTestCaseが単一ノードテスト基底クラス | E-05, E-14 | ○ |
| C-13 | OpenSearchIntegTestCaseが結合テスト基底クラス | E-05, E-13 | ○ |
| C-14 | OpenSearchRestTestCaseがRESTテスト基底クラス | E-05 | ○ |
| C-15 | OpenSearchClientYamlSuiteTestCaseがYAML RESTテスト基底クラス | E-05 | ○ |
| C-16 | gradle-checkワークフローがJenkins経由で実行される | E-07 | ○ |
| C-17 | gradle-checkのタイムアウトは130分 | E-07 | ○ |
| C-18 | CodecovへのカバレッジアップロードがCI統合されている | E-07 | ○ |
| C-19 | precommitがJDK 21, 25 × 5 OSマトリクスで実行 | E-08 | ○ |
| C-20 | CodeQLがmainブランチへのpush/PRおよび週次で実行 | E-10 | ○ |
| C-21 | カバレッジの絶対値目標よりもテストの質を重視する方針 | **根拠なし** | △ |
| C-22 | JaCoCoでtest, internalClusterTest, javaRestTest, yamlRestTestの4種類を集約 | E-02 | ○ |
| C-23 | テストフィクスチャにGCS, S3, Azure, MinIO, HDFS, Kerberosが含まれる | E-15 | ○ |
| C-24 | BWCテストで過去バージョンを自動ダウンロードまたはソースビルド | E-05 | ○ |
| C-25 | @AwaitsFix アノテーションで既知不具合待ちテストを管理 | E-05 | ○ |
| C-26 | ForbiddenAPIsによる禁止API検出 | E-01, E-04 | ○ |
| C-27 | FIPS 140-2対応テストをBouncyCastle FIPSプロバイダで実行 | E-01, E-04 | ○ |
| C-28 | Security Manager Agentを全テストJVMに適用 | E-01 | ○ |
| C-29 | assembleワークフローがJDK 21, 25 × 4 OSで実行 | E-09 | ○ |
| C-30 | benchmarkワークフローがPR時に実行 | E-11 | ○ |
| C-31 | Spotless 8.0.0でコードフォーマット検証 | E-01 | ○ |
| C-32 | JMH 1.35でマイクロベンチマーク | E-03 | ○ |
| C-33 | ByteBuddy 1.17.7を使用 | E-03 | ○ |
| C-34 | Objenesis 3.3を使用 | E-03 | ○ |
| C-35 | テスト命名規則（*Tests.javaが単体、*IT.javaが結合） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-21（カバレッジ目標方針）**: ソースコードやCI設定にカバレッジ閾値の設定が見つからなかったため、「明示的な数値目標は設定されていない」と記載。質重視という方針はTESTING.mdの「Good practices」セクションのガイダンスから推測
  - 候補：プロジェクトのガバナンスドキュメント / Codecov設定ファイル / コントリビューションガイドライン
- **C-35（テスト命名規則）**: コードベースのパターンと `test/framework/build.gradle` の `include "**/*IT.class"` 設定から推測。明示的な命名規約ドキュメントは確認できず
  - 候補：CONTRIBUTING.md / コーディング規約ドキュメント / Wiki

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストツール・バージョン情報 — `gradle/libs.versions.toml` と `build.gradle` から直接取得しており信頼性が高い
- **0（低リスク）**: CI/CDパイプライン構成 — `.github/workflows/` のYAMLファイルから直接取得
- **1（中リスク）**: カバレッジ目標方針 — 明示的な閾値設定が見つからず、方針は推測に基づく
- **0（低リスク）**: テスト基底クラス階層 — TESTING.mdとソースコードの両方で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標の方針が実際のプロジェクト方針と一致しているか確認
- [ ] テスト命名規則が実際のコントリビューションガイドラインと一致しているか確認
- [ ] Flakyテストリストが最新のbuild.gradleと一致しているか確認
- [ ] CI/CDワークフローの構成が現在の運用と一致しているか確認
- [ ] テストフレームワークのバージョンが最新のgradleバージョンカタログと一致しているか確認
