# ER図

本ドキュメントは、OpenSearchのクラスタステートにおけるメタデータエンティティ間の関係をER図として表現したものである。

```mermaid
erDiagram
    Metadata {
        String clusterUUID PK
        boolean clusterUUIDCommitted
        long version
        Settings transientSettings
        Settings persistentSettings
        Settings settings
        int totalNumberOfShards
    }

    IndexMetadata {
        String indexName PK
        String indexUUID UK
        int numberOfShards
        int numberOfReplicas
        int numberOfSearchOnlyReplicas
        int routingNumShards
        int routingPartitionSize
        long version
        long mappingVersion
        long settingsVersion
        long aliasesVersion
        State state
        boolean isSystem
        boolean isRemoteSnapshot
        boolean isAppendOnlyIndex
        Version indexCreatedVersion
    }

    MappingMetadata {
        String type PK
        CompressedXContent source
        boolean routingRequired
    }

    AliasMetadata {
        String alias PK
        CompressedXContent filter
        String indexRouting
        String searchRouting
        Boolean writeIndex
        Boolean isHidden
    }

    IndexTemplateMetadata {
        String name PK
        int order
        Integer version
    }

    ComposableIndexTemplate {
        String name PK
        Long priority
        Long version
    }

    ComponentTemplate {
        String name PK
        Long version
    }

    DataStream {
        String name PK
        long generation
    }

    TimestampField {
        String fieldName PK
    }

    RepositoryMetadata {
        String name PK
        String type
        long generation
        long pendingGeneration
    }

    IndexGraveyard {
        String type PK
    }

    Tombstone {
        String indexName PK
        String indexUUID
        long deleteDateInMillis
    }

    CoordinationMetadata {
        long term PK
    }

    VotingConfiguration {
        String configId PK
    }

    DiscoveryNode {
        String nodeId PK
        String nodeName
        String ephemeralId
        String hostName
        String hostAddress
        Version version
    }

    ShardRouting {
        String shardId PK
        String currentNodeId FK
        String relocatingNodeId FK
        boolean primary
        boolean searchOnly
        ShardRoutingState state
        long expectedShardSize
    }

    WorkloadGroup {
        String _id PK
        String name
        long updatedAtInMillis
        String resiliencyMode
    }

    View {
        String name PK
        String description
        long createdAt
        long modifiedAt
    }

    Target {
        String indexPattern PK
    }

    Metadata ||--o{ IndexMetadata : "indices"
    Metadata ||--o| CoordinationMetadata : "coordinationMetadata"
    Metadata ||--o{ IndexTemplateMetadata : "templates"
    Metadata ||--o{ ComposableIndexTemplate : "composableTemplates"
    Metadata ||--o{ ComponentTemplate : "componentTemplates"
    Metadata ||--o{ DataStream : "dataStreams"
    Metadata ||--o{ RepositoryMetadata : "repositories"
    Metadata ||--o| IndexGraveyard : "indexGraveyard"
    Metadata ||--o{ WorkloadGroup : "workloadGroups"
    Metadata ||--o{ View : "views"

    IndexMetadata ||--o{ MappingMetadata : "mappings"
    IndexMetadata ||--o{ AliasMetadata : "aliases"
    IndexMetadata ||--o{ ShardRouting : "shards"

    DataStream ||--o| TimestampField : "timeStampField"
    DataStream ||--o{ IndexMetadata : "backingIndices"

    ComposableIndexTemplate ||--o{ ComponentTemplate : "composedOf"

    IndexGraveyard ||--o{ Tombstone : "tombstones"

    CoordinationMetadata ||--o| VotingConfiguration : "lastCommittedConfiguration"
    CoordinationMetadata ||--o| VotingConfiguration : "lastAcceptedConfiguration"

    ShardRouting }o--o| DiscoveryNode : "currentNode"
    ShardRouting }o--o| DiscoveryNode : "relocatingNode"

    View ||--o{ Target : "targets"
```

## 関係の説明

| 関係 | カーディナリティ | 説明 |
| --- | --- | --- |
| Metadata - IndexMetadata | 1対多 | 1つのクラスタメタデータが複数のインデックスメタデータを保持する |
| Metadata - CoordinationMetadata | 1対1 | 1つのクラスタメタデータが1つの協調メタデータを保持する |
| Metadata - IndexTemplateMetadata | 1対多 | 1つのクラスタメタデータが複数のレガシーテンプレートを保持する |
| Metadata - ComposableIndexTemplate | 1対多 | 1つのクラスタメタデータが複数のコンポーザブルテンプレートを保持する |
| Metadata - ComponentTemplate | 1対多 | 1つのクラスタメタデータが複数のコンポーネントテンプレートを保持する |
| Metadata - DataStream | 1対多 | 1つのクラスタメタデータが複数のデータストリームを保持する |
| Metadata - RepositoryMetadata | 1対多 | 1つのクラスタメタデータが複数のリポジトリ情報を保持する |
| Metadata - IndexGraveyard | 1対1 | 1つのクラスタメタデータが1つのインデックス墓地を保持する |
| Metadata - WorkloadGroup | 1対多 | 1つのクラスタメタデータが複数のワークロードグループを保持する |
| Metadata - View | 1対多 | 1つのクラスタメタデータが複数のビューを保持する |
| IndexMetadata - MappingMetadata | 1対多 | 1つのインデックスが複数のマッピングを保持する |
| IndexMetadata - AliasMetadata | 1対多 | 1つのインデックスが複数のエイリアスを保持する |
| IndexMetadata - ShardRouting | 1対多 | 1つのインデックスが複数のシャードルーティングを保持する |
| DataStream - IndexMetadata | 1対多 | 1つのデータストリームが複数のバッキングインデックスを参照する |
| DataStream - TimestampField | 1対1 | 1つのデータストリームが1つのタイムスタンプフィールドを保持する |
| ComposableIndexTemplate - ComponentTemplate | 1対多 | 1つのコンポーザブルテンプレートが複数のコンポーネントテンプレートを参照する |
| IndexGraveyard - Tombstone | 1対多 | 1つのインデックス墓地が複数のトゥームストーンを保持する |
| CoordinationMetadata - VotingConfiguration | 1対1 | 協調メタデータが投票設定を保持する（committed / accepted） |
| ShardRouting - DiscoveryNode | 多対1 | 複数のシャードが1つのノードに配置される |
| View - Target | 1対多 | 1つのビューが複数のターゲットを保持する |
