---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **customsの内部構造詳細**：Metadata.customsに格納されるCustom実装の全一覧が未確認
  2. **View.Targetの詳細構造**：Targetクラスの内部フィールド定義が未確認
  3. **IngestionStatusの詳細構造**：IndexMetadataのingestionStatusフィールドの内部構造が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/cluster/metadata/Metadata.java` - Metadataクラスのフィールド定義
- E-02: `server/src/main/java/org/opensearch/cluster/metadata/IndexMetadata.java` - IndexMetadataクラスのフィールド定義・Setting定義
- E-03: `server/src/main/java/org/opensearch/cluster/metadata/MappingMetadata.java` - MappingMetadataクラスのフィールド定義
- E-04: `server/src/main/java/org/opensearch/cluster/metadata/AliasMetadata.java` - AliasMetadataクラスのフィールド定義
- E-05: `server/src/main/java/org/opensearch/cluster/metadata/IndexTemplateMetadata.java` - IndexTemplateMetadataクラスのフィールド定義
- E-06: `server/src/main/java/org/opensearch/cluster/metadata/ComposableIndexTemplate.java` - ComposableIndexTemplateクラスのフィールド定義
- E-07: `server/src/main/java/org/opensearch/cluster/metadata/ComponentTemplate.java` - ComponentTemplateクラスのフィールド定義
- E-08: `server/src/main/java/org/opensearch/cluster/metadata/DataStream.java` - DataStreamクラスのフィールド定義
- E-09: `server/src/main/java/org/opensearch/cluster/metadata/RepositoryMetadata.java` - RepositoryMetadataクラスのフィールド定義
- E-10: `server/src/main/java/org/opensearch/cluster/metadata/IndexGraveyard.java` - IndexGraveyardクラスのフィールド定義
- E-11: `server/src/main/java/org/opensearch/cluster/coordination/CoordinationMetadata.java` - CoordinationMetadataクラスのフィールド定義
- E-12: `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` - DiscoveryNodeクラスのフィールド定義
- E-13: `server/src/main/java/org/opensearch/cluster/routing/ShardRouting.java` - ShardRoutingクラスのフィールド定義
- E-14: `server/src/main/java/org/opensearch/cluster/metadata/WorkloadGroup.java` - WorkloadGroupクラスのフィールド定義
- E-15: `server/src/main/java/org/opensearch/cluster/metadata/View.java` - Viewクラスのフィールド定義
- E-16: `server/src/main/java/org/opensearch/cluster/ClusterState.java` - ClusterStateクラスの構造とドキュメンテーション

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MetadataはclusterUUID, version, coordinationMetadata, indices等のフィールドを持つ | E-01 | ○ |
| C-02 | IndexMetadataはnumberOfShards, numberOfReplicas, state, mappings, aliases等を持つ | E-02 | ○ |
| C-03 | IndexMetadataのシャード数デフォルトは1、最大1024 | E-02 | ○ |
| C-04 | IndexMetadataのレプリカ数デフォルトは1 | E-02 | ○ |
| C-05 | IndexMetadataのStateはOPEN(0)とCLOSE(1)の2値 | E-02 | ○ |
| C-06 | MappingMetadataはtype, source, routingRequiredフィールドを持つ | E-03 | ○ |
| C-07 | AliasMetadataはalias, filter, indexRouting, searchRouting, writeIndex, isHiddenを持つ | E-04 | ○ |
| C-08 | IndexTemplateMetadataはname, order, version, patternsを持つ | E-05 | ○ |
| C-09 | ComposableIndexTemplateはindexPatterns, template, composedOf, priority等を持つ | E-06 | ○ |
| C-10 | ComponentTemplateはtemplate, version, metadataを持つ | E-07 | ○ |
| C-11 | DataStreamはname, timeStampField, indices, generationを持つ | E-08 | ○ |
| C-12 | DataStreamのタイムスタンプフィールドデフォルトは@timestamp | E-08 | ○ |
| C-13 | RepositoryMetadataはname, type, settings, cryptoMetadata, generation, pendingGenerationを持つ | E-09 | ○ |
| C-14 | IndexGraveyardはトゥームストーンのリストを保持し、最大500件がデフォルト | E-10 | ○ |
| C-15 | CoordinationMetadataはterm, lastCommittedConfiguration, lastAcceptedConfiguration, votingConfigExclusionsを持つ | E-11 | ○ |
| C-16 | DiscoveryNodeはnodeName, nodeId, ephemeralId, hostName, hostAddress, address, attributes, version, rolesを持つ | E-12 | ○ |
| C-17 | ShardRoutingはshardId, currentNodeId, relocatingNodeId, primary, searchOnly, state等を持つ | E-13 | ○ |
| C-18 | WorkloadGroupは_id, name, updatedAtInMillis, mutableWorkloadGroupFragmentを持つ | E-14 | ○ |
| C-19 | WorkloadGroupの名前は最大50文字 | E-14 | ○ |
| C-20 | Viewはname, description, createdAt, modifiedAt, targetsを持つ | E-15 | ○ |
| C-21 | Viewは実験的（ExperimentalApi）機能である | E-15 | ○ |
| C-22 | クラスタステートはDiffableインターフェースで差分更新をサポート | E-01, E-02, E-16 | ○ |
| C-23 | IndexMetadataのレプリケーションタイプはDOCUMENTとSEGMENTの2種類 | E-02 | ○ |
| C-24 | リモートストア有効化にはSEGMENTレプリケーションが必須 | E-02 | ○ |
| C-25 | IndexMetadataのnumberOfSearchOnlyReplicasのデフォルトは0 | E-02 | ○ |
| C-26 | MetadataのindicesLookupはSortedMapでインデックス抽象名を管理 | E-01 | ○ |
| C-27 | MetadataのtemplatesはTemplatesMetadata型で管理 | E-01 | ○ |
| C-28 | Metadata.customsにDataStreamMetadata, RepositoriesMetadata等のCustom実装が含まれる | E-01 | △ |
| C-29 | View.Targetの内部フィールドにindexPatternが含まれる | E-15 | △ |
| C-30 | IndexMetadata.ingestionStatusの内部構造（詳細フィールド） | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- C-28: Metadata.customsのCustom実装の完全な一覧はMetadataクラスのソースコードだけでは確定できない。プラグインやモジュールによって拡張されるため、全実装の列挙にはプロジェクト全体のCustom実装クラスの検索が必要。
  - 候補：DataStreamMetadata / RepositoriesMetadata / ComponentTemplateMetadata / ComposableIndexTemplateMetadata / WorkloadGroupMetadata / ViewMetadata
- C-29: View.Targetクラスの詳細なフィールド構造はViewクラスの読み取り範囲（80行）には含まれていなかった。Targetはネストクラスとして定義されている可能性がある。
  - 候補：View.java内のTargetネストクラスの完全な読み取り
- C-30: IngestionStatusクラスの詳細なフィールド構成は、IndexMetadata.javaのインポート文から存在が確認されたが、クラス本体の読み取りは行っていない。
  - 候補：IngestionStatus.java の読み取り

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 各メタデータエンティティのフィールド定義はソースコードのprivate finalフィールドから直接抽出しており、高い信頼性がある
- 0: 低リスク - OpenSearchはRDBMSを使用していないため、テーブル定義としての表現は概念的なものであり、実装との直接的な対応付けが行われている
- 1: 中リスク - Metadata.customsに格納されるCustom実装の全一覧は、プラグイン拡張によって変動する可能性がある
- 1: 中リスク - ER図の関係性はコード上の参照関係から推定しており、実行時の動的な関係は完全には表現できていない可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各テーブル定義のカラム名・データ型がソースコードのフィールド宣言と一致しているか確認
- [ ] Metadata.customsに格納されるCustom実装の一覧が最新であるか確認
- [ ] ER図の関係性（カーディナリティ）がコード上の実装と整合しているか確認
- [ ] View.Targetの詳細構造が正しく記述されているか確認
- [ ] IngestionStatusの内部フィールドが正確であるか確認
- [ ] IndexMetadataの設定パラメータ（デフォルト値・制約）が最新バージョンと一致しているか確認
