# データベース設計書

## 概要

本ドキュメントは、OpenSearchプロジェクトにおけるデータストア構造を設計書として整理したものである。OpenSearchは従来のRDBMS（リレーショナルデータベース）を使用せず、Apache Luceneベースの分散検索エンジンとして独自のデータモデルを採用している。データはクラスタステート（Cluster State）として管理され、インデックス、シャード、ドキュメントという階層構造で保持される。

本設計書では、OpenSearchの内部データモデルを構成する主要なメタデータエンティティを「テーブル」に見立てて記述する。これらのエンティティはJavaオブジェクトとしてシリアライズされ、クラスタステートの一部としてノード間で共有・永続化される。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| Metadata | `org.opensearch.cluster.metadata.Metadata` | クラスタ全体のメタデータを保持するルートエンティティ |
| IndexMetadata | `org.opensearch.cluster.metadata.IndexMetadata` | 個別インデックスのメタデータ（シャード数、レプリカ数、設定、マッピング等） |
| MappingMetadata | `org.opensearch.cluster.metadata.MappingMetadata` | インデックスのフィールドマッピング定義 |
| AliasMetadata | `org.opensearch.cluster.metadata.AliasMetadata` | インデックスエイリアスの定義 |
| IndexTemplateMetadata | `org.opensearch.cluster.metadata.IndexTemplateMetadata` | レガシーインデックステンプレートの定義 |
| ComposableIndexTemplate | `org.opensearch.cluster.metadata.ComposableIndexTemplate` | コンポーザブルインデックステンプレートの定義 |
| ComponentTemplate | `org.opensearch.cluster.metadata.ComponentTemplate` | コンポーネントテンプレートの定義（再利用可能なテンプレート部品） |
| DataStream | `org.opensearch.cluster.metadata.DataStream` | 時系列データ向けデータストリームの定義 |
| RepositoryMetadata | `org.opensearch.cluster.metadata.RepositoryMetadata` | スナップショットリポジトリの登録情報 |
| IndexGraveyard | `org.opensearch.cluster.metadata.IndexGraveyard` | 削除済みインデックスの墓標（トゥームストーン）コレクション |
| CoordinationMetadata | `org.opensearch.cluster.coordination.CoordinationMetadata` | クラスタ協調（選挙・投票設定）メタデータ |
| DiscoveryNode | `org.opensearch.cluster.node.DiscoveryNode` | クラスタに参加しているノードの情報 |
| ShardRouting | `org.opensearch.cluster.routing.ShardRouting` | シャードのルーティング・配置情報 |
| WorkloadGroup | `org.opensearch.cluster.metadata.WorkloadGroup` | ワークロードグループ（リソース制限設定） |
| View | `org.opensearch.cluster.metadata.View` | データビュー定義（実験的機能） |

## 各テーブル定義

### 1. Metadata

クラスタ全体のメタデータを保持するルートエンティティ。全インデックスメタデータ、テンプレート、カスタムメタデータを集約して管理する。クラスタステートの中核をなすオブジェクトである。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| clusterUUID | String | NO | クラスタの一意識別子（UUID） |
| clusterUUIDCommitted | boolean | NO | クラスタUUIDがコミット済みかどうか |
| version | long | NO | メタデータバージョン番号 |
| coordinationMetadata | CoordinationMetadata | NO | クラスタ協調メタデータへの参照 |
| transientSettings | Settings | NO | 一時的なクラスタ設定（再起動で消失） |
| persistentSettings | Settings | NO | 永続的なクラスタ設定 |
| settings | Settings | NO | transientSettingsとpersistentSettingsの統合設定 |
| hashesOfConsistentSettings | DiffableStringMap | NO | 一貫性のある設定のハッシュマップ |
| indices | Map\<String, IndexMetadata\> | NO | インデックス名をキーとしたインデックスメタデータのマップ |
| templates | TemplatesMetadata | NO | インデックステンプレートメタデータ |
| customs | Map\<String, Custom\> | NO | カスタムメタデータ（DataStreamMetadata、RepositoriesMetadata等を含む） |
| totalNumberOfShards | int | NO | 全インデックスの総シャード数（トランジェント） |
| allIndices | String[] | NO | 全インデックス名の配列 |
| visibleIndices | String[] | NO | 可視インデックス名の配列 |
| allOpenIndices | String[] | NO | 全オープンインデックス名の配列 |
| allClosedIndices | String[] | NO | 全クローズインデックス名の配列 |
| indicesLookup | SortedMap\<String, IndexAbstraction\> | NO | インデックス名/エイリアス名のルックアップマップ |

### 2. IndexMetadata

個別のインデックスに関するメタデータ。シャード構成、レプリカ数、マッピング、エイリアス、設定などインデックスの全情報を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| index | Index | NO | インデックス識別子（名前とUUID） |
| numberOfShards | int | NO | プライマリシャード数 |
| numberOfReplicas | int | NO | レプリカシャード数 |
| numberOfSearchOnlyReplicas | int | NO | 検索専用レプリカ数 |
| routingNumShards | int | NO | ルーティング用シャード数 |
| routingFactor | int | NO | ルーティングファクタ（routingNumShards / numberOfShards） |
| routingPartitionSize | int | NO | ルーティングパーティションサイズ |
| version | long | NO | インデックスメタデータバージョン |
| mappingVersion | long | NO | マッピングバージョン |
| settingsVersion | long | NO | 設定バージョン |
| aliasesVersion | long | NO | エイリアスバージョン |
| primaryTerms | long[] | NO | 各シャードのプライマリターム配列 |
| state | State (OPEN/CLOSE) | NO | インデックス状態（OPEN: 0, CLOSE: 1） |
| aliases | Map\<String, AliasMetadata\> | NO | エイリアスメタデータのマップ |
| settings | Settings | NO | インデックス設定 |
| mappings | Map\<String, MappingMetadata\> | NO | マッピングメタデータのマップ |
| customData | Map\<String, DiffableStringMap\> | NO | カスタムデータマップ |
| inSyncAllocationIds | Map\<Integer, Set\<String\>\> | NO | シャードIDごとの同期済みアロケーションID |
| rolloverInfos | Map\<String, RolloverInfo\> | NO | ロールオーバー情報 |
| isSystem | boolean | NO | システムインデックスかどうか |
| isRemoteSnapshot | boolean | NO | リモートスナップショットインデックスかどうか |
| indexCreatedVersion | Version | NO | インデックスが作成されたOpenSearchバージョン |
| waitForActiveShards | ActiveShardCount | NO | アクティブシャード待機カウント |
| context | Context | YES | コンテキスト情報 |
| ingestionStatus | IngestionStatus | YES | インジェスションステータス |
| isAppendOnlyIndex | boolean | NO | 追記専用インデックスかどうか |

### 3. MappingMetadata

インデックスのフィールドマッピング（スキーマ定義）を保持する。ドキュメント内のフィールド名、データ型、アナライザ設定等を圧縮形式で格納する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| type | String | NO | マッピングタイプ名（通常 "_doc"） |
| source | CompressedXContent | NO | マッピング定義のJSON（圧縮形式） |
| routingRequired | boolean | NO | ルーティングが必須かどうか |

### 4. AliasMetadata

インデックスエイリアスの定義情報。エイリアスはインデックスの別名として機能し、フィルタやルーティング設定を持つことができる。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| alias | String | NO | エイリアス名 |
| filter | CompressedXContent | YES | エイリアスフィルタ（JSON圧縮形式） |
| indexRouting | String | YES | インデックス時のルーティング値 |
| searchRouting | String | YES | 検索時のルーティング値 |
| searchRoutingValues | Set\<String\> | NO | 検索ルーティング値のセット（searchRoutingから生成） |
| writeIndex | Boolean | YES | 書き込みインデックスとして指定されているか |
| isHidden | Boolean | YES | 隠しエイリアスかどうか |

### 5. IndexTemplateMetadata

レガシーインデックステンプレートの定義。インデックスパターンに一致する新規インデックスに自動適用されるマッピング・設定を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | テンプレート名 |
| order | int | NO | テンプレート適用優先順位 |
| version | Integer | YES | テンプレートバージョン（ユーザ管理用） |
| patterns | List\<String\> | NO | 適用対象のインデックスパターンリスト |
| settings | Settings | NO | テンプレートのインデックス設定 |
| mappings | Map\<String, CompressedXContent\> | NO | テンプレートのマッピング定義 |
| aliases | Map\<String, AliasMetadata\> | NO | テンプレートのエイリアス定義 |

### 6. ComposableIndexTemplate

コンポーザブルインデックステンプレートの定義。複数のコンポーネントテンプレートを組み合わせて構成される新しい形式のテンプレート。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| indexPatterns | List\<String\> | NO | 適用対象のインデックスパターンリスト |
| template | Template | YES | テンプレート本体（マッピング・設定・エイリアス） |
| composedOf | List\<String\> | YES | 構成するコンポーネントテンプレート名のリスト |
| priority | Long | YES | テンプレート優先度 |
| version | Long | YES | テンプレートバージョン |
| metadata | Map\<String, Object\> | YES | ユーザ定義メタデータ |
| dataStreamTemplate | DataStreamTemplate | YES | データストリームテンプレート設定 |
| context | Context | YES | コンテキスト情報 |

### 7. ComponentTemplate

コンポーネントテンプレートの定義。再利用可能なテンプレート部品として、コンポーザブルインデックステンプレートの構成要素となる。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| template | Template | NO | テンプレート本体（マッピング・設定・エイリアス） |
| version | Long | YES | テンプレートバージョン |
| metadata | Map\<String, Object\> | YES | ユーザ定義メタデータ |

### 8. DataStream

時系列データ向けデータストリームの定義。バッキングインデックスの自動ローテーションを管理し、タイムスタンプベースのデータ管理を提供する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | データストリーム名 |
| timeStampField | TimestampField | NO | タイムスタンプフィールド定義（デフォルト: @timestamp） |
| indices | List\<Index\> | NO | バッキングインデックスのリスト |
| generation | long | NO | 世代番号（ロールオーバーごとにインクリメント） |

### 9. RepositoryMetadata

スナップショットリポジトリの登録情報。バックアップ先のリポジトリタイプ、設定、暗号化情報を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | リポジトリ名 |
| type | String | NO | リポジトリタイプ（fs, s3, azure等） |
| settings | Settings | NO | リポジトリ設定 |
| cryptoMetadata | CryptoMetadata | YES | 暗号化メタデータ |
| generation | long | NO | 安全なリポジトリ世代番号 |
| pendingGeneration | long | NO | 保留中のリポジトリ世代番号 |

### 10. IndexGraveyard

削除済みインデックスのトゥームストーン（墓標）コレクション。クラスタステートに非同期で処理されるノードへの削除通知を保証するために使用される。最大500件（デフォルト）のトゥームストーンを保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| tombstones | List\<Tombstone\> | NO | 削除済みインデックスのトゥームストーンリスト |

Tombstoneの構造:

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| index | Index | NO | 削除されたインデックスの識別子 |
| deleteDateInMillis | long | NO | 削除日時（エポックミリ秒） |

### 11. CoordinationMetadata

クラスタ協調（選挙・投票設定）メタデータ。クラスタマスター選挙のターム管理、投票設定、除外ノード情報を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| term | long | NO | 現在の選挙ターム |
| lastCommittedConfiguration | VotingConfiguration | NO | 最後にコミットされた投票設定 |
| lastAcceptedConfiguration | VotingConfiguration | NO | 最後に受理された投票設定 |
| votingConfigExclusions | Set\<VotingConfigExclusion\> | NO | 投票設定から除外されたノードのセット |

### 12. DiscoveryNode

クラスタに参加しているノードの情報。ノードの識別情報、ネットワークアドレス、ロール、バージョン情報を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| nodeName | String | NO | ノード名 |
| nodeId | String | NO | ノードの一意識別子 |
| ephemeralId | String | NO | エフェメラルID（ノード再起動ごとに変更） |
| hostName | String | NO | ホスト名 |
| hostAddress | String | NO | ホストアドレス |
| address | TransportAddress | NO | トランスポートアドレス |
| attributes | Map\<String, String\> | NO | ノード属性マップ |
| version | Version | NO | ノードのOpenSearchバージョン |
| roles | SortedSet\<DiscoveryNodeRole\> | NO | ノードロールのセット（cluster_manager, data, ingest等） |

### 13. ShardRouting

シャードのルーティング・配置情報。各シャードがどのノードに配置されているか、その状態（初期化中、開始済み、再配置中、未割当）を追跡する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| shardId | ShardId | NO | シャード識別子（インデックス名 + シャード番号） |
| currentNodeId | String | YES | 現在配置されているノードID |
| relocatingNodeId | String | YES | 再配置先ノードID |
| primary | boolean | NO | プライマリシャードかどうか |
| searchOnly | boolean | NO | 検索専用シャードかどうか |
| state | ShardRoutingState | NO | シャード状態（UNASSIGNED, INITIALIZING, STARTED, RELOCATING） |
| recoverySource | RecoverySource | YES | リカバリソース情報 |
| unassignedInfo | UnassignedInfo | YES | 未割当情報（未割当の場合のみ） |
| allocationId | AllocationId | YES | アロケーションID |
| expectedShardSize | long | NO | 予想シャードサイズ（バイト） |

### 14. WorkloadGroup

ワークロードグループの定義。クエリのリソース使用量を制御するためのグループ設定を保持する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| _id | String | NO | ワークロードグループの一意識別子（UUID） |
| name | String | NO | ワークロードグループ名（最大50文字） |
| updatedAtInMillis | long | NO | 最終更新日時（エポックミリ秒） |
| mutableWorkloadGroupFragment | MutableWorkloadGroupFragment | NO | リソース制限・レジリエンシモード設定 |

MutableWorkloadGroupFragmentの構造:

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| resourceLimits | Map\<ResourceType, Double\> | NO | リソースタイプ別の制限値（memory, cpu等） |
| resiliencyMode | ResiliencyMode | NO | レジリエンシモード（enforced等） |

### 15. View

データビュー定義（実験的機能）。複数のインデックスパターンをまとめて論理的なビューとして定義する。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | NO | ビュー名 |
| description | String | YES | ビューの説明 |
| createdAt | long | NO | 作成日時（エポックミリ秒、未設定時は-1） |
| modifiedAt | long | NO | 更新日時（エポックミリ秒、未設定時は-1） |
| targets | SortedSet\<Target\> | NO | ビュー対象のターゲットセット |

## 備考

### OpenSearchのデータモデルについて

OpenSearchは従来のRDBMSを使用しないため、ここで「テーブル」として記述した各エンティティは、実際にはJavaオブジェクトとしてシリアライズされるデータ構造である。これらはクラスタステート（ClusterState）の一部として管理され、以下の方式で永続化・共有される。

1. **クラスタステートの永続化**: ゲートウェイ（gateway）モジュールを通じて、各ノードのローカルストレージにLuceneベースのメタデータストアとして保存される。
2. **ノード間の同期**: クラスタマネージャーノードが発行するクラスタステート更新を通じて、差分（Diff）形式で他ノードへ配信される。
3. **ドキュメントデータの格納**: 実際のユーザデータ（ドキュメント）はLuceneインデックスとしてシャード単位で各ノードに保存される。

### インデックス設定の主要パラメータ

- `index.number_of_shards`: プライマリシャード数（デフォルト: 1、最大: 1024）
- `index.number_of_replicas`: レプリカ数（デフォルト: 1）
- `index.number_of_search_replicas`: 検索専用レプリカ数（デフォルト: 0）
- `index.replication.type`: レプリケーションタイプ（DOCUMENT / SEGMENT）
- `index.remote_store.enabled`: リモートストア有効化フラグ
- `index.remote_store.segment.repository`: リモートセグメントストアリポジトリ名
- `index.remote_store.translog.repository`: リモートトランザクションログリポジトリ名

### バージョン管理

各メタデータエンティティはDiffableインターフェースを実装し、差分更新をサポートしている。IndexMetadataは個別にmappingVersion、settingsVersion、aliasesVersionを保持し、変更追跡を効率化している。
