---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全項目がソースコードに基づいて検出済み
  2. **網羅性の確認**：プラグインやモジュール固有のバッチ処理が存在する可能性あり
  3. **設定値の正確性**：デフォルト値はコード上の定義に基づくが、運用環境では異なる可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `server/src/main/java/org/opensearch/index/IndexService.java` - BaseAsyncTask, AsyncTranslogFSync, AsyncRefreshTask, AsyncReplicationTask, AsyncPublishReferencedSegmentsTask, AsyncTrimTranslogTask, AsyncGlobalCheckpointTask, AsyncRetentionLeaseSyncTask
- E-02: `server/src/main/java/org/opensearch/index/shard/IndexShard.java` - AsyncShardRefreshTask, AsyncShardFlushTask
- E-03: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` - AsyncForceMergeTask
- E-04: `server/src/main/java/org/opensearch/indices/IndicesService.java` - CacheCleaner (FieldDataCache)
- E-05: `server/src/main/java/org/opensearch/indices/IndicesRequestCache.java` - IndicesRequestCacheCleaner
- E-06: `server/src/main/java/org/opensearch/search/SearchService.java` - Reaper
- E-07: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` - FsHealthMonitor
- E-08: `server/src/main/java/org/opensearch/monitor/jvm/JvmGcMonitorService.java` - JvmGcMonitor
- E-09: `server/src/main/java/org/opensearch/node/ResourceUsageCollectorService.java` - scheduleWithFixedDelay
- E-10: `server/src/main/java/org/opensearch/node/resource/tracker/AbstractAverageUsageTracker.java` - scheduleWithFixedDelay
- E-11: `server/src/main/java/org/opensearch/node/resource/tracker/ResourceTrackerSettings.java` - ポーリング間隔設定
- E-12: `server/src/main/java/org/opensearch/cluster/InternalClusterInfoService.java` - RefreshAndRescheduleRunnable
- E-13: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` - AsyncStaleFileDeletion
- E-14: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` - PeriodicRechecker
- E-15: `server/src/main/java/org/opensearch/node/remotestore/RemoteStorePinnedTimestampService.java` - AsyncUpdatePinnedTimestampTask
- E-16: `server/src/main/java/org/opensearch/watcher/ResourceWatcherService.java` - HIGH/MEDIUM/LOW monitors
- E-17: `server/src/main/java/org/opensearch/indices/IndexingMemoryController.java` - scheduleWithFixedDelay
- E-18: `server/src/main/java/org/opensearch/action/bulk/BulkProcessor.java` - Flush (scheduleWithFixedDelay)
- E-19: `server/src/main/java/org/opensearch/index/SegmentReplicationPressureService.java` - AsyncFailStaleReplicaTask
- E-20: `server/src/main/java/org/opensearch/tasks/TaskCancellationMonitoringService.java` - scheduleWithFixedDelay
- E-21: `server/src/main/java/org/opensearch/wlm/WorkloadGroupService.java` - scheduleWithFixedDelay
- E-22: `server/src/main/java/org/opensearch/search/backpressure/SearchBackpressureService.java` - scheduleWithFixedDelay

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AsyncTranslogFSync: トランザクションログを定期的にfsyncする | E-01 | ○ |
| C-02 | AsyncRefreshTask: インデックスのリフレッシュを定期的に実行 | E-01 | ○ |
| C-03 | AsyncReplicationTask: セグメントレプリケーション対象のシャードを定期同期 | E-01 | ○ |
| C-04 | AsyncPublishReferencedSegmentsTask: プライマリシャードの参照セグメント情報を公開 | E-01 | ○ |
| C-05 | AsyncTrimTranslogTask: 不要なトランザクションログをトリム | E-01 | ○ |
| C-06 | AsyncGlobalCheckpointTask: グローバルチェックポイントをレプリカに同期 | E-01 | ○ |
| C-07 | AsyncRetentionLeaseSyncTask: リテンションリースを定期同期 | E-01 | ○ |
| C-08 | AsyncShardRefreshTask: シャード単位の独立リフレッシュ | E-02 | ○ |
| C-09 | AsyncShardFlushTask: シャード単位の定期flush | E-02 | ○ |
| C-10 | AutoForceMergeManager: 自動フォースマージ | E-03 | ○ |
| C-11 | CacheCleaner: フィールドデータキャッシュの定期クリーンアップ | E-04 | ○ |
| C-12 | IndicesRequestCacheCleaner: リクエストキャッシュの定期クリーンアップ | E-05 | ○ |
| C-13 | Reaper: 期限切れ検索コンテキストの解放 | E-06 | ○ |
| C-14 | FsHealthService: ファイルシステムヘルスチェック | E-07 | ○ |
| C-15 | JvmGcMonitorService: JVM GC監視 | E-08 | ○ |
| C-16 | ResourceUsageCollectorService: リソース使用状況収集 | E-09 | ○ |
| C-17 | AbstractAverageUsageTracker: 使用率移動平均計算 | E-10, E-11 | ○ |
| C-18 | InternalClusterInfoService: クラスタ情報定期収集 | E-12 | ○ |
| C-19 | RemoteClusterStateCleanupManager: 古いクラスタ状態ファイル削除 | E-13 | ○ |
| C-20 | PeriodicRechecker: 永続タスク再チェック | E-14 | ○ |
| C-21 | RemoteStorePinnedTimestampService: ピン留めタイムスタンプ更新 | E-15 | ○ |
| C-22 | ResourceWatcherService: リソースウォッチャー3段階チェック | E-16 | ○ |
| C-23 | IndexingMemoryController: メモリ使用状況チェック | E-17 | ○ |
| C-24 | BulkProcessor Flush: バルクリクエスト定期フラッシュ | E-18 | ○ |
| C-25 | AsyncFailStaleReplicaTask: 遅延レプリカシャードの検出と失敗処理 | E-19 | ○ |
| C-26 | TaskCancellationMonitoringService: キャンセル済みタスク監視 | E-20 | ○ |
| C-27 | WorkloadGroupService: ワークロードグループ監視 | E-21 | ○ |
| C-28 | SearchBackpressureService: 検索バックプレッシャー評価 | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- プラグイン固有のバッチ処理は網羅していない可能性がある
  - 候補：plugins/ 配下の各プラグイン / sandbox/ 配下のExperimental機能 / サードパーティプラグイン
- modules/reindex のリインデックス処理は一回性のタスクであるため、定期バッチとしてはリストに含めていない
  - 候補：AbstractAsyncBulkByScrollAction / ReindexRequest

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全28件のバッチ処理がソースコードから直接確認されており、クラス名・設定値ともにコードに基づく
- 1: 中リスク - プラグイン・モジュール固有のスケジュールタスクが未カバーの可能性がある。特にplugins/配下のカスタムプラグインは調査対象外
- 0: 低リスク - デフォルト設定値はソースコードのSetting定義から抽出しており、正確性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 全28件のバッチ名がソースコード上のクラス名と一致しているか
- [ ] デフォルト間隔の値がソースコードのSetting定義と一致しているか
- [ ] カテゴリ分類が適切か（インデックス管理・キャッシュ管理・モニタリング等）
- [ ] plugins/配下に追加のスケジュールタスクが存在しないか確認
- [ ] sandbox/配下のExperimental機能にスケジュールタスクが存在しないか確認
- [ ] 一回性のタスク（リインデックス等）が誤ってバッチとしてリストされていないか
