# バッチ設計書 26-TaskCancellationMonitoringService

## 概要

本ドキュメントは、OpenSearchのTaskCancellationMonitoringServiceが提供するキャンセル済みタスクの監視バッチ処理の設計を記述する。このバッチは、キャンセルされた後も長時間実行し続けているタスクを定期的に検出し、ノード統計の一部としてトラッキングする。

### 本バッチの処理概要

TaskCancellationMonitoringServiceは、AbstractLifecycleComponentとして実装されたサービスであり、キャンセルされたSearchTaskおよびSearchShardTaskの実行状況を定期的に監視する。設定された閾値（デフォルト10秒）を超えてキャンセル後も実行が継続しているタスクを検出し、累積カウンタとしてノード統計に反映する。

**業務上の目的・背景**：検索タスクがキャンセルされた後も実際の処理が停止せず長時間実行し続ける状況は、リソースリークやクラスタ負荷の原因となる。本サービスはこの状況をモニタリングし、統計情報として可視化することで、運用者がクラスタの健全性を評価できるようにする。これにより、タスクキャンセル機構の効果測定やリソースリークの早期発見が可能となる。

**バッチの実行タイミング**：task_cancellation.interval_millis設定（デフォルト5000ms）の間隔で定期実行される。

**主要な処理内容**：
1. 監視が有効で、かつキャンセル済みタスクのトラッカーが空でないことを確認する
2. TaskManagerからキャンセル済みの実行中タスクを取得する
3. キャンセルからの経過時間が閾値（task_cancellation.duration_millis）を超えたタスクをフィルタリングする
4. まだカウントされていないタスクについて、タスク種別ごとの累積カウンタをインクリメントする

**前後の処理との関連**：TaskManagerのタスクキャンセル機構がonTaskCancelled()コールバックを呼び出し、タスク完了時にonTaskCompleted()が呼び出される。統計情報はノード統計APIを通じて公開される。

**影響範囲**：ノード上のSearchTaskおよびSearchShardTaskのキャンセル統計に影響する。

## バッチ種別

モニタリング・統計収集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | task_cancellation.interval_millis（デフォルト5000ms） |
| 実行時刻 | サービス起動後から継続的に実行 |
| 実行曜日 | 該当なし（常時） |
| 実行日 | 該当なし（常時） |
| トリガー | ThreadPool.scheduleWithFixedDelayによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| task_cancellation.enabled | trueであること（デフォルトtrue） |
| キャンセル済みタスクが存在 | cancelledTaskTrackerが空でないこと |

### 実行可否判定

doRun()メソッド内で、task_cancellation.enabledがfalseの場合、またはcancelledTaskTrackerが空の場合は即座にreturnする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| task_cancellation.interval_millis | long | No | 5000 | 監視間隔（ミリ秒） |
| task_cancellation.duration_millis | long | No | 10000 | 長時間実行閾値（ミリ秒） |
| task_cancellation.enabled | boolean | No | true | 監視の有効/無効 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TaskManager.getCancellableTasks() | Map<Long, CancellableTask> | キャンセル可能なタスクの一覧 |
| cancelledTaskTracker | ConcurrentHashMap<Long, Boolean> | キャンセル済みタスクのトラッキングマップ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| TaskCancellationStats | Java Object | タスク種別ごとのキャンセル統計 |
| SearchTaskCancellationStats | Java Object | SearchTaskのキャンセル統計 |
| SearchShardTaskCancellationStats | Java Object | SearchShardTaskのキャンセル統計 |

### 出力ファイル仕様

ファイル出力はなし。ノード統計APIを通じて公開される。

## 処理フロー

### 処理シーケンス

```
1. 有効性チェック
   └─ isEnabled() && cancelledTaskTracker.isEmpty()でない
2. TaskManagerからキャンセル済み実行中タスクを取得
   └─ getCancellableTasks()から対象クラス（SearchTask/SearchShardTask）をフィルタ
3. キャンセル状態のタスクをフィルタ
   └─ isCancelled() == trueのみ
4. 時間閾値によるフィルタ
   └─ キャンセルからの経過時間 >= duration_millis
5. タスク種別ごとにグルーピング
6. 未カウントタスクの検出
   └─ cancelledTaskTrackerのvalueがfalse（未カウント）のタスクを特定
7. 未カウントタスクをtrue（カウント済み）に更新
8. 累積カウンタをインクリメント
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{有効 かつ トラッカー非空?}
    B -->|No| C[スキップ]
    B -->|Yes| D[キャンセル済み実行中タスク取得]
    D --> E[時間閾値フィルタリング]
    E --> F[タスク種別ごとにグルーピング]
    F --> G{未カウントタスクあり?}
    G -->|No| H[バッチ終了]
    G -->|Yes| I[カウント済みに更新]
    I --> J[累積カウンタインクリメント]
    J --> H
    C --> H
```

## データベース操作仕様

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | doRun()内の例外 | DEBUGログ出力してスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回スケジュールで再実行） |
| リトライ間隔 | task_cancellation.interval_millis（デフォルト5000ms） |
| リトライ対象エラー | 全てのエラー（次回実行で自動リトライ） |

### 障害時対応

例外発生時はDEBUGレベルでログ出力され、次回のスケジュールで再試行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | キャンセル済み実行中タスク数に依存（通常少数） |
| 目標処理時間 | 監視間隔（5秒）内に完了すること |
| メモリ使用量上限 | 軽量（タスクIDのトラッキングマップ程度） |

## 排他制御

cancelledTaskTrackerはConcurrentHashMapで実装されているため、スレッドセーフである。onTaskCancelled()/onTaskCompleted()コールバックとdoRun()が並行実行されても安全に動作する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DEBUGログ | 監視中の例外発生時 | "Exception occurred in Task monitoring service" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 長時間実行キャンセルタスク数 | ノード統計APIで確認 | 運用チーム |

## 備考

- 監視対象はSearchTaskとSearchShardTaskの2種類のみ（TASKS_TO_TRACK定数）
- cancelledTaskTrackerはBooleanフラグで二重カウントを防止する
- タスク完了時にcancelledTaskTrackerからエントリが削除される
- task_cancellation.duration_millisとtask_cancellation.enabledは動的変更可能（Dynamic設定）
