# バッチ設計書 5-AsyncTrimTranslogTask

## 概要

本ドキュメントは、OpenSearchのインデックスサービスにおける不要なトランザクションログのトリム（削除）を定期的に実行するバッチタスクの設計を記載する。

### 本バッチの処理概要

AsyncTrimTranslogTaskは、インデックスに属する各シャードのトランザクションログから不要な（コミット済みの古い）エントリを定期的にトリムするバッチタスクである。

**業務上の目的・背景**：トランザクションログはノード障害時のデータ復旧に使用されるが、フラッシュ（Luceneコミット）が完了した後の古いトランスログエントリは不要となる。これらを定期的にトリムすることで、ディスク容量を回収し、復旧時間を短縮する。本バッチはこのクリーンアップ処理を自動化する。

**バッチの実行タイミング**：`index.translog.retention.check_interval`（デフォルト10分）の間隔で定期実行される。IndexServiceの初期化時に即座にスケジューリングが開始される。

**主要な処理内容**：
1. インデックス内の全シャードを走査する
2. 各シャードの状態を確認する（CREATED/RECOVERING/CLOSEDはスキップ）
3. POST_RECOVERYまたはSTARTED状態のシャードに対して`trimTranslog()`を実行する
4. 不要なトランスログエントリが削除される

**前後の処理との関連**：AsyncTranslogFSync（No.1）によるfsyncの後にトランスログデータがディスクに永続化される。フラッシュ処理（Luceneコミット）の後に、コミット済みのトランスログが本タスクによりトリムされる。

**影響範囲**：対象インデックスの全シャードのトランザクションログファイルに影響する。ディスク使用量の削減に寄与する。

## バッチ種別

データクレンジング処理（不要トランザクションログの削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 定期実行（デフォルト10分間隔） |
| 実行時刻 | インデックスのライフサイクルに依存（常時） |
| 実行曜日 | 該当なし（常時稼働） |
| 実行日 | 該当なし（常時稼働） |
| トリガー | タイマーベースの定期スケジュール（AbstractAsyncTask） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| IndexServiceが未クローズ | `indexService.closed.get() == false`であること |
| シャードがPOST_RECOVERYまたはSTARTED | CREATED/RECOVERING/CLOSED状態のシャードはスキップ |

### 実行可否判定

`mustReschedule()`がオーバーライドされており、`indexService.closed.get() == false`のみをチェックする（インデックスのOPEN/CLOSE状態はチェックしない。クローズされたインデックスでもトランスログのトリムは必要なため）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| index.translog.retention.check_interval | TimeValue | No | 10m | トリムチェックの実行間隔 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| IndexServiceのシャードマップ | インメモリ | 対象インデックスに属する全シャード |
| 各シャードのTranslog | ディスクファイル | トランザクションログデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| トランザクションログファイル | ディスクファイル | 不要なトランスログファイルが削除される |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 古いtranslog-N.tlogファイルが削除される |
| 出力先 | 各シャードのtranslogディレクトリ |
| 文字コード | 該当なし（ファイル削除操作） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. タイマーによる定期起動
   └─ AbstractAsyncTaskにより指定間隔で起動
2. シャード走査
   └─ 全シャードをイテレーション
3. シャード状態チェック
   └─ CREATED/RECOVERING/CLOSEDの場合はスキップ
4. トランスログトリム実行
   └─ POST_RECOVERY/STARTEDの場合、shard.trimTranslog()を実行
5. 次回スケジュール
   └─ mustReschedule()がtrueの場合、再スケジュール
```

### フローチャート

```mermaid
flowchart TD
    A[タイマー起動] --> B[全シャード走査開始]
    B --> C{次のシャードあり?}
    C -->|No| H[処理終了・再スケジュール]
    C -->|Yes| D{シャード状態?}
    D -->|CREATED/RECOVERING/CLOSED| C
    D -->|POST_RECOVERY/STARTED| E[shard.trimTranslog 実行]
    E --> C
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| translogトリム | トランザクションログファイル | DELETE | 不要なトランスログファイルの削除 |

### テーブル別操作詳細

#### トランザクションログファイル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | 古いトランスログファイル | コミット済みのgeneration以前のファイル | ディスク容量の回収 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | IndexShardClosedException | シャードが既にクローズされている | 例外をキャッチして処理を継続 |
| - | AlreadyClosedException | リソースが既にクローズされている | 例外をキャッチして処理を継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 明示的なリトライなし（次回スケジュール実行で再試行） |
| リトライ間隔 | index.translog.retention.check_interval（デフォルト10分） |
| リトライ対象エラー | 次回実行時に自動的に再試行 |

### 障害時対応

トリム処理に失敗した場合、例外がキャッチされ次のシャードの処理に進む。トリムの失敗はデータの整合性には影響しない（古いトランスログが残るだけ）。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | シャード単位（各シャードのトリムは独立） |
| コミットタイミング | トリム実行時（即時） |
| ロールバック条件 | 該当なし（ファイル削除操作） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | インデックス内のシャード数に依存 |
| 目標処理時間 | check_interval内に完了すること |
| メモリ使用量上限 | 追加メモリ使用なし |

## 排他制御

同一インデックスに対するAsyncTrimTranslogTaskは1つのみ存在する。各シャードのtrimTranslog()は内部で適切な排他制御を行う。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | トリム失敗時 | シャードクローズ例外はサイレントにスキップ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ディスク使用量 | トランスログによるディスク使用量増大 | OpenSearchログ |

## 備考

- 本タスクはGENERICスレッドプールで実行される
- `index.translog.retention.check_interval`は正式に登録されたSettingではなく、テスト用途でも使用される
- BaseAsyncTaskのmustReschedule()がオーバーライドされ、インデックスのOPEN状態チェックが省略されている点が他のタスクと異なる
- IndexServiceの初期化時に即座に作成され、インデックスのライフサイクル全体を通じて動作する
- ソースコード: `server/src/main/java/org/opensearch/index/IndexService.java` (AsyncTrimTranslogTask内部クラス)
