---
generated_at: 2026-02-03 10:09:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-AutoForceMergeManager

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (全体)
- E-02: `server/src/main/java/org/opensearch/index/autoforcemerge/ForceMergeManagerSettings.java` (全体)
- E-03: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (AsyncForceMergeTask, L513-L553)
- E-04: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (ConfigurationValidator, L285-L339)
- E-05: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (NodeValidator, L346-L428)
- E-06: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (ShardValidator, L435-L475)
- E-07: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (executeForceMergeForShard, L183-L230)
- E-08: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java` (getShardsBasedOnSorting, L243-L256)
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (No.10の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトスケジューラ間隔は30分 | E-02 (AUTO_FORCE_MERGE_SCHEDULER_INTERVAL, 30m) | ○ |
| C-02 | GENERICスレッドプールでスケジューラ実行 | E-03 (ThreadPool.Names.GENERIC) | ○ |
| C-03 | FORCE_MERGEスレッドプールで実際のマージ実行 | E-07 (threadPool.executor(ThreadPool.Names.FORCE_MERGE)) | ○ |
| C-04 | cluster.auto_force_merge.enabledデフォルトfalse | E-02 (AUTO_FORCE_MERGE_SETTING, false) | ○ |
| C-05 | セグメント数デフォルト1 | E-02 (SEGMENT_COUNT_FOR_AUTO_FORCE_MERGE, 1) | ○ |
| C-06 | シャード間遅延デフォルト15秒 | E-02 (MERGE_DELAY_BETWEEN_SHARDS, 15s) | ○ |
| C-07 | トランスログ経過時間デフォルト30分 | E-02 (TRANSLOG_AGE, 30m) | ○ |
| C-08 | CPU閾値デフォルト75% | E-02 (CPU_THRESHOLD, 75.0) | ○ |
| C-09 | ディスク閾値デフォルト85% | E-02 (DISK_THRESHOLD, 85.0) | ○ |
| C-10 | JVM閾値デフォルト75% | E-02 (JVM_THRESHOLD, 75.0) | ○ |
| C-11 | 並行性乗数デフォルト2 | E-02 (CONCURRENCY_MULTIPLIER, 2) | ○ |
| C-12 | リモートストア有効が前提 | E-04 (isRemoteStorageEnabled) | ○ |
| C-13 | データノードかつ非ウォームノード | E-04 (isOnlyDataNode, L293) | ○ |
| C-14 | ウォームノード存在確認 | E-04 (hasWarmNodes, L334-L338) | ○ |
| C-15 | CPU 1分/5分平均とリアルタイム値チェック | E-05 (isCpuUsageOverThreshold) | ○ |
| C-16 | JVM 1分/5分平均とリアルタイム値チェック | E-05 (isJvmUsageOverThreshold) | ○ |
| C-17 | ディスク使用率チェック | E-05 (isDiskUsageOverThreshold) | ○ |
| C-18 | FORCE_MERGEスレッドキュー空き確認 | E-05 (areForceMergeThreadsAvailable) | ○ |
| C-19 | システムインデックス除外 | E-08 (filter: !startsWith(".")) | ○ |
| C-20 | プライマリシャードのみ | E-08 (filter: primary()) | ○ |
| C-21 | トランスログ経過時間でソート | E-08 (ShardAgeComparator) | ○ |
| C-22 | mergingShards Setで同時マージ防止 | E-07 (mergingShards.add/remove), E-08 (filter) | ○ |
| C-23 | maxConcurrentForceMerges計算式 | E-05 (max(1, allocatedProcessors/8) * concurrencyMultiplier) | ○ |
| C-24 | CompletableFuture.runAsyncで非同期実行 | E-07 (L184) | ○ |
| C-25 | AbstractLifecycleComponent継承 | E-01 (extends AbstractLifecycleComponent) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコードからの直接根拠あり。AutoForceMergeManagerとForceMergeManagerSettingsの両ファイルを完全に参照。

## 6) レビュアーチェックリスト（最小）
- [ ] 全設定パラメータのデフォルト値がForceMergeManagerSettings.javaと一致しているか
- [ ] 3段階バリデーション（Configuration/Node/Shard）の条件が正確か
- [ ] maxConcurrentForceMergesの計算式が正確か
- [ ] mergingShardsによる排他制御の記述が正確か
