---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：11-CacheCleaner (FieldDataCache)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ヒープメモリ圧迫に関する影響範囲の記述**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/indices/IndicesService.java` CacheCleanerクラス（1902-1944行）
- E-02: `server/src/main/java/org/opensearch/indices/IndicesService.java` INDICES_CACHE_CLEAN_INTERVAL_SETTING定義（240行）
- E-03: `server/src/main/java/org/opensearch/indices/IndicesService.java` CacheCleaner初期化（513行）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.11のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CacheCleanerはIndicesServiceで管理されるフィールドデータキャッシュを定期クリーンアップする | E-01, E-03 | ○ |
| C-02 | Guavaベースのキャッシュ実装で無効化エントリが自動クリーンアップされない | E-01（Javadoc） | ○ |
| C-03 | デフォルト実行間隔は1分 | E-02 | ○ |
| C-04 | 設定キーはindices.cache.cleanup_interval | E-02 | ○ |
| C-05 | cache.clear()メソッドでクリーンアップを実行 | E-01（1924行） | ○ |
| C-06 | 例外発生時は警告ログを出力 | E-01（1926行） | ○ |
| C-07 | closedフラグがfalseの場合に再スケジュール | E-01（1935-1937行） | ○ |
| C-08 | ThreadPool.Names.SAMEでスケジュール | E-01（1936行） | ○ |
| C-09 | AtomicBooleanでスレッドセーフにクローズ判定 | E-01（1908行、1942行） | ○ |
| C-10 | close()でclosedフラグをtrueに設定 | E-01（1942行） | ○ |
| C-11 | private staticクラスとして実装 | E-01（1902行） | ○ |
| C-12 | トレースログで処理時間をミリ秒で記録 | E-01（1928-1933行） | ○ |
| C-13 | scheduleUnlessShuttingDownで再スケジュール | E-01（1936行） | ○ |
| C-14 | IndicesRequestCacheと同一デフォルト値を共有 | E-02, IndicesRequestCache.java | ○ |
| C-15 | フィールドデータの蓄積はヒープメモリ圧迫につながる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15の「ヒープメモリ圧迫」に関する記述は一般的なOpenSearch運用知識に基づくものであり、ソースコード上で直接確認できる根拠はない
  - 候補：OpenSearch公式ドキュメント / フィールドデータキャッシュのサイズ制限設定 / サーキットブレーカー設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容が大半

## 6) レビュアーチェックリスト（最小）
- [ ] CacheCleanerの実行間隔デフォルト値（1分）が正しいか確認
- [ ] IndicesFieldDataCache.clear()の実際の挙動を確認（無効化済みエントリのみクリアされるか）
- [ ] ThreadPool.Names.SAMEの実行スレッドの挙動が正確に記述されているか確認
