---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-IndicesRequestCacheCleaner

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコードの根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/indices/IndicesRequestCache.java` IndicesRequestCacheCleanupManagerクラス（545-907行）
- E-02: `server/src/main/java/org/opensearch/indices/IndicesRequestCache.java` IndicesRequestCacheCleanerクラス（875-906行）
- E-03: `server/src/main/java/org/opensearch/indices/IndicesRequestCache.java` 設定定義（117-172行）
- E-04: `server/src/main/java/org/opensearch/indices/IndicesRequestCache.java` cleanCache()メソッド（752-822行）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.12のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IndicesRequestCacheCleanupManagerがクリーンアップタスクを管理 | E-01 | ○ |
| C-02 | デフォルト実行間隔はINDICES_CACHE_CLEAN_INTERVAL_SETTINGと同値 | E-03（145-149行） | ○ |
| C-03 | 陳腐化率チェックでスキップ可能 | E-04（756行、833-850行） | ○ |
| C-04 | stalenessThresholdデフォルトは0% | E-03（150-156行） | ○ |
| C-05 | keysToCleanからCleanupKeyを3種に分類 | E-04（766-780行） | ○ |
| C-06 | cleanCacheはsynchronizedで排他制御 | E-04（752行） | ○ |
| C-07 | cache.refresh()で変更を反映 | E-04（821行） | ○ |
| C-08 | closedフラグがfalseの場合に再スケジュール | E-02（897-899行） | ○ |
| C-09 | ThreadPool.Names.SAMEでスケジュール | E-01（558行） | ○ |
| C-10 | 例外発生時は警告ログを出力 | E-02（894行） | ○ |
| C-11 | CleanupKeyはIndexReader.ClosedListenerを実装 | E-01（498行） | ○ |
| C-12 | staleKeysCountで陳腐化キー数を追跡 | E-01（548-549行） | ○ |
| C-13 | キャッシュサイズデフォルトはヒープの1% | E-03（134-139行） | ○ |
| C-14 | indices.requests.cache.cleanup.staleness_thresholdは動的設定 | E-03（150-156行、Property.Dynamic） | ○ |
| C-15 | クローズ済みシャードのスタッツ情報をドロップ | E-04（809-820行） | ○ |
| C-16 | private finalクラスとして実装 | E-02（875行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容のみ

## 6) レビュアーチェックリスト（最小）
- [ ] cleanCache()のsynchronizedブロックのスコープが正確に記述されているか確認
- [ ] 陳腐化率計算ロジック（staleKeysCount / totalKeysInCache）が正確か確認
- [ ] INDICES_REQUEST_CACHE_CLEANUP_INTERVAL_SETTINGのデフォルト値がINDICES_CACHE_CLEAN_INTERVAL_SETTINGと連動している点を確認
