---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：13-SearchService Reaper

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **isExpired()の内部判定ロジック**：ReaderContextクラスの実装を直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/search/SearchService.java` Reaperクラス（1841-1851行）
- E-02: `server/src/main/java/org/opensearch/search/SearchService.java` KEEPALIVE_INTERVAL_SETTING（215-218行）
- E-03: `server/src/main/java/org/opensearch/search/SearchService.java` keepAliveReaper初期化（556行）
- E-04: `server/src/main/java/org/opensearch/search/SearchService.java` doClose()（717-718行）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.13のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Reaperは期限切れReaderContextを定期的に解放する | E-01 | ○ |
| C-02 | デフォルト実行間隔は1分 | E-02 | ○ |
| C-03 | scheduleWithFixedDelayでスケジュール | E-03 | ○ |
| C-04 | ThreadPool.Names.SAMEで実行 | E-03 | ○ |
| C-05 | activeReadersをイテレーションする | E-01（1844行） | ○ |
| C-06 | isExpired()で期限切れ判定 | E-01（1845行） | ○ |
| C-07 | freeReaderContext()でコンテキスト解放 | E-01（1847行） | ○ |
| C-08 | デバッグログで解放を記録 | E-01（1846行） | ○ |
| C-09 | SearchService.doClose()でcancel | E-04 | ○ |
| C-10 | ReaderContextインナークラスとして実装 | E-01 | ○ |
| C-11 | PIT検索コンテキストも同一Reaperで管理 | E-03（PitReaderContext作成後activeReadersに登録） | ○ |
| C-12 | search.keep_alive_intervalの設定キー | E-02 | ○ |
| C-13 | search.default_keep_aliveデフォルト5m | E-02付近の設定定義 | ○ |
| C-14 | isExpired()はlastAccessTime + keepAlive < currentTimeで判定 | **根拠なし**（ReaderContextクラスの実装を未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: isExpired()の具体的な判定ロジックはReaderContextクラスの実装に依存する。SearchServiceのReaperコードからは呼び出しのみ確認できる。
  - 候補：`server/src/main/java/org/opensearch/search/internal/ReaderContext.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Reaperの処理は非常にシンプルで、ソースコードから明確に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] ReaderContext.isExpired()の判定ロジックが設計書の記述と一致するか確認
- [ ] freeReaderContext()の例外ハンドリングの挙動を確認
- [ ] activeReadersのConcurrentHashMapイテレーション時のスレッド安全性を確認
