---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-FsHealthService (FsHealthMonitor)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコードの根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` FsHealthMonitorクラス（195-288行）
- E-02: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` 設定定義（96-121行）
- E-03: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` doStart()（149-151行）
- E-04: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` getHealth()（174-193行）
- E-05: `server/src/main/java/org/opensearch/monitor/fs/FsHealthService.java` コンストラクタ（123-146行）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.14のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト実行間隔は60秒 | E-02（102-107行） | ○ |
| C-02 | monitor.fs.health.enabledでヘルスチェック有効/無効制御 | E-02（96-101行）、E-01（208行） | ○ |
| C-03 | テンポラリファイル名は.opensearch_temp_file | E-01（197行） | ○ |
| C-04 | ランダムBase64UUID文字列を書き込み | E-01（201行） | ○ |
| C-05 | slowPathLoggingThresholdデフォルトは5秒 | E-02（108-114行） | ○ |
| C-06 | healthyTimeoutThresholdデフォルトは60秒 | E-02（115-121行） | ○ |
| C-07 | ThreadPool.Names.GENERICでスケジュール | E-03（150行） | ○ |
| C-08 | checkInProgressにAtomicBooleanを使用 | E-01（89行、210行） | ○ |
| C-09 | fsHealth.failure.countメトリクスカウンタ | E-05（138-142行）、E-01（226-231行） | ○ |
| C-10 | nodeDataPaths()でデータパス取得 | E-01（237行） | ○ |
| C-11 | IllegalStateException時にbrokenLock=true | E-01（239-240行） | ○ |
| C-12 | fsync後にテンポラリファイルを削除 | E-01（252-254行） | ○ |
| C-13 | スローパス超過時に警告ログ | E-01（257-263行） | ○ |
| C-14 | タイムアウト超過時にunhealthyに追加 | E-01（264-275行） | ○ |
| C-15 | NodeHealthServiceインターフェースを実装 | E-01（75行） | ○ |
| C-16 | AbstractLifecycleComponentを継承 | E-01（75行） | ○ |
| C-17 | getHealth()でcheckInProgress+タイムアウトを組み合わせ判定 | E-04（181-183行） | ○ |
| C-18 | enabled/slowPath/healthyTimeoutは動的変更可能 | E-05（143-145行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容のみ

## 6) レビュアーチェックリスト（最小）
- [ ] テンポラリファイル書き込みテストがI/O負荷として問題ないか確認
- [ ] getHealth()のタイムアウト判定ロジックが設計書の記述と一致するか確認
- [ ] doStop()でscheduledFuture.cancel()が正しく呼ばれるか確認
