---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-JvmGcMonitorService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコードの根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/monitor/jvm/JvmGcMonitorService.java` 全体（1-564行）
- E-02: `server/src/main/java/org/opensearch/monitor/jvm/JvmGcMonitorService.java` 設定定義（73-104行）
- E-03: `server/src/main/java/org/opensearch/monitor/jvm/JvmGcMonitorService.java` JvmMonitor抽象クラス（403-562行）
- E-04: `server/src/main/java/org/opensearch/monitor/jvm/JvmGcMonitorService.java` doStart()（237-257行）
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.15のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト実行間隔は1秒 | E-02（74-79行） | ○ |
| C-02 | monitor.jvm.gc.enabledでGC監視有効/無効 | E-02（73行）、E-04（238行） | ○ |
| C-03 | Young GCデフォルト閾値: warn=1000ms, info=700ms, debug=400ms | E-01（162行） | ○ |
| C-04 | Old GCデフォルト閾値: warn=10000ms, info=5000ms, debug=2000ms | E-01（163行） | ○ |
| C-05 | GCオーバーヘッドデフォルト: warn=50%, info=25%, debug=10% | E-02（84-104行） | ○ |
| C-06 | warn > info > debugの順序が必須 | E-01（167-188行） | ○ |
| C-07 | monitorGc()はsynchronized | E-03（463行） | ○ |
| C-08 | Names.SAMEでscheduleWithFixedDelay | E-04（256行） | ○ |
| C-09 | 平均GC時間 = コレクション時間差分 / コレクション回数差分 | E-03（497行） | ○ |
| C-10 | GCオーバーヘッド = (GC時間 * 100) / 経過時間 | E-03（536行） | ○ |
| C-11 | onMonitorFailure()でデバッグログ出力 | E-04（244行） | ○ |
| C-12 | defaultの閾値はwarn=10000ms, info=5000ms, debug=2000ms | E-01（164行） | ○ |
| C-13 | AbstractLifecycleComponentを継承 | E-01（62行） | ○ |
| C-14 | doStop()でscheduledFuture.cancel() | E-01（393-398行） | ○ |
| C-15 | JvmStats.jvmStats()でGC統計取得 | E-03（550-552行） | ○ |
| C-16 | System.nanoTime()で時間計測 | E-03（554-556行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容のみ

## 6) レビュアーチェックリスト（最小）
- [ ] GCオーバーヘッド計算の精度（整数除算）が設計書の記述と一致するか確認
- [ ] 複数GCコレクタ環境でのスローGC検出ロジックが正確か確認
- [ ] JvmMonitor抽象クラスのコールバック実装が設計書のログ出力内容と一致するか確認
