---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-AbstractAverageUsageTracker (CPU/JVM/IO)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **AverageMemoryUsageTrackerの具体実装**：ソースファイルを未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/node/resource/tracker/AbstractAverageUsageTracker.java` 全体（1-100行）
- E-02: `server/src/main/java/org/opensearch/node/resource/tracker/AverageCpuUsageTracker.java` 全体（1-38行）
- E-03: `server/src/main/java/org/opensearch/node/resource/tracker/AverageIoUsageTracker.java` 全体（1-102行）
- E-04: `server/src/main/java/org/opensearch/node/resource/tracker/ResourceTrackerSettings.java` 全体（1-126行）
- E-05: `server/src/main/java/org/opensearch/node/resource/tracker/NodeResourceUsageTracker.java` 全体（1-154行）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.17のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPUポーリング間隔デフォルト500ms | E-04（39-43行） | ○ |
| C-02 | JVMメモリポーリング間隔デフォルト500ms | E-04（63-67行） | ○ |
| C-03 | IOポーリング間隔デフォルト5000ms | E-04（51-55行） | ○ |
| C-04 | CPUウィンドウデフォルト30秒 | E-04（44-49行） | ○ |
| C-05 | IOウィンドウデフォルト120秒 | E-04（56-61行） | ○ |
| C-06 | ThreadPool.Names.GENERICでスケジュール | E-01（88行） | ○ |
| C-07 | MovingAverageをAtomicReferenceで管理 | E-01（30行） | ○ |
| C-08 | ウィンドウサイズ = windowDuration / pollingInterval | E-01（62行） | ○ |
| C-09 | AverageIoUsageTrackerはLinuxのみ | E-03（74行） | ○ |
| C-10 | IOは全デバイスの最大値を採用 | E-03（64行） | ○ |
| C-11 | CPUはProcessProbe.getProcessCpuPercent()で取得 | E-02（33行） | ○ |
| C-12 | AbstractLifecycleComponentを継承 | E-01（24行） | ○ |
| C-13 | window_durationはDynamic設定 | E-04（47-48行） | ○ |
| C-14 | polling_intervalはNodeScope固定 | E-04（42行） | ○ |
| C-15 | scheduleWithFixedDelayでスケジュール | E-01（85行） | ○ |
| C-16 | NodeResourceUsageTrackerが3つのトラッカーを管理 | E-05（26-28行、135-138行） | ○ |
| C-17 | IOトラッカーのpreValidateFsStats() | E-03（84-93行） | ○ |
| C-18 | AverageMemoryUsageTrackerの具体実装 | **根拠なし**（ソースファイル未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: AverageMemoryUsageTrackerのソースファイルを直接確認していない。NodeResourceUsageTrackerのコードから存在は確認できるが、具体的な実装内容は未検証。
  - 候補：`server/src/main/java/org/opensearch/node/resource/tracker/AverageMemoryUsageTracker.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基底クラスと主要サブクラスのコードから明確に読み取れる内容が大半

## 6) レビュアーチェックリスト（最小）
- [ ] AverageMemoryUsageTrackerの実装を確認し、設計書の記述が正確か検証
- [ ] MovingAverageクラスの実装を確認し、ウィンドウサイズの挙動が正確か検証
- [ ] AtomicReferenceによるsetWindowSize()の原子性が実際のコードと一致するか確認
