---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-InternalClusterInfoService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコードの根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/InternalClusterInfoService.java` 全体（1-604行）
- E-02: `server/src/main/java/org/opensearch/cluster/InternalClusterInfoService.java` 設定定義（99-111行）
- E-03: `server/src/main/java/org/opensearch/cluster/InternalClusterInfoService.java` clusterChanged()（161-207行）
- E-04: `server/src/main/java/org/opensearch/cluster/InternalClusterInfoService.java` refresh()（269-377行）
- E-05: `server/src/main/java/org/opensearch/cluster/InternalClusterInfoService.java` RefreshAndRescheduleRunnable（582-603行）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.18のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト更新間隔は30秒 | E-02（99-105行） | ○ |
| C-02 | 最小更新間隔は10秒 | E-02（102行） | ○ |
| C-03 | デフォルトタイムアウトは15秒 | E-02（106-111行） | ○ |
| C-04 | クラスタマネージャノードでのみ動作 | E-03（162行） | ○ |
| C-05 | MANAGEMENTスレッドプールで実行 | E-01（97行、168行） | ○ |
| C-06 | データノード追加時に即座にリフレッシュ | E-03（179-184行） | ○ |
| C-07 | NodesStatsでFS/FILE_CACHE/RESOURCE_USAGEを要求 | E-04（237-240行） | ○ |
| C-08 | 統計取得失敗時は空のMapにクリア | E-04（309-311行） | ○ |
| C-09 | refreshAndRescheduleRunnableをAtomicReferenceで管理 | E-01（121行） | ○ |
| C-10 | doRun()でthis==getの同一性チェック | E-05（589行） | ○ |
| C-11 | onAfter()で次回スケジュール | E-05（598-600行） | ○ |
| C-12 | 削除ノードの統計をclusterChanged()でクリーンアップ | E-03（187-206行） | ○ |
| C-13 | ClusterInfoServiceとClusterStateListenerを実装 | E-01（93行） | ○ |
| C-14 | ReceiveTimeoutTransportExceptionのハンドリング | E-04（298行） | ○ |
| C-15 | ClusterBlockExceptionのハンドリング | E-04（301-303行） | ○ |
| C-16 | volatileフィールドで統計管理 | E-01（113-119行） | ○ |
| C-17 | cluster.info.update.intervalは動的変更可能 | E-02（103行、Property.Dynamic） | ○ |
| C-18 | scheduleUnlessShuttingDownでスケジュール | E-03（168行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容のみ

## 6) レビュアーチェックリスト（最小）
- [ ] CountDownLatchによるタイムアウト待ちのロジックが正確か確認
- [ ] クラスタマネージャ変更時の旧タスク停止メカニズムが正確か確認
- [ ] ウォームノードのファイルキャッシュ統計フィルタリングが正確か確認
