---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-RemoteClusterStateCleanupManager (AsyncStaleFileDeletion)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコードの根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` 全体（1-516行）
- E-02: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` 設定定義（49-64行）
- E-03: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` cleanUpStaleFiles()（124-155行）
- E-04: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` deleteStaleClusterMetadata()（364-405行）
- E-05: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` deleteClusterMetadata()（169-354行）
- E-06: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java` AsyncStaleFileDeletion（487-515行）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.19のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトクリーンアップ間隔は5分 | E-02（51行） | ○ |
| C-02 | RETAINED_MANIFESTS=10 | E-01（49行） | ○ |
| C-03 | SKIP_CLEANUP_STATE_CHANGES=10 | E-01（50行） | ○ |
| C-04 | クラスタマネージャでのみ実行 | E-03（126行） | ○ |
| C-05 | バージョン差分チェック | E-03（130行） | ○ |
| C-06 | deleteStaleMetadataRunningで排他制御 | E-04（365行） | ○ |
| C-07 | REMOTE_PURGEスレッドプールで実行 | E-06（512-514行） | ○ |
| C-08 | AbstractAsyncTaskを継承 | E-06（487行） | ○ |
| C-09 | filesToKeepセットで保持対象を管理 | E-05（176行） | ○ |
| C-10 | 古いマニフェストのファイルを6カテゴリに分類 | E-05（177-181行） | ○ |
| C-11 | -1で無効化可能 | E-02（52-53行） | ○ |
| C-12 | setInterval()で動的に間隔更新 | E-01（114-121行） | ○ |
| C-13 | Closeableインターフェースを実装 | E-01（47行） | ○ |
| C-14 | close()でstaleFileDeletionTaskを停止 | E-01（101-105行） | ○ |
| C-15 | IOException時にcleanUpAttemptFailed統計を更新 | E-05（349行） | ○ |
| C-16 | 直近2つのUUIDを保持 | E-01（469-470行） | ○ |
| C-17 | マニフェスト一覧はlistAllInSortedOrderAsyncで取得 | E-04（370行） | ○ |
| C-18 | mustReschedule()がtrueを返す | E-06（502-504行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容のみ

## 6) レビュアーチェックリスト（最小）
- [ ] RETAINED_MANIFESTSの値（10）が運用要件を満たすか確認
- [ ] deleteClusterMetadata()のfilesToKeep構築ロジックが網羅的か確認
- [ ] ルーティングテーブル削除のIOExceptionハンドリングが適切か確認
