---
generated_at: 2026-02-03 10:01:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-AsyncRefreshTask

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **リフレッシュのメモリ影響に関する記述**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/IndexService.java` (AsyncRefreshTask内部クラス, L1539-L1559)
- E-02: `server/src/main/java/org/opensearch/index/IndexService.java` (maybeRefreshEngine, L1395-L1405)
- E-03: `server/src/main/java/org/opensearch/index/IndexService.java` (BaseAsyncTask, L1483-L1503)
- E-04: `server/src/main/java/org/opensearch/index/IndexSettings.java` (INDEX_REFRESH_INTERVAL_SETTING, L400-L402)
- E-05: `server/src/main/java/org/opensearch/index/IndexService.java` (getRefreshInterval, L1471-L1476)
- E-06: `server/src/main/java/org/opensearch/index/IndexService.java` (コンストラクタ, L200-L201, L337-L338)
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (No.2の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトリフレッシュ間隔は1秒 | E-04 (DEFAULT_REFRESH_INTERVAL) | ○ |
| C-02 | REFRESHスレッドプールで実行される | E-01 (getThreadPool: ThreadPool.Names.REFRESH) | ○ |
| C-03 | リフレッシュ間隔が0より大きい場合のみ実行 | E-02 (getRefreshInterval().millis() > 0) | ○ |
| C-04 | 各シャードでscheduledRefresh()を呼び出し | E-02 (shard.scheduledRefresh()) | ○ |
| C-05 | IndexShardClosedException/AlreadyClosedExceptionをキャッチ | E-02 (catch句) | ○ |
| C-06 | -1でリフレッシュ無効化 | E-04 (MINIMUM_REFRESH_INTERVAL = -1ms) | ○ |
| C-07 | クラスタデフォルトリフレッシュ間隔の適用 | E-05, E-06 (clusterDefaultRefreshIntervalSupplier) | ○ |
| C-08 | fixedRefreshIntervalSchedulingEnabled対応 | E-01, E-06 (fixedRefreshIntervalSchedulingEnabled) | ○ |
| C-09 | シャードレベルリフレッシュとの排他関係 | E-06 (shardLevelRefreshEnabled) | ○ |
| C-10 | mustRescheduleでIndexService未クローズとOPEN状態を確認 | E-03 | ○ |
| C-11 | toString()は"refresh"を返す | E-01 (L1557) | ○ |
| C-12 | forceパラメータの説明 | E-02 (maybeRefreshEngine(boolean force)) | ○ |
| C-13 | ニアリアルタイム検索の実現 | E-07, E-01 | ○ |
| C-14 | リフレッシュにより新しいセグメントリーダーのメモリが必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14のメモリ影響については、Lucene内部の動作に基づく一般的な知識であるが、ソースコード内に具体的なメモリ使用量の記述はない。
  - 候補：Luceneドキュメント / OpenSearch公式ドキュメント / パフォーマンスプロファイリング結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接根拠が取得できる主張がほとんど

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト間隔1秒がIndexSettings.javaのDEFAULT_REFRESH_INTERVALと一致しているか
- [ ] クラスタデフォルトリフレッシュ間隔の適用ロジックがgetRefreshInterval()と一致しているか
- [ ] シャードレベルリフレッシュとの排他関係の記述が正確か
