---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-PersistentTasksClusterService (PeriodicRechecker)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張にソースコードの根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` 全体（1-571行）
- E-02: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` 設定定義（75-81行）
- E-03: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` PeriodicRechecker（544-570行）
- E-04: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` clusterChanged()（394-405行）
- E-05: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` reassignPersistentTasks()（410-435行）
- E-06: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` reassignTasks()（481-510行）
- E-07: `server/src/main/java/org/opensearch/persistent/PersistentTasksClusterService.java` needsReassignment()（519-521行）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.20のエントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト再チェック間隔は30秒 | E-02（77行） | ○ |
| C-02 | 最小間隔は10秒 | E-02（78行） | ○ |
| C-03 | クラスタマネージャノードでのみリスナー登録 | E-01（106-108行） | ○ |
| C-04 | recheck_intervalは動的変更可能 | E-02（79行、Property.Dynamic） | ○ |
| C-05 | PeriodicRecheckerはAbstractAsyncTaskを継承 | E-03（544行） | ○ |
| C-06 | runInternal()でisClusterManagerNode確認 | E-03（557行） | ○ |
| C-07 | isAnyTaskUnassigned()で未割り当てチェック | E-03（560行） | ○ |
| C-08 | clusterChanged()でクラスタマネージャ変更時にcancel | E-04（403行） | ○ |
| C-09 | needsReassignment()は未割り当てまたはノード不存在で判定 | E-07 | ○ |
| C-10 | createAssignment()でEnableAssignmentDeciderを使用 | E-01（385-391行） | ○ |
| C-11 | NotClusterManagerException時は再スケジュールなし | E-05（420-424行） | ○ |
| C-12 | 未割り当てタスク残存時にrescheduleIfNecessary | E-05（430-432行） | ○ |
| C-13 | ClusterStateUpdateTaskとして再割り当てを実行 | E-05（411行） | ○ |
| C-14 | mustReschedule()はtrueを返す | E-03（551-553行） | ○ |
| C-15 | Closeableインターフェースを実装 | E-01（73行） | ○ |
| C-16 | close()でperiodicRechecker.close() | E-01（131行） | ○ |
| C-17 | ClusterManagerTaskThrottlerによるスロットリング | E-01（113-116行） | ○ |
| C-18 | createPersistentTask後の未割り当て時にrescheduleIfNecessary | E-01（179-181行） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから明確に読み取れる内容のみ

## 6) レビュアーチェックリスト（最小）
- [ ] shouldReassignPersistentTasks()の判定条件が網羅的に記述されているか確認
- [ ] EnableAssignmentDeciderの設定がデフォルトで有効か確認
- [ ] AbstractAsyncTaskのrescheduleIfNecessary()とcancel()の挙動が正確か確認
