---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：21-RemoteStorePinnedTimestampService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ガベージコレクション判定への影響**：直接的なコード参照はあるが影響範囲の推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `server/src/main/java/org/opensearch/node/remotestore/RemoteStorePinnedTimestampService.java`
- E-02: `server/src/main/java/org/opensearch/indices/RemoteStoreSettings.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`
- E-04: `server/src/main/java/org/opensearch/common/util/concurrent/AbstractAsyncTask.java`（クラス参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @ExperimentalApiアノテーション付き | E-01 (L52) | ○ |
| C-02 | AbstractAsyncTaskに基づく自動リスケジュール | E-01 (L285-288) | ○ |
| C-03 | デフォルト間隔3分、最小1分 | E-02 (L149-154) | ○ |
| C-04 | BlobコンテナのlistBlobs()でBlob一覧取得 | E-01 (L300) | ○ |
| C-05 | ファイル名の"__"区切りでタイムスタンプ解析 | E-01 (L57-58, L209-220) | ○ |
| C-06 | pinnedTimestampsSetは静的フィールド | E-01 (L55) | ○ |
| C-07 | pinnedEntityToTimestampsMapは静的フィールド | E-01 (L56) | ○ |
| C-08 | mustReschedule()は常にtrueを返す | E-01 (L292-294) | ○ |
| C-09 | Blob空の場合は空セットで更新 | E-01 (L301-304) | ○ |
| C-10 | NumberFormatExceptionは-1として処理しフィルタ | E-01 (L214-218, L309) | ○ |
| C-11 | Throwable catchで前回値保持 | E-01 (L324-326) | ○ |
| C-12 | forceSyncPinnedTimestamps()で即座更新可能 | E-01 (L256-258) | ○ |
| C-13 | pinTimestamp/unpinTimestampでBlob操作 | E-01 (L131-160, L239-254) | ○ |
| C-14 | pinned_timestampsパストークン | E-01 (L57, L95) | ○ |
| C-15 | ガベージコレクション判定への影響 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15：RemoteSegmentStoreDirectoryやRemoteFsTimestampAwareTranslogがピン留め情報を参照するという主張は、それらのファイルでのgetPinnedTimestamps()呼び出しに基づく推定であるが、直接的なコード確認は本レポート生成時に行っていない
  - 候補：RemoteSegmentStoreDirectory.java / RemoteFsTimestampAwareTranslog.java / BlobStoreRepository.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードから直接確認済み
- 1: 中リスク - 影響範囲の記述はコード参照関係に基づく推定を含む

## 6) レビュアーチェックリスト（最小）
- [ ] pinnedTimestampsSetとpinnedEntityToTimestampsMapの更新がアトミックでない点の影響確認
- [ ] Experimental機能としてのAPI安定性の確認
- [ ] スケジューラ間隔のデフォルト値（3分）が運用要件に適合するか確認
