---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：22-ResourceWatcherService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **利用モジュールの網羅性**：具体的な利用モジュールの列挙が完全でない可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/watcher/ResourceWatcherService.java`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3段階の頻度レベル（HIGH:5s, MEDIUM:30s, LOW:60s） | E-01 (L72-92) | ○ |
| C-02 | resource.reload.enabledがデフォルトtrue | E-01 (L94) | ○ |
| C-03 | resource.reload.interval.highがデフォルト5s | E-01 (L95-99) | ○ |
| C-04 | resource.reload.interval.mediumがデフォルト30s | E-01 (L100-104) | ○ |
| C-05 | resource.reload.interval.lowがデフォルト60s | E-01 (L105-109) | ○ |
| C-06 | enabledがfalseの場合スケジュールされない | E-01 (L130-138) | ○ |
| C-07 | ResourceMonitor.run()がsynchronizedで保護 | E-01 (L208) | ○ |
| C-08 | CopyOnWriteArraySetでWatcher管理 | E-01 (L195) | ○ |
| C-09 | IOExceptionをTRACEログで出力してスキップ | E-01 (L212-214) | ○ |
| C-10 | @PublicApi(since = "1.0.0") | E-01 (L60) | ○ |
| C-11 | デフォルト登録頻度はMEDIUM | E-01 (L153-155) | ○ |
| C-12 | SSL証明書やPainlessスクリプト等の利用モジュール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12：ResourceWatcherServiceを利用する具体的なモジュールの列挙は、Grepの結果に基づく推定であり、全ての利用箇所を完全に確認していない
  - 候補：ReindexSslConfig.java / CommonAnalysisModulePlugin.java / PainlessModulePlugin.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サービス自体のロジックはシンプルで、ソースコードから完全に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] resource.reload.enabledがfalse設定時のモジュール影響確認
- [ ] 各頻度レベルのデフォルト値が運用要件に適合するか確認
